/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.editor;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.sirius.business.api.query.DRepresentationElementQuery;
import org.eclipse.sirius.business.internal.session.SessionEventBrokerImpl;
import org.eclipse.sirius.business.internal.session.danalysis.DanglingRefRemovalTrigger;
import org.eclipse.sirius.common.ui.tools.api.util.EclipseUIUtil;
import org.eclipse.sirius.ui.business.api.dialect.DialectEditor;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.sirius.viewpoint.ViewpointPackage;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

public final class SelectCreatedDRepresentationElementsListener
extends ResourceSetListenerImpl {
    private DialectEditor dialectEditor;

    public SelectCreatedDRepresentationElementsListener(DialectEditor editor) {
        super(NotificationFilter.NOT_TOUCH.and(SessionEventBrokerImpl.asFilter((Predicate)DanglingRefRemovalTrigger.IS_ATTACHMENT)).and(NotificationFilter.createNotifierTypeFilter((EClassifier)ViewpointPackage.Literals.DREPRESENTATION).or(NotificationFilter.createNotifierTypeFilter((EClassifier)ViewpointPackage.Literals.DREPRESENTATION_ELEMENT))));
        this.dialectEditor = editor;
    }

    public boolean isPostcommitOnly() {
        return true;
    }

    public void resourceSetChanged(ResourceSetChangeEvent event) {
        IEditorPart activeEditor = EclipseUIUtil.getActiveEditor();
        if (this.dialectEditor.equals(activeEditor)) {
            DRepresentation currentRep = this.dialectEditor.getRepresentation();
            Collection<DRepresentationElement> newElementsToSelect = this.extractNewSelection(event, currentRep);
            PlatformUI.getWorkbench().getDisplay().asyncExec((Runnable)new SetSelectionRunnable(this.dialectEditor, newElementsToSelect));
        }
    }

    private Collection<DRepresentationElement> extractNewSelection(ResourceSetChangeEvent event, DRepresentation currentRep) {
        LinkedHashSet newElements = Sets.newLinkedHashSet();
        for (Notification n : event.getNotifications()) {
            Set<DRepresentationElement> notificationValues = this.getNotificationValues(n);
            for (DRepresentationElement elt : notificationValues) {
                if (currentRep != new DRepresentationElementQuery(elt).getParentRepresentation()) continue;
                newElements.add(elt);
            }
        }
        LinkedHashSet newElementsToSelect = Sets.newLinkedHashSet();
        for (DRepresentationElement elt : newElements) {
            if (newElements.contains(elt.eContainer())) continue;
            newElementsToSelect.add(elt);
        }
        return newElementsToSelect;
    }

    private Set<DRepresentationElement> getNotificationValues(Notification notification) {
        LinkedHashSet values = Sets.newLinkedHashSet();
        Object value = notification.getNewValue();
        if (value instanceof Collection) {
            Iterables.addAll((Collection)values, (Iterable)Iterables.filter((Iterable)((Collection)value), DRepresentationElement.class));
        } else if (value instanceof DRepresentationElement) {
            values.add((DRepresentationElement)value);
        }
        return values;
    }

    private static class SetSelectionRunnable
    implements Runnable {
        private final DialectEditor dialectEditor;
        private List<DRepresentationElement> newSelection;

        public SetSelectionRunnable(DialectEditor dialectEditor, Collection<DRepresentationElement> newElementsToSelect) {
            this.dialectEditor = dialectEditor;
            this.newSelection = Lists.newArrayList(newElementsToSelect);
        }

        @Override
        public void run() {
            DialectUIManager.INSTANCE.setSelection(this.dialectEditor, this.newSelection);
        }
    }
}

