/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.views.common.action;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.ecore.extender.business.api.permission.IPermissionAuthority;
import org.eclipse.sirius.ecore.extender.business.api.permission.PermissionAuthorityRegistry;
import org.eclipse.sirius.ui.tools.internal.wizards.ExtractRepresentationsWizard;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationContainer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ExtractRepresentationAction
extends Action {
    private final Session session;
    private final Collection<DRepresentation> representations;

    public ExtractRepresentationAction(Session session, Collection<DRepresentation> selection) {
        this.session = session;
        this.representations = selection;
        ImageDescriptor descriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.sirius.ui", (String)"/icons/full/others/export.gif");
        this.setImageDescriptor(descriptor);
        this.setText("Extract to .aird file ...");
        if (!this.isValidSelection()) {
            this.setEnabled(false);
        }
    }

    public void run() {
        TransactionalEditingDomain transDomain = this.session.getTransactionalEditingDomain();
        ExtractRepresentationsWizard wizard = new ExtractRepresentationsWizard(this.session, transDomain, this.representations);
        Shell defaultShell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        WizardDialog dialog = new WizardDialog(defaultShell, (IWizard)wizard);
        dialog.create();
        dialog.getShell().setText("Extract Representation Wizard");
        dialog.open();
    }

    private boolean isValidSelection() {
        boolean anyInvalidExtract = Iterables.any(this.representations, (Predicate)new Predicate<DRepresentation>(){

            public boolean apply(DRepresentation input) {
                IPermissionAuthority permissionAuthority;
                EObject container = input.eContainer();
                return container instanceof DRepresentationContainer && (permissionAuthority = PermissionAuthorityRegistry.getDefault().getPermissionAuthority(container)) != null && !permissionAuthority.canDeleteInstance((EObject)input);
            }
        });
        return !anyInvalidExtract;
    }
}

