/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.views.common.navigator;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.ui.business.api.dialect.DialectEditor;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.ui.business.api.session.IEditingSession;
import org.eclipse.sirius.ui.business.api.session.SessionEditorInput;
import org.eclipse.sirius.ui.business.api.session.SessionUIManager;
import org.eclipse.sirius.ui.tools.internal.views.common.item.RepresentationItemImpl;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.navigator.ILinkHelper;

public class SessionLinkHelper
implements ILinkHelper {
    public IStructuredSelection findSelection(IEditorInput anInput) {
        Object editorRepresentation;
        IWorkbenchPage page;
        IEditorPart editor;
        Object foundElement = null;
        IFile file = ResourceUtil.getFile((IEditorInput)anInput);
        if (file != null) {
            foundElement = file;
        }
        if ((editor = (page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage()).findEditor(anInput)) != null && (editorRepresentation = this.getEditorRepresentation(anInput, editor)) != null) {
            foundElement = editorRepresentation;
        }
        return foundElement == null ? StructuredSelection.EMPTY : new StructuredSelection(foundElement);
    }

    private Object getEditorRepresentation(IEditorInput anInput, IEditorPart editor) {
        SessionEditorInput sessionInput;
        DRepresentation foundElement = null;
        if (anInput instanceof SessionEditorInput && (sessionInput = (SessionEditorInput)anInput).getSession() != null && sessionInput.getSession().isOpen() && editor instanceof DialectEditor) {
            foundElement = ((DialectEditor)editor).getRepresentation();
        }
        return foundElement;
    }

    public void activateEditor(IWorkbenchPage aPage, IStructuredSelection aSelection) {
        if (aPage == null || aSelection == null || aSelection.isEmpty()) {
            return;
        }
        DRepresentation selectedRepresentation = this.getSelectedRepresentation(aSelection.toList());
        IEditorPart activeEditor = aPage.getActiveEditor();
        if (activeEditor != null && selectedRepresentation != null) {
            DialectEditor editor;
            IEditingSession uiSession;
            Session session = SessionManager.INSTANCE.getSession(((DSemanticDecorator)selectedRepresentation).getTarget());
            if (session != null && (uiSession = SessionUIManager.INSTANCE.getUISession(session)) != null && (editor = uiSession.getEditor(selectedRepresentation)) != null && editor.getSite() != null && aPage.equals(editor.getSite().getPage())) {
                activeEditor = editor;
                aPage.bringToTop((IWorkbenchPart)activeEditor);
            }
        } else if (activeEditor instanceof DialectEditor && activeEditor.getEditorInput() instanceof SessionEditorInput && aSelection.getFirstElement() instanceof EObject) {
            aPage.bringToTop((IWorkbenchPart)activeEditor);
            DialectEditor dialectEditor = (DialectEditor)activeEditor;
            List<DRepresentationElement> vpSelection = this.getRepresentationsForElement(dialectEditor.getRepresentation(), aSelection.toList());
            DialectUIManager.INSTANCE.setSelection(dialectEditor, vpSelection);
        }
    }

    private DRepresentation getSelectedRepresentation(Collection<?> selection) {
        DRepresentation rep = null;
        Iterable selectedReps = Iterables.filter(selection, DRepresentation.class);
        if (selectedReps.iterator().hasNext()) {
            rep = (DRepresentation)selectedReps.iterator().next();
        } else {
            Iterable selectedItems = Iterables.filter(selection, RepresentationItemImpl.class);
            if (selectedItems.iterator().hasNext()) {
                rep = ((RepresentationItemImpl)selectedItems.iterator().next()).getRepresentation();
            }
        }
        return rep;
    }

    protected final List<DRepresentationElement> getRepresentationsForElement(DRepresentation representation, List<?> selection) {
        ArrayList result = Lists.newArrayList();
        if (representation != null) {
            for (DRepresentationElement element : representation.getRepresentationElements()) {
                if (selection == null || !selection.contains(element.getTarget())) continue;
                result.add(element);
            }
        }
        return result;
    }
}

