/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.wizards.pages;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.common.ui.tools.api.dialog.FolderSelectionDialog;
import org.eclipse.sirius.common.ui.tools.api.dialog.NewFileDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class SelectAnalysisFilePage
extends WizardPage {
    private static final String SEPARATOR = "/";
    protected TreeViewer workspaceViewer;
    private Group newFileGroup;
    private Group existingFileGroup;
    private Group exportFolderGroup;
    private Button pickNewFile;
    private Button pickExistingFile;
    private Text newFilePath;
    private Button newFileBrowse;
    private String selectedFilePath;
    private Button pickFolder;
    private Text exportFolderPath;
    private Button exportFolderBrowse;

    public SelectAnalysisFilePage(String pageName) {
        super(pageName);
        this.validate();
    }

    public String getSelectedFilePath() {
        return this.selectedFilePath;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.setDescription("Select the destination file for the views");
        Composite topLevel = new Composite(parent, 0);
        topLevel.setFont(parent.getFont());
        this.createNewFileGroup(topLevel);
        this.createFolderExportGroup(topLevel);
        this.createExistingFileGroup(topLevel);
        parent.setSize(new Point(300, 200));
        topLevel.setLayout((Layout)new GridLayout());
        this.setErrorMessage(null);
        this.setControl((Control)topLevel);
        this.newFilePath.setEnabled(true);
        this.newFileBrowse.setEnabled(true);
        this.workspaceViewer.getTree().setEnabled(false);
        this.pickExistingFile.setSelection(false);
        this.pickFolder.setSelection(false);
        this.exportFolderPath.setEnabled(false);
        this.exportFolderBrowse.setEnabled(false);
        this.pickNewFile.setSelection(true);
    }

    private void createFolderExportGroup(Composite parent) {
        String groupLabel = "Extract in one distinct file per view";
        String pickButtonLabel = "Folder";
        this.exportFolderGroup = this.createExportGroup(parent, groupLabel);
        this.pickFolder = this.createPickButton(pickButtonLabel, this.exportFolderGroup);
        this.pickFolder.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                SelectAnalysisFilePage.this.pickNewFile.setSelection(false);
                SelectAnalysisFilePage.this.newFilePath.setEnabled(false);
                SelectAnalysisFilePage.this.newFileBrowse.setEnabled(false);
                SelectAnalysisFilePage.this.workspaceViewer.getTree().setEnabled(false);
                SelectAnalysisFilePage.this.pickExistingFile.setSelection(false);
                SelectAnalysisFilePage.this.exportFolderPath.setEnabled(true);
                SelectAnalysisFilePage.this.exportFolderBrowse.setEnabled(true);
                SelectAnalysisFilePage.this.pickFolder.setSelection(true);
                SelectAnalysisFilePage.this.selectedFilePath = SelectAnalysisFilePage.this.exportFolderPath.getText();
                SelectAnalysisFilePage.this.validate();
            }
        });
        this.exportFolderPath = this.createExportText(this.exportFolderGroup);
        this.exportFolderBrowse = this.createBroweButton(this.exportFolderGroup);
        this.exportFolderBrowse.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                SelectAnalysisFilePage.this.browseForFolder();
            }
        });
    }

    private Button createBroweButton(Group parentGroup) {
        GridData gridData2 = new GridData();
        gridData2.horizontalAlignment = 3;
        gridData2.verticalAlignment = 2;
        Button browseButton = new Button((Composite)parentGroup, 0);
        browseButton.setText("Browse...");
        browseButton.setLayoutData((Object)gridData2);
        return browseButton;
    }

    private void createNewFileGroup(Composite parent) {
        String groupLabel = "Extract in one distinct file per view";
        String pickButtonLabel = "New File";
        this.newFileGroup = this.createExportGroup(parent, groupLabel);
        this.pickNewFile = this.createPickButton(pickButtonLabel, this.newFileGroup);
        this.pickNewFile.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                SelectAnalysisFilePage.this.newFilePath.setEnabled(true);
                SelectAnalysisFilePage.this.newFileBrowse.setEnabled(true);
                SelectAnalysisFilePage.this.selectedFilePath = SelectAnalysisFilePage.this.newFilePath.getText();
                SelectAnalysisFilePage.this.workspaceViewer.getTree().setEnabled(false);
                SelectAnalysisFilePage.this.pickExistingFile.setSelection(false);
                SelectAnalysisFilePage.this.exportFolderPath.setEnabled(false);
                SelectAnalysisFilePage.this.pickFolder.setSelection(false);
                SelectAnalysisFilePage.this.validate();
            }
        });
        this.newFilePath = this.createExportText(this.newFileGroup);
        this.newFileBrowse = this.createBroweButton(this.newFileGroup);
        this.newFileBrowse.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                SelectAnalysisFilePage.this.browseForNewFile();
            }
        });
    }

    private Group createExportGroup(Composite parent, String groupLabel) {
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 2;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        Group group = new Group(parent, 0);
        group.setText(groupLabel);
        group.setLayoutData((Object)gridData);
        group.setLayout((Layout)gridLayout);
        return group;
    }

    private Text createExportText(Group parentGroup) {
        GridData gridData3 = new GridData();
        gridData3.horizontalAlignment = 4;
        gridData3.grabExcessHorizontalSpace = true;
        gridData3.verticalAlignment = 2;
        Text exportText = new Text((Composite)parentGroup, 2048);
        exportText.setLayoutData((Object)gridData3);
        exportText.setEditable(false);
        return exportText;
    }

    private Button createPickButton(String pickButtonLabel, Group parentGroup) {
        Button pickButton = new Button((Composite)parentGroup, 16);
        pickButton.setText(pickButtonLabel);
        return pickButton;
    }

    private void browseForNewFile() {
        NewFileDialog dialog = new NewFileDialog("newfile.aird");
        if (dialog.open() == 0 && dialog.getFirstResult() instanceof IContainer) {
            IContainer folder = (IContainer)dialog.getFirstResult();
            String newFileName = dialog.getNewFileName();
            this.selectedFilePath = !StringUtil.isEmpty((String)folder.getProjectRelativePath().toOSString()) ? SEPARATOR + folder.getProject().getName() + SEPARATOR + folder.getProjectRelativePath() + SEPARATOR + newFileName : SEPARATOR + folder.getProject().getName() + SEPARATOR + newFileName;
            this.newFilePath.setText(this.selectedFilePath);
            this.validate();
        }
    }

    private void browseForFolder() {
        FolderSelectionDialog dialog = new FolderSelectionDialog("Please select a Folder");
        if (dialog.open() == 0 && dialog.getFirstResult() instanceof IContainer) {
            IContainer folder = (IContainer)dialog.getFirstResult();
            this.selectedFilePath = !StringUtil.isEmpty((String)folder.getProjectRelativePath().toOSString()) ? SEPARATOR + folder.getProject().getName() + SEPARATOR + folder.getProjectRelativePath() + SEPARATOR : SEPARATOR + folder.getProject().getName() + SEPARATOR;
            this.exportFolderPath.setText(this.selectedFilePath);
        }
        this.validate();
    }

    private void createExistingFileGroup(Composite parent) {
        GridData gridData4 = new GridData();
        gridData4.horizontalAlignment = 4;
        gridData4.grabExcessHorizontalSpace = true;
        gridData4.grabExcessVerticalSpace = true;
        gridData4.verticalAlignment = 4;
        GridData gridData1 = new GridData();
        gridData1.horizontalAlignment = 4;
        gridData1.grabExcessHorizontalSpace = true;
        gridData1.grabExcessVerticalSpace = true;
        gridData1.verticalAlignment = 4;
        this.existingFileGroup = new Group(parent, 0);
        this.existingFileGroup.setLayout((Layout)new GridLayout());
        this.existingFileGroup.setText("Extract in an existing file");
        this.existingFileGroup.setLayoutData((Object)gridData1);
        this.pickExistingFile = new Button((Composite)this.existingFileGroup, 16);
        this.pickExistingFile.setText("Existing File");
        this.pickExistingFile.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                SelectAnalysisFilePage.this.newFilePath.setEnabled(false);
                SelectAnalysisFilePage.this.newFileBrowse.setEnabled(false);
                SelectAnalysisFilePage.this.pickNewFile.setSelection(false);
                SelectAnalysisFilePage.this.exportFolderPath.setEnabled(false);
                SelectAnalysisFilePage.this.pickFolder.setSelection(false);
                SelectAnalysisFilePage.this.selectedFilePath = null;
                SelectAnalysisFilePage.this.workspaceViewer.getTree().setEnabled(true);
                SelectAnalysisFilePage.this.pickExistingFile.setSelection(true);
                Object element = ((StructuredSelection)SelectAnalysisFilePage.this.workspaceViewer.getSelection()).getFirstElement();
                if (element instanceof IFile) {
                    IFile file = (IFile)element;
                    SelectAnalysisFilePage.this.selectedFilePath = SelectAnalysisFilePage.SEPARATOR + file.getProject().getName() + SelectAnalysisFilePage.SEPARATOR + file.getProjectRelativePath().toOSString();
                }
                SelectAnalysisFilePage.this.validate();
            }
        });
        this.workspaceViewer = new TreeViewer((Composite)this.existingFileGroup, 2820){

            public void setSelection(ISelection selection, boolean reveal) {
                Object element = ((StructuredSelection)selection).getFirstElement();
                Widget item = this.findItem(element);
                if (item == null) {
                    Object[] expandedElements = this.getExpandedElements();
                    this.expandAll();
                    item = this.findItem(element);
                    this.setExpandedElements(expandedElements);
                }
                if (item != null && item.getData() != null) {
                    super.setSelection((ISelection)new StructuredSelection(item.getData()), reveal);
                }
            }
        };
        this.workspaceViewer.getTree().setLayoutData((Object)gridData4);
        this.workspaceViewer.setContentProvider((IContentProvider)new WorkbenchContentProvider());
        this.workspaceViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.workspaceViewer.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        this.workspaceViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                IFile file;
                return !(element instanceof IFile) || (file = (IFile)element).getFileExtension() == null || file.getFileExtension().equals("aird");
            }
        });
        this.workspaceViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object element;
                SelectAnalysisFilePage.this.selectedFilePath = null;
                if (event.getSelection() instanceof StructuredSelection && (element = ((StructuredSelection)event.getSelection()).getFirstElement()) instanceof IFile) {
                    IFile file = (IFile)element;
                    SelectAnalysisFilePage.this.selectedFilePath = SelectAnalysisFilePage.SEPARATOR + file.getProject().getName() + SelectAnalysisFilePage.SEPARATOR + file.getProjectRelativePath().toOSString();
                }
                SelectAnalysisFilePage.this.validate();
            }
        });
    }

    private void validate() {
        this.setPageComplete(true);
        if (this.selectedFilePath == null) {
            this.setPageComplete(false);
            return;
        }
        if (StringUtil.isEmpty((String)this.selectedFilePath)) {
            this.setPageComplete(false);
        }
    }
}

