/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.movida;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.sirius.business.api.query.ViewpointURIQuery;
import org.eclipse.sirius.business.internal.movida.registry.ViewpointRegistry;
import org.eclipse.sirius.viewpoint.description.Viewpoint;

public class ViewpointSelection {
    private static final String INVALID_VIEWPOINT_URI = "Selection must contain only logical Viewpoint URIs";
    private final Set<URI> logicalViewpoints = Sets.newHashSet();
    private final ViewpointRegistry registry;
    private boolean needsValidation;
    private boolean isValid;
    private Set<URI> unavailable = Collections.emptySet();
    private Set<URI> conflicts = Collections.emptySet();
    private final Predicate<URI> isValidViewpointURI = new Predicate<URI>(){

        public boolean apply(URI input) {
            return ViewpointURIQuery.isValidViewpointURI(input);
        }
    };
    private final Function<URI, Viewpoint> viewpointImplementation = new Function<URI, Viewpoint>(){

        public Viewpoint apply(URI from) {
            return ViewpointSelection.this.registry.getViewpoint(from);
        }
    };

    public ViewpointSelection(ViewpointRegistry registry) {
        this.registry = (ViewpointRegistry)Preconditions.checkNotNull((Object)registry);
    }

    public Set<URI> getSelected() {
        return ImmutableSet.copyOf(this.logicalViewpoints);
    }

    public void setSelected(Set<URI> selection) {
        Preconditions.checkArgument((boolean)Iterables.all(selection, this.isValidViewpointURI), (Object)INVALID_VIEWPOINT_URI);
        this.logicalViewpoints.clear();
        this.logicalViewpoints.addAll(selection);
        this.needsValidation = true;
    }

    public void select(URI viewpoint) {
        Preconditions.checkArgument((boolean)this.isValidViewpointURI.apply((Object)viewpoint), (Object)INVALID_VIEWPOINT_URI);
        boolean added = this.logicalViewpoints.add(viewpoint);
        if (added) {
            this.needsValidation = true;
        }
    }

    public void deselect(URI viewpoint) {
        Preconditions.checkArgument((boolean)this.isValidViewpointURI.apply((Object)viewpoint), (Object)INVALID_VIEWPOINT_URI);
        boolean removed = this.logicalViewpoints.remove(viewpoint);
        if (removed) {
            this.needsValidation = true;
        }
    }

    public boolean isValid() {
        this.validate();
        return this.isValid;
    }

    public Set<URI> getUnavailableViewpoints() {
        return ImmutableSet.copyOf(this.unavailable);
    }

    public Set<URI> getConflictingViewpoints() {
        return ImmutableSet.copyOf(this.conflicts);
    }

    public void validate() {
        if (this.needsValidation) {
            this.isValid = this.allRequiredViewpointAreAvailable() && this.noConflictsBetweenRequiredViewpoints();
            this.needsValidation = false;
        }
    }

    public String getErrorMessage() {
        this.validate();
        Function<URI, String> shortName = new Function<URI, String>(){

            public String apply(URI uri) {
                return new ViewpointURIQuery(uri).getViewpointName();
            }
        };
        StringBuilder sb = new StringBuilder();
        if (this.conflicts != null && !this.conflicts.isEmpty()) {
            sb.append("Conflicts with: " + Joiner.on((String)", ").join(Iterables.transform(this.conflicts, (Function)shortName))).append("\n");
        }
        if (this.unavailable != null && !this.unavailable.isEmpty()) {
            sb.append("Missing: " + Joiner.on((String)", ").join(Iterables.transform(this.unavailable, (Function)shortName))).append("\n");
        }
        return sb.toString();
    }

    private boolean allRequiredViewpointAreAvailable() {
        this.unavailable = Sets.newHashSet((Iterable)Iterables.filter(this.logicalViewpoints, (Predicate)new Predicate<URI>(){

            public boolean apply(URI input) {
                return ViewpointSelection.this.viewpointImplementation.apply((Object)input) == null;
            }
        }));
        return this.unavailable.isEmpty();
    }

    private boolean noConflictsBetweenRequiredViewpoints() {
        HashSet forbidden = Sets.newHashSet();
        for (URI uri : this.logicalViewpoints) {
            Viewpoint vp = (Viewpoint)this.viewpointImplementation.apply((Object)uri);
            if (vp == null) continue;
            Iterables.addAll((Collection)forbidden, vp.getConflicts());
        }
        this.conflicts = Sets.intersection(this.logicalViewpoints, (Set)forbidden);
        return this.conflicts.isEmpty();
    }

    public String toString() {
        ArrayList uris = Lists.newArrayList(this.logicalViewpoints);
        Collections.sort(uris, Ordering.usingToString());
        return "Viewpoint Selection: " + Joiner.on((String)", ").join((Iterable)uris);
    }
}

