/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.resource;

import java.io.IOException;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLLoad;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.sirius.business.api.session.resource.AirdResource;
import org.eclipse.sirius.business.api.session.resource.DResource;
import org.eclipse.sirius.business.internal.migration.RepresentationsFileMigrationService;
import org.eclipse.sirius.business.internal.resource.AirdResourceXMILoad;
import org.eclipse.sirius.business.internal.resource.parser.RepresentationsFileXMIHelper;
import org.eclipse.sirius.common.tools.DslCommonPlugin;
import org.eclipse.sirius.ext.base.Option;

public class AirDResourceImpl
extends XMIResourceImpl
implements DResource,
AirdResource {
    public static final String OPTION_ABORT_ON_ERROR = "ABORT_ON_ERROR";
    private static ThreadLocal<Integer> nbLoadInProgress = new ThreadLocal<Integer>(){

        @Override
        protected synchronized Integer initialValue() {
            return 0;
        }
    };

    public AirDResourceImpl(URI uri) {
        super(uri);
    }

    protected boolean useUUIDs() {
        return true;
    }

    protected boolean useIDAttributes() {
        return false;
    }

    protected static void incrementLoadInProgress() {
        nbLoadInProgress.set(nbLoadInProgress.get() + 1);
    }

    protected static void decrementLoadInProgress() {
        nbLoadInProgress.set(nbLoadInProgress.get() - 1);
    }

    protected static boolean hasLoadInProgress() {
        return nbLoadInProgress.get() != 0;
    }

    public void setTrackingModification(boolean isTrackingModification) {
    }

    public void load(Map<?, ?> options) throws IOException {
        DslCommonPlugin.PROFILER.startWork("Load aird file");
        AirDResourceImpl.incrementLoadInProgress();
        try {
            super.load(options);
        }
        finally {
            AirDResourceImpl.decrementLoadInProgress();
        }
        DslCommonPlugin.PROFILER.stopWork("Load aird file");
    }

    protected XMLHelper createXMLHelper() {
        return new RepresentationsFileXMIHelper((XMLResource)this);
    }

    protected XMLLoad createXMLLoad(Map<?, ?> options) {
        if (options != null && options.containsKey("RESOURCE_MIGRATION_LOADEDVERSION")) {
            String loadedVersion = null;
            Object mapVersion = options.get("RESOURCE_MIGRATION_LOADEDVERSION");
            if (mapVersion instanceof String) {
                loadedVersion = (String)mapVersion;
            }
            return new AirdResourceXMILoad(loadedVersion, this.createXMLHelper());
        }
        return new AirdResourceXMILoad(this.createXMLHelper());
    }

    public EObject getEObject(String uriFragment) {
        Option<String> optionalRewrittenFragment = RepresentationsFileMigrationService.getInstance().getNewFragment(uriFragment);
        if (optionalRewrittenFragment.some()) {
            return this.getEObject((String)optionalRewrittenFragment.get());
        }
        return super.getEObject(uriFragment);
    }
}

