/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.session;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.business.api.query.URIQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionListener;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.business.api.session.SessionManagerListener;
import org.eclipse.sirius.business.api.session.factory.SessionFactory;
import org.eclipse.sirius.business.internal.session.SessionTransientAttachment;
import org.eclipse.sirius.common.tools.api.util.EclipseUtil;
import org.eclipse.sirius.common.tools.api.util.MarkerUtil;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.viewpoint.DAnalysisSessionEObject;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.sirius.viewpoint.impl.SessionManagerEObjectImpl;

public class SessionManagerImpl
extends SessionManagerEObjectImpl
implements SessionManager {
    private Set<SessionManagerListener> extensionPointListeners;
    private Set<SessionManagerListener> programmaticListeners = Sets.newLinkedHashSet();
    private Set<Viewpoint> selectedViewpoints = new HashSet<Viewpoint>();
    private final Map<Session, SessionListener> sessionsToListeners = Maps.newHashMap();

    public static SessionManagerImpl init() {
        return new SessionManagerImpl();
    }

    @Override
    public void addSessionsListener(SessionManagerListener listener) {
        this.programmaticListeners.add(listener);
    }

    @Override
    public Collection<Session> getSessions() {
        return Collections.unmodifiableCollection(this.doGetSessions());
    }

    private Collection<? extends Session> doGetSessions() {
        return this.sessionsToListeners.keySet();
    }

    @Override
    public void removeSessionsListener(SessionManagerListener listener) {
        this.programmaticListeners.remove(listener);
        this.getExtensionPointListeners().remove(listener);
    }

    @Override
    public void add(final Session newSession) {
        Assert.isNotNull((Object)newSession, (String)"SessionManager can't add a null Session");
        if (!this.doGetSessions().contains(newSession)) {
            if (newSession instanceof DAnalysisSessionEObject) {
                this.getOwnedSessions().add((Object)((DAnalysisSessionEObject)((Object)newSession)));
            }
            SessionListener sessListener = new SessionListener(){

                @Override
                public void notify(int changeKind) {
                    if (changeKind == 0) {
                        SessionManagerImpl.this.fireVPSelectionDeselectionEvents();
                    }
                    SessionManagerImpl.this.notifyUpdatedSession(newSession, changeKind);
                }
            };
            newSession.addListener(sessListener);
            this.sessionsToListeners.put(newSession, sessListener);
            LinkedHashSet listenersToIterate = Sets.newLinkedHashSet(this.getAllListeners());
            for (SessionManagerListener listener : listenersToIterate) {
                listener.notifyAddSession(newSession);
            }
            this.fireVPSelectionDeselectionEvents();
        }
    }

    private void notifyUpdatedSession(Session newSession, int changeKind) {
        for (SessionManagerListener listener : Iterables.filter((Iterable)Lists.newArrayList(this.getAllListeners()), SessionManagerListener.class)) {
            listener.notify(newSession, changeKind);
        }
    }

    @Override
    public void remove(Session removedSession) {
        if (this.doGetSessions().contains(removedSession)) {
            this.getOwnedSessions().remove((Object)removedSession);
            SessionListener sessListener = this.sessionsToListeners.get(removedSession);
            if (sessListener != null) {
                removedSession.removeListener(sessListener);
            }
            this.sessionsToListeners.remove(removedSession);
            LinkedHashSet listenersToIterate = Sets.newLinkedHashSet(this.getAllListeners());
            for (SessionManagerListener listener : listenersToIterate) {
                listener.notifyRemoveSession(removedSession);
            }
            this.fireVPSelectionDeselectionEvents();
            if (this.sessionsToListeners.isEmpty()) {
                SiriusPlugin.getDefault().getModelAccessorRegistry().dispose();
            }
        }
    }

    @Override
    public Session getSession(EObject any) {
        Session found;
        block8: {
            found = null;
            if (any instanceof Resource) {
                found = this.getSession((Resource)any);
            } else if (any != null) {
                Option<SessionTransientAttachment> attachment = SessionTransientAttachment.getSessionTransientAttachement((Notifier)any);
                if (attachment.some()) {
                    return ((SessionTransientAttachment)((Object)attachment.get())).getSession();
                }
                try {
                    Resource resource;
                    Resource res;
                    EObject root = EcoreUtil.getRootContainer((EObject)any);
                    Resource resource2 = res = root != null ? root.eResource() : null;
                    if (res != null) {
                        found = this.getSession(res);
                    }
                    if (found == null && any != null && (resource = any.eResource()) != null) {
                        found = this.getSession(resource);
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    if (!SiriusPlugin.getDefault().isDebugging()) break block8;
                    SiriusPlugin.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.sirius", "Error while connecting to remote CDO server"));
                }
            }
        }
        return found;
    }

    @Override
    public Session getSession(Resource semanticResource) {
        Session found = null;
        Option<SessionTransientAttachment> attachment = SessionTransientAttachment.getSessionTransientAttachement((Notifier)semanticResource);
        if (attachment.some()) {
            found = ((SessionTransientAttachment)((Object)attachment.get())).getSession();
        }
        if (found == null) {
            Iterator<? extends Session> sessionsIter = this.doGetSessions().iterator();
            while (sessionsIter.hasNext() && found == null) {
                Session sess = sessionsIter.next();
                ArrayList<Resource> semanticResources = new ArrayList<Resource>(sess.getSemanticResources());
                if (semanticResources.contains(semanticResource)) {
                    found = sess;
                    continue;
                }
                if (!(sess instanceof DAnalysisSessionEObject) || !((DAnalysisSessionEObject)((Object)sess)).getControlledResources().contains((Object)semanticResource)) continue;
                found = sess;
            }
        }
        return found;
    }

    @Override
    public Session getSession(URI sessionModelURI, IProgressMonitor monitor) {
        Session session;
        Option<IResource> optionalResource = new URIQuery(sessionModelURI).getCorrespondingResource();
        if (optionalResource.some()) {
            MarkerUtil.removeMarkerFor((IResource)((IResource)optionalResource.get()), (String)"org.eclipse.sirius.viewpointMarker");
        }
        if ((session = this.lookForAlreadyLoadedSession(sessionModelURI)) == null) {
            try {
                session = SessionFactory.INSTANCE.createSession(sessionModelURI, monitor);
            }
            catch (CoreException e) {
                SiriusPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.sirius", "Error while loading representations file " + sessionModelURI.toPlatformString(true), (Throwable)e));
                if (optionalResource.some()) {
                    String message = "Error while loading representations file";
                    if (e != null) {
                        message = String.valueOf(message) + ": " + (e.getCause() != null ? e.getCause().getMessage() : e.getMessage());
                    }
                    message = String.valueOf(message) + ". See error log for more details";
                    MarkerUtil.addMarkerFor((IResource)((IResource)optionalResource.get()), (String)message, (int)2, (String)"org.eclipse.sirius.viewpointMarker");
                }
                return null;
            }
        }
        return session;
    }

    @Override
    public Session getExistingSession(URI sessionResourceURI) {
        return this.lookForAlreadyLoadedSession(sessionResourceURI);
    }

    private Session lookForAlreadyLoadedSession(URI sessionModelURI) {
        Session alreadyLoadedSession = null;
        for (Session loadedSession : this.getSessions()) {
            if (!loadedSession.getSessionResource().getURI().equals(sessionModelURI)) continue;
            alreadyLoadedSession = loadedSession;
        }
        return alreadyLoadedSession;
    }

    @Override
    public void notifyRepresentationCreated(Session session) {
        if (this.doGetSessions().contains(session)) {
            this.notifyUpdatedSession(session, 10);
        }
    }

    @Override
    public void notifyRepresentationDeleted(Session session) {
        if (this.doGetSessions().contains(session)) {
            this.notifyUpdatedSession(session, 10);
        }
    }

    @Override
    public void notifyRepresentationRenamed(Session session) {
        if (this.doGetSessions().contains(session)) {
            this.notifyUpdatedSession(session, 10);
        }
    }

    private void fireVPSelectionDeselectionEvents() {
        Set<Viewpoint> newSelectedViewpoints = this.collectSelectedViewpoints();
        HashSet<Viewpoint> selectingViewpoints = new HashSet<Viewpoint>(newSelectedViewpoints);
        selectingViewpoints.removeAll(this.selectedViewpoints);
        for (Viewpoint viewpoint : selectingViewpoints) {
            this.fireSelectedViewpointEvent(viewpoint);
        }
        HashSet<Viewpoint> deselectingViewpoints = new HashSet<Viewpoint>(this.selectedViewpoints);
        deselectingViewpoints.removeAll(newSelectedViewpoints);
        for (Viewpoint viewpoint : deselectingViewpoints) {
            this.fireDeselectedViewpointEvent(viewpoint);
        }
        this.selectedViewpoints = newSelectedViewpoints;
    }

    private Set<Viewpoint> collectSelectedViewpoints() {
        HashSet<Viewpoint> result = new HashSet<Viewpoint>();
        for (Session session : this.doGetSessions()) {
            result.addAll(session.getSelectedViewpoints(false));
        }
        return result;
    }

    private void fireSelectedViewpointEvent(Viewpoint viewpoint) {
        for (SessionManagerListener listener : this.getAllListeners()) {
            listener.viewpointSelected(viewpoint);
        }
    }

    private void fireDeselectedViewpointEvent(Viewpoint viewpoint) {
        for (SessionManagerListener listener : this.getAllListeners()) {
            listener.viewpointDeselected(viewpoint);
        }
    }

    private synchronized Iterable<SessionManagerListener> getAllListeners() {
        return Iterables.concat(this.getExtensionPointListeners(), this.programmaticListeners);
    }

    private synchronized Set<SessionManagerListener> getExtensionPointListeners() {
        if (this.extensionPointListeners == null) {
            this.extensionPointListeners = Sets.newLinkedHashSet();
            this.extensionPointListeners.addAll(EclipseUtil.getExtensionPlugins(SessionManagerListener.class, (String)"org.eclipse.sirius.sessionManagerListener", (String)"class"));
        }
        return this.extensionPointListeners;
    }
}

