/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.session.danalysis;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.sirius.business.internal.session.danalysis.DAnalysisSessionImpl;

public class ControlledResourcesDetector
extends ResourceSetListenerImpl {
    private static final NotificationFilter CONTROLLED_RESOURCES_EVENTS = NotificationFilter.createFeatureFilter(ResourceSet.class, (int)0).and(NotificationFilter.NOT_TOUCH);
    private DAnalysisSessionImpl session;

    public ControlledResourcesDetector(DAnalysisSessionImpl session) {
        this.session = (DAnalysisSessionImpl)Preconditions.checkNotNull((Object)session);
    }

    public void initialize() {
        this.session.getTransactionalEditingDomain().addResourceSetListener((ResourceSetListener)this);
    }

    public NotificationFilter getFilter() {
        return CONTROLLED_RESOURCES_EVENTS;
    }

    public boolean isPrecommitOnly() {
        return true;
    }

    public boolean isAggregatePrecommitListener() {
        return true;
    }

    public Command transactionAboutToCommit(ResourceSetChangeEvent event) throws RollbackException {
        for (Notification notif : event.getNotifications()) {
            boolean resourcesWereAdded;
            int change = notif.getEventType();
            boolean bl = resourcesWereAdded = change == 3 || change == 1 || change == 5;
            if (!resourcesWereAdded) continue;
            return new RefreshControlledResourcesCommand(this.session);
        }
        return null;
    }

    public void dispose() {
        if (this.session != null) {
            this.session.getTransactionalEditingDomain().removeResourceSetListener((ResourceSetListener)this);
        }
        this.session = null;
    }

    static void refreshControlledResources(DAnalysisSessionImpl session) {
        Collection<Resource> semantics = session.getSemanticResources();
        ArrayList allResources = Lists.newArrayList((Iterable)session.getTransactionalEditingDomain().getResourceSet().getResources());
        EList<Resource> controlledResources = session.getControlledResources();
        boolean addedControlledResources = false;
        for (Resource resource : allResources) {
            if (controlledResources.contains(resource) || !ControlledResourcesDetector.hasControlledRootIn(resource, semantics)) continue;
            if (controlledResources instanceof InternalEList) {
                ((InternalEList)controlledResources).addUnique((Object)resource);
            } else {
                controlledResources.add(resource);
            }
            addedControlledResources = true;
            session.registerResourceInCrossReferencer(resource);
        }
        boolean removedControlledResources = controlledResources.retainAll(allResources);
        if (addedControlledResources || removedControlledResources) {
            session.notifyListeners(11);
            session.setSemanticResourcesNotUptodate();
        }
    }

    private static boolean hasControlledRootIn(Resource resource, Collection<Resource> scope) {
        for (EObject root : resource.getContents()) {
            Resource containerResource;
            EObject container = root.eContainer();
            Resource resource2 = containerResource = container != null ? container.eResource() : null;
            if (containerResource == resource || !scope.contains(containerResource)) continue;
            return true;
        }
        return false;
    }

    private static class RefreshControlledResourcesCommand
    extends RecordingCommand {
        private final DAnalysisSessionImpl session;

        public RefreshControlledResourcesCommand(DAnalysisSessionImpl session) {
            super(session.getTransactionalEditingDomain(), "Controlled resource detection");
            this.session = session;
        }

        protected void doExecute() {
            ControlledResourcesDetector.refreshControlledResources(this.session);
        }
    }
}

