/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.session.danalysis;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.helper.SiriusHelper;
import org.eclipse.sirius.business.api.helper.SiriusUtil;
import org.eclipse.sirius.business.api.query.DRepresentationQuery;
import org.eclipse.sirius.business.api.query.RepresentationDescriptionQuery;
import org.eclipse.sirius.business.api.session.SessionService;
import org.eclipse.sirius.business.api.session.danalysis.DAnalysisSelector;
import org.eclipse.sirius.business.api.session.danalysis.DAnalysisSessionHelper;
import org.eclipse.sirius.business.api.session.danalysis.DAnalysisSessionService;
import org.eclipse.sirius.business.internal.session.danalysis.DAnalysisSessionImpl;
import org.eclipse.sirius.common.tools.api.util.EqualityHelper;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DAnalysisCustomData;
import org.eclipse.sirius.viewpoint.DFeatureExtension;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationContainer;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.DView;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.sirius.viewpoint.ViewpointFactory;
import org.eclipse.sirius.viewpoint.description.AnnotationEntry;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;

public class DAnalysisSessionServicesImpl
implements SessionService,
DAnalysisSessionService {
    private final DAnalysisSessionImpl session;
    private DAnalysisSelector analysisSelector;

    public DAnalysisSessionServicesImpl(DAnalysisSessionImpl session) {
        this.session = (DAnalysisSessionImpl)Preconditions.checkNotNull((Object)session);
    }

    @Override
    public void clearCustomData(EObject associatedInstance) {
    }

    @Override
    public void clearCustomData(String key, EObject associatedInstance) {
        Collection<DAnalysis> analysisAndReferenced = this.session.allAnalyses();
        Collection<Resource> resources = this.getResources(analysisAndReferenced);
        if ("DREPRESENTATION".equals(key)) {
            this.clearRepresentationData(associatedInstance, analysisAndReferenced);
        } else if ("GMF_DIAGRAMS".equals(key)) {
            this.clearGMFDiagramsData(associatedInstance, resources, analysisAndReferenced);
        }
    }

    private void clearRepresentationData(EObject associatedInstance, Collection<DAnalysis> analysisAndReferenced) {
        for (DRepresentation rep : this.getAllRepresentations(analysisAndReferenced)) {
            if (!(rep instanceof DSemanticDecorator) || ((DSemanticDecorator)((Object)rep)).getTarget() != associatedInstance) continue;
            SiriusUtil.delete(rep);
        }
    }

    private Collection<DRepresentation> getAllRepresentations(Collection<DAnalysis> analysisAndReferenced) {
        ArrayList representations = Lists.newArrayList();
        for (DAnalysis analysis : analysisAndReferenced) {
            for (DView view : analysis.getOwnedViews()) {
                representations.addAll(view.getOwnedRepresentations());
            }
        }
        return representations;
    }

    private void clearGMFDiagramsData(EObject associatedInstance, Collection<Resource> resources, Collection<DAnalysis> analysisAndReferenced) {
        ArrayList toRemove = Lists.newArrayList();
        for (Resource res : resources) {
            toRemove.addAll(this.getGMFDiagramsData(associatedInstance, res));
        }
        if (associatedInstance instanceof DRepresentation) {
            for (AnnotationEntry annotation : ((DRepresentation)associatedInstance).getOwnedAnnotationEntries()) {
                if (!annotation.getSource().equals("GMF_DIAGRAMS")) continue;
                toRemove.add(annotation);
            }
        }
        for (EObject eObject : toRemove) {
            SiriusUtil.delete(eObject);
        }
    }

    @Override
    public Collection<EObject> getCustomData(String key, EObject associatedInstance) {
        Collection<DAnalysis> analysisAndReferenced = this.session.allAnalyses();
        Collection<Resource> resources = this.getResources(analysisAndReferenced);
        Collection<Object> datas = Collections.emptySet();
        if ("GMF_DIAGRAMS".equals(key)) {
            datas = this.getGMFDiagramsData(associatedInstance);
            datas.addAll(this.getGMFDiagramsData(associatedInstance, resources));
        } else {
            datas = "DREPRESENTATION".equals(key) ? this.getRepresentationData(associatedInstance, analysisAndReferenced) : ("DREPRESENTATION_FROM_DESCRIPTION".equals(key) ? this.getRepresentationFromDescData(associatedInstance, analysisAndReferenced) : ("DFEATUREEXTENSION".equals(key) ? this.getFeatureExtensionsData(associatedInstance, resources) : this.getCustomKeyData(resources)));
        }
        return datas;
    }

    private Collection<EObject> getCustomKeyData(Collection<Resource> resources) {
        ArrayList datas = Lists.newArrayList();
        for (Resource res : resources) {
            for (EObject object : res.getContents()) {
                if (!(object instanceof DAnalysisCustomData)) continue;
                datas.add(((DAnalysisCustomData)object).getData());
            }
        }
        return datas;
    }

    private Collection<EObject> getRepresentationData(final EObject associatedInstance, final Collection<DAnalysis> analysisAndReferenced) {
        RunnableWithResult.Impl<Collection<EObject>> runnable = new RunnableWithResult.Impl<Collection<EObject>>(){

            public void run() {
                ArrayList<DRepresentation> datas = new ArrayList<DRepresentation>();
                for (DAnalysis analysis : analysisAndReferenced) {
                    for (DView view : analysis.getOwnedViews()) {
                        for (DRepresentation rep : view.getOwnedRepresentations()) {
                            if (!(rep instanceof DSemanticDecorator)) continue;
                            EObject element = ((DSemanticDecorator)((Object)rep)).getTarget();
                            if (element != null && element == associatedInstance) {
                                datas.add(rep);
                                continue;
                            }
                            if (associatedInstance != null) continue;
                            datas.add(rep);
                        }
                    }
                }
                this.setResult(datas);
            }
        };
        if (associatedInstance != null) {
            TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)associatedInstance);
            if (domain != null) {
                try {
                    TransactionUtil.runExclusive((TransactionalEditingDomain)domain, (RunnableWithResult)runnable);
                }
                catch (InterruptedException e) {
                    SiriusPlugin.getDefault().error(e.getLocalizedMessage(), e);
                }
            } else {
                runnable.run();
            }
        } else {
            runnable.run();
        }
        return (Collection)runnable.getResult();
    }

    private Collection<EObject> getRepresentationFromDescData(EObject associatedInstance, Collection<DAnalysis> analysisAndReferenced) {
        ArrayList datas = Lists.newArrayList();
        for (DAnalysis analysis : analysisAndReferenced) {
            for (DView view : analysis.getOwnedViews()) {
                for (DRepresentation rep : view.getOwnedRepresentations()) {
                    RepresentationDescription currentRepresentationDescription = DialectManager.INSTANCE.getDescription(rep);
                    if (!EqualityHelper.areEquals((EObject)currentRepresentationDescription, (EObject)associatedInstance)) continue;
                    datas.add(rep);
                }
            }
        }
        return datas;
    }

    private Collection<EObject> getGMFDiagramsData(EObject associatedInstance, Collection<Resource> resources) {
        ArrayList datas = Lists.newArrayList();
        for (Resource res : resources) {
            datas.addAll(this.getGMFDiagramsData(associatedInstance, res));
        }
        return datas;
    }

    private Collection<EObject> getGMFDiagramsData(EObject representation) {
        ArrayList datas = Lists.newArrayList();
        if (representation instanceof DRepresentation) {
            DRepresentation dRepresentation = (DRepresentation)representation;
            for (AnnotationEntry annotation : new DRepresentationQuery(dRepresentation).getAnnotation("GMF_DIAGRAMS")) {
                datas.add(annotation.getData());
            }
        }
        return datas;
    }

    private Collection<EObject> getGMFDiagramsData(EObject associatedInstance, Resource res) {
        ArrayList datas = Lists.newArrayList();
        for (EObject object : res.getContents()) {
            if (!this.isAGMFDiagramOnAssociatedInstance(object, associatedInstance)) continue;
            datas.add(object);
        }
        return datas;
    }

    private Collection<EObject> getFeatureExtensionsData(EObject associatedInstance, Collection<Resource> resources) {
        ArrayList datas = Lists.newArrayList();
        for (Resource res : resources) {
            for (EObject object : res.getContents()) {
                if (!(object instanceof DFeatureExtension)) continue;
                datas.add(object);
            }
        }
        return datas;
    }

    @Override
    public void putCustomData(String key, EObject associatedInstance, EObject data) {
        if ("GMF_DIAGRAMS".equals(key)) {
            if (associatedInstance instanceof DRepresentation) {
                SiriusHelper.getOrCreateAnnotation("GMF_DIAGRAMS", (DRepresentation)associatedInstance, data);
            }
        } else if ("DREPRESENTATION".equals(key)) {
            Resource res;
            EObject semanticTarget;
            if (data instanceof DRepresentation && (semanticTarget = associatedInstance) != null && (res = semanticTarget.eResource()) != null) {
                this.addRepresentationToContainer((DRepresentation)data, res);
            }
        } else if ("DFEATUREEXTENSION".equals(key)) {
            Resource resource = associatedInstance.eResource();
            if (resource != null) {
                resource.getContents().add((Object)data);
            }
        } else {
            Resource resource = associatedInstance.eResource();
            if (resource != null) {
                DAnalysisCustomData customData = ViewpointFactory.eINSTANCE.createDAnalysisCustomData();
                customData.setKey(key);
                customData.setData(data);
                resource.getContents().add((Object)customData);
            }
        }
    }

    private Collection<Resource> getResources(Collection<DAnalysis> analysisAndReferenced) {
        ArrayList resources = Lists.newArrayList();
        for (DAnalysis analysis : analysisAndReferenced) {
            Resource res = analysis.eResource();
            if (res == null) continue;
            resources.add(res);
        }
        return resources;
    }

    private boolean isAGMFDiagramOnAssociatedInstance(EObject object, EObject associatedInstance) {
        EObject element;
        return "Diagram".equals(object.eClass().getName()) && object.eClass().getEPackage() != null && "notation".equals(object.eClass().getEPackage().getNsPrefix()) && (element = (EObject)object.eGet(object.eClass().getEStructuralFeature("element"))) != null && element == associatedInstance;
    }

    private void addRepresentationToContainer(DRepresentation representation, Resource res) {
        Viewpoint viewpoint;
        EObject semanticRoot = (EObject)res.getContents().iterator().next();
        DRepresentationContainer existingContainer = DAnalysisSessionHelper.findContainerForAddedRepresentation(semanticRoot, viewpoint = new RepresentationDescriptionQuery(DialectManager.INSTANCE.getDescription(representation)).getParentViewpoint(), this.session.allAnalyses(), this.analysisSelector, representation);
        if (existingContainer == null && (existingContainer = DAnalysisSessionHelper.findFreeContainerForAddedRepresentation(viewpoint, semanticRoot, this.session.getAnalyses(), this.analysisSelector, representation)) != null) {
            existingContainer.setViewpoint(viewpoint);
        }
        if (existingContainer == null) {
            existingContainer = ViewpointFactory.eINSTANCE.createDRepresentationContainer();
            existingContainer.setViewpoint(viewpoint);
            DAnalysis analysis = DAnalysisSessionHelper.selectAnalysis(viewpoint, this.session.allAnalyses(), this.analysisSelector, representation);
            analysis.getOwnedViews().add((Object)existingContainer);
        }
        existingContainer.getOwnedRepresentations().add((Object)representation);
    }

    @Override
    public void setAnalysisSelector(DAnalysisSelector selector) {
        this.analysisSelector = selector;
    }
}

