/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.session.danalysis;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.sirius.business.api.query.URIQuery;
import org.eclipse.sirius.business.internal.session.danalysis.ControlledResourcesDetector;
import org.eclipse.sirius.business.internal.session.danalysis.DAnalysisRefresher;
import org.eclipse.sirius.business.internal.session.danalysis.DAnalysisSessionImpl;
import org.eclipse.sirius.business.internal.session.danalysis.SemanticResourceGetter;
import org.eclipse.sirius.business.internal.session.danalysis.SemanticResourcesUpdater;
import org.eclipse.sirius.common.tools.DslCommonPlugin;
import org.eclipse.sirius.ecore.extender.tool.api.ModelUtils;
import org.eclipse.sirius.ext.emf.EReferencePredicate;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DView;
import org.eclipse.sirius.viewpoint.SiriusPlugin;

class SessionResourcesTracker {
    private DAnalysisSessionImpl session;
    private Collection<Resource> semanticResources;
    private SemanticResourcesUpdater semanticResourcesUpdater;
    private ControlledResourcesDetector controlledResourcesDetector;
    private DAnalysisRefresher dAnalysisRefresher;

    SessionResourcesTracker(DAnalysisSessionImpl session) {
        this.session = (DAnalysisSessionImpl)Preconditions.checkNotNull((Object)session);
        this.controlledResourcesDetector = new ControlledResourcesDetector(session);
        this.dAnalysisRefresher = new DAnalysisRefresher(session);
    }

    void initialize(IProgressMonitor monitor) {
        DslCommonPlugin.PROFILER.startWork("Resolve All");
        Collection<DAnalysis> analyses = this.session.allAnalyses();
        this.resolveAllVSMResources(analyses);
        this.resolveAllSemanticResourcesFromModels(analyses);
        ArrayList resourcesBeforeLoadOfSession = Lists.newArrayList((Iterable)this.session.getTransactionalEditingDomain().getResourceSet().getResources());
        this.forceLoadingOfEveryLinkedResource();
        monitor.worked(10);
        SessionResourcesTracker.addAutomaticallyLoadedResourcesToSemanticResources(this.session, resourcesBeforeLoadOfSession);
        monitor.worked(1);
        DslCommonPlugin.PROFILER.stopWork("Resolve All");
        ControlledResourcesDetector.refreshControlledResources(this.session);
        if (this.controlledResourcesDetector != null) {
            this.controlledResourcesDetector.initialize();
        }
        if (this.semanticResourcesUpdater != null) {
            this.semanticResourcesUpdater.dispose();
            this.semanticResourcesUpdater = null;
        }
        this.semanticResources = null;
        monitor.worked(1);
        this.dAnalysisRefresher.initialize();
    }

    void addAdaptersOnAnalysis(DAnalysis analysis) {
        if (this.semanticResourcesUpdater != null && !analysis.eAdapters().contains((Object)this.semanticResourcesUpdater)) {
            analysis.eAdapters().add((Object)this.semanticResourcesUpdater);
        }
    }

    void removeAdaptersOnAnalysis(DAnalysis analysis) {
        if (this.semanticResourcesUpdater != null && analysis.eAdapters().contains((Object)this.semanticResourcesUpdater)) {
            analysis.eAdapters().remove((Object)this.semanticResourcesUpdater);
        }
    }

    Collection<Resource> getSemanticResources() {
        if (this.semanticResources == null) {
            this.semanticResources = new CopyOnWriteArrayList<Resource>();
            if (this.semanticResourcesUpdater == null) {
                this.semanticResourcesUpdater = new SemanticResourcesUpdater(this.session);
            }
            this.semanticResourcesUpdater.setSemanticResources(this.semanticResources);
            RunnableWithResult.Impl<Collection<Resource>> semanticResourcesGetter = new RunnableWithResult.Impl<Collection<Resource>>(){

                public void run() {
                    this.setResult(SemanticResourceGetter.collectTopLevelSemanticResources(SessionResourcesTracker.this.session));
                }
            };
            try {
                TransactionUtil.runExclusive((TransactionalEditingDomain)this.session.getTransactionalEditingDomain(), (RunnableWithResult)semanticResourcesGetter);
            }
            catch (InterruptedException interruptedException) {
                SiriusPlugin.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.sirius", "Error while accessing semantic resources"));
            }
            ((CopyOnWriteArrayList)this.semanticResources).addAllAbsent((Collection)semanticResourcesGetter.getResult());
        }
        return Collections.unmodifiableCollection(this.semanticResources);
    }

    void setSemanticResourcesNotUptodate() {
        this.semanticResources.clear();
        this.semanticResources = null;
    }

    private void forceLoadingOfEveryLinkedResource() {
        ModelUtils.resolveAll((ResourceSet)this.session.getTransactionalEditingDomain().getResourceSet(), (EReferencePredicate)new EReferencePredicate(){

            public boolean apply(EReference input) {
                return !input.isDerived() && !input.isContainer() && !input.isContainment();
            }
        });
    }

    private void resolveAllVSMResources(Collection<DAnalysis> allAnalysis) {
        ArrayList resolvedResources = Lists.newArrayList();
        for (DAnalysis dAnalysis : allAnalysis) {
            for (DView dView : dAnalysis.getOwnedViews()) {
                Resource vsmResource;
                if (dView.getViewpoint() == null || (vsmResource = dView.getViewpoint().eResource()) == null || resolvedResources.contains(vsmResource)) continue;
                ModelUtils.resolveAll((Resource)vsmResource, (boolean)true);
                resolvedResources.add(vsmResource);
            }
        }
    }

    private void resolveAllSemanticResourcesFromModels(Collection<DAnalysis> allAnalysis) {
        for (DAnalysis dAnalysis : allAnalysis) {
            for (EObject model : dAnalysis.getModels()) {
                EcoreUtil.resolve((EObject)model, (EObject)dAnalysis);
            }
        }
    }

    static void addAutomaticallyLoadedResourcesToSemanticResources(final DAnalysisSessionImpl session, List<Resource> knownResources) {
        TransactionalEditingDomain domain = session.getTransactionalEditingDomain();
        ArrayList resourcesAfterLoadOfSession = Lists.newArrayList((Iterable)domain.getResourceSet().getResources());
        Iterators.removeAll(resourcesAfterLoadOfSession.iterator(), knownResources);
        Iterators.removeAll(resourcesAfterLoadOfSession.iterator(), session.getSemanticResources());
        Iterators.removeAll(resourcesAfterLoadOfSession.iterator(), session.getReferencedSessionResources());
        final Iterable newSemanticResourcesIterator = Iterables.filter((Iterable)resourcesAfterLoadOfSession, (Predicate)new Predicate<Resource>(){

            public boolean apply(Resource resource) {
                return !resource.getContents().isEmpty() && !new URIQuery(resource.getURI()).isEnvironmentURI();
            }
        });
        if (!Iterables.isEmpty((Iterable)newSemanticResourcesIterator)) {
            domain.getCommandStack().execute((Command)new RecordingCommand(domain, "Add referenced semantic resources"){

                protected void doExecute() {
                    for (Resource resource : newSemanticResourcesIterator) {
                        session.addSemanticResource(resource.getURI(), (IProgressMonitor)new NullProgressMonitor());
                    }
                }
            });
        }
    }

    void dispose() {
        this.session = null;
        if (this.dAnalysisRefresher != null) {
            this.dAnalysisRefresher.dispose();
            this.dAnalysisRefresher = null;
        }
        if (this.controlledResourcesDetector != null) {
            this.controlledResourcesDetector.dispose();
            this.controlledResourcesDetector = null;
        }
        if (this.semanticResourcesUpdater != null) {
            this.semanticResourcesUpdater.dispose();
            this.semanticResourcesUpdater = null;
        }
        if (this.semanticResources != null) {
            this.semanticResources.clear();
        }
    }

    void detectControlledResources() {
        ControlledResourcesDetector.refreshControlledResources(this.session);
    }
}

