/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.editors.template.actions.refactor;

import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.acceleo.internal.ide.ui.editors.template.AcceleoEditor;
import org.eclipse.acceleo.internal.ide.ui.editors.template.AcceleoSourceContent;
import org.eclipse.acceleo.parser.cst.CSTNode;
import org.eclipse.acceleo.parser.cst.ForBlock;
import org.eclipse.acceleo.parser.cst.LetBlock;
import org.eclipse.acceleo.parser.cst.Macro;
import org.eclipse.acceleo.parser.cst.Query;
import org.eclipse.acceleo.parser.cst.Template;
import org.eclipse.acceleo.parser.cst.Variable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractRefactoringWithVariableContextAction
extends Action
implements IWorkbenchWindowActionDelegate,
IObjectActionDelegate {
    public void run(IAction action) {
        super.run();
        AcceleoEditor editor = null;
        IDocument document = null;
        ITextSelection selection = null;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && window.getActivePage() != null && window.getActivePage().getActiveEditor() instanceof AcceleoEditor) {
            editor = (AcceleoEditor)window.getActivePage().getActiveEditor();
            document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
            if (editor.getSelectionProvider() != null && editor.getSelectionProvider().getSelection() instanceof ITextSelection) {
                selection = (ITextSelection)editor.getSelectionProvider().getSelection();
            }
            if (editor.getContent() != null && document != null && selection != null && selection.getLength() > 0) {
                try {
                    int newOffset = this.modify(document, editor.getContent(), selection.getOffset(), selection.getLength());
                    if (newOffset > -1) {
                        editor.selectAndReveal(newOffset, 0);
                    }
                }
                catch (BadLocationException ex) {
                    AcceleoUIActivator.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.acceleo.ide.ui", ex.getMessage(), (Throwable)ex));
                }
            }
        }
    }

    protected abstract int modify(IDocument var1, AcceleoSourceContent var2, int var3, int var4) throws BadLocationException;

    protected String getCurrentVariableTypeName(CSTNode currentNode, String defaultType) {
        Variable eContext = null;
        if (currentNode instanceof Template) {
            Template iTemplate = (Template)currentNode;
            if (iTemplate.getParameter().size() > 0) {
                eContext = (Variable)iTemplate.getParameter().get(0);
            }
        } else if (currentNode instanceof Query) {
            Query iQuery = (Query)currentNode;
            if (iQuery.getParameter().size() > 0) {
                eContext = (Variable)iQuery.getParameter().get(0);
            }
        } else if (currentNode instanceof Macro) {
            Macro iMacro = (Macro)currentNode;
            if (iMacro.getParameter().size() > 0) {
                eContext = (Variable)iMacro.getParameter().get(0);
            }
        } else if (currentNode instanceof ForBlock) {
            eContext = ((ForBlock)currentNode).getLoopVariable();
        } else if (currentNode instanceof LetBlock) {
            eContext = ((LetBlock)currentNode).getLetVariable();
        }
        String res = eContext != null && eContext.getType() != null ? eContext.getType() : (currentNode != null && currentNode.eContainer() instanceof CSTNode ? this.getCurrentVariableTypeName((CSTNode)currentNode.eContainer(), defaultType) : defaultType);
        return res;
    }

    protected String getCurrentVariableName(CSTNode currentNode, String defaultName) {
        Variable eContext = null;
        if (currentNode instanceof Template) {
            Template iTemplate = (Template)currentNode;
            if (iTemplate.getParameter().size() > 0) {
                eContext = (Variable)iTemplate.getParameter().get(0);
            }
        } else if (currentNode instanceof Query) {
            Query iQuery = (Query)currentNode;
            if (iQuery.getParameter().size() > 0) {
                eContext = (Variable)iQuery.getParameter().get(0);
            }
        } else if (currentNode instanceof Macro) {
            Macro iMacro = (Macro)currentNode;
            if (iMacro.getParameter().size() > 0) {
                eContext = (Variable)iMacro.getParameter().get(0);
            }
        } else if (currentNode instanceof ForBlock) {
            eContext = ((ForBlock)currentNode).getLoopVariable();
        } else if (currentNode instanceof LetBlock) {
            eContext = ((LetBlock)currentNode).getLetVariable();
        }
        String res = eContext != null && eContext.getName() != null ? eContext.getName() : (currentNode != null && currentNode.eContainer() instanceof CSTNode ? this.getCurrentVariableName((CSTNode)currentNode.eContainer(), defaultName) : defaultName);
        return res;
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }
}

