/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.design.ui.action;

import java.util.Collection;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.presentation.DynamicModelWizard;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.sirius.tools.api.ui.IExternalJavaAction;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateDynamicInstanceAction
implements IExternalJavaAction {
    private static final URI PLATFORM_RESOURCE = URI.createPlatformResourceURI((String)"/", (boolean)false);

    public boolean canExecute(Collection<? extends EObject> selections) {
        return this.getSemanticTarget(selections) != null;
    }

    private EClass getSemanticTarget(Collection<? extends EObject> selections) {
        if (selections == null || selections.size() != 1) {
            return null;
        }
        EObject selection = selections.iterator().next();
        EObject semanticTarget = selection instanceof DSemanticDecorator ? ((DSemanticDecorator)selection).getTarget() : selection;
        if (semanticTarget instanceof EClass) {
            return (EClass)semanticTarget;
        }
        return null;
    }

    public void execute(Collection<? extends EObject> selections, Map<String, Object> parameters) {
        IFile file;
        EClass eClass = this.getSemanticTarget(selections);
        URI uri = eClass.eResource().getURI();
        StructuredSelection selection = StructuredSelection.EMPTY;
        if (uri != null && uri.isHierarchical() && (uri.isRelative() || (uri = uri.deresolve(PLATFORM_RESOURCE)).isRelative()) && (file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uri.toString()))).exists()) {
            selection = new StructuredSelection((Object)file);
        }
        DynamicModelWizard dynamicModelWizard = new DynamicModelWizard(eClass);
        dynamicModelWizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)selection);
        dynamicModelWizard.setWindowTitle("Create Dynamic Instance");
        WizardDialog wizardDialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)dynamicModelWizard);
        wizardDialog.open();
    }
}

