/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.design.service;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.ecore.util.EcoreSwitch;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelatedElementsSwitch
extends EcoreSwitch<List<EObject>> {
    private Set<EObject> relateds;
    private Collection<EStructuralFeature.Setting> xRefs;
    private ECrossReferenceAdapter referencer;

    public RelatedElementsSwitch() {
    }

    public RelatedElementsSwitch(ECrossReferenceAdapter xRef) {
        this.referencer = xRef;
    }

    public List<EObject> getRelatedElements(EObject ctx) {
        Session sess = SessionManager.INSTANCE.getSession(ctx);
        this.relateds = Sets.newLinkedHashSet();
        if (sess != null) {
            this.xRefs = sess.getSemanticCrossReferencer().getInverseReferences(ctx);
        } else if (this.referencer != null) {
            this.xRefs = this.referencer.getInverseReferences(ctx);
        }
        this.doSwitch(ctx);
        this.relateds.remove(ctx);
        this.relateds.remove(null);
        return ImmutableList.copyOf(this.relateds);
    }

    public List<EObject> caseEClass(EClass object) {
        this.relateds.addAll((Collection<EObject>)object.getESuperTypes());
        for (EStructuralFeature.Setting xRef : this.xRefs) {
            if (xRef.getEObject() instanceof EClass) {
                this.relateds.add(xRef.getEObject());
                continue;
            }
            if (!(xRef.getEObject() instanceof EReference) || xRef.getEStructuralFeature() != EcorePackage.eINSTANCE.getEReference_EReferenceType()) continue;
            this.relateds.add((EObject)((EReference)xRef.getEObject()).getEContainingClass());
        }
        for (EReference eRef : object.getEReferences()) {
            if (eRef.getEType() == null) continue;
            this.relateds.add((EObject)eRef.getEType());
        }
        return (List)super.caseEClass(object);
    }

    public List<EObject> caseEOperation(EOperation object) {
        if (object.getEType() != null) {
            this.relateds.add((EObject)object.getEType());
        }
        for (EParameter param : object.getEParameters()) {
            if (param.getEType() == null) continue;
            this.relateds.add((EObject)param.getEType());
        }
        return (List)super.caseEOperation(object);
    }

    public List<EObject> caseEReference(EReference object) {
        this.relateds.add((EObject)object.getEType());
        return (List)super.caseEReference(object);
    }

    public List<EObject> caseEPackage(EPackage object) {
        this.relateds.addAll((Collection<EObject>)object.getEClassifiers());
        return (List)super.caseEPackage(object);
    }
}

