/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.common.ui.action.global;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.common.ui.action.AbstractActionHandler;
import org.eclipse.gmf.runtime.common.ui.action.internal.CommonUIActionDebugOptions;
import org.eclipse.gmf.runtime.common.ui.action.internal.CommonUIActionPlugin;
import org.eclipse.gmf.runtime.common.ui.action.internal.global.GlobalActionHandlerData;
import org.eclipse.gmf.runtime.common.ui.services.action.global.GlobalActionContext;
import org.eclipse.gmf.runtime.common.ui.services.action.global.GlobalActionHandlerContext;
import org.eclipse.gmf.runtime.common.ui.services.action.global.GlobalActionHandlerService;
import org.eclipse.gmf.runtime.common.ui.services.action.global.IGlobalActionContext;
import org.eclipse.gmf.runtime.common.ui.services.action.global.IGlobalActionHandler;
import org.eclipse.gmf.runtime.common.ui.services.action.global.IGlobalActionHandlerContext;
import org.eclipse.gmf.runtime.common.ui.services.action.global.IGlobalActionHandlerProvider;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

public abstract class GlobalAction
extends AbstractActionHandler {
    private final String workbenchActionConstant = this.getActionId();
    private String defaultLabel;

    public GlobalAction(IWorkbenchPart workbenchPart) {
        super(workbenchPart);
        assert (workbenchPart != null);
        this.setEnabled(false);
    }

    public GlobalAction(IWorkbenchPage workbenchPage) {
        super(workbenchPage);
        assert (workbenchPage != null);
        this.setEnabled(false);
    }

    protected void doRun(IProgressMonitor progressMonitor) {
        Vector<ICommand> list = new Vector<ICommand>();
        List handlerInfo = this.getGlobalActionHandlerData();
        for (GlobalActionHandlerData data : handlerInfo) {
            ICommand command = data.getHandler().getCommand(data.getContext());
            if (command == null) continue;
            list.addElement(command);
        }
        if (list.size() <= 0) {
            return;
        }
        ICommand operation = this.createCompositeCommand(list).reduce();
        try {
            IStatus status = this.getOperationHistory().execute((IUndoableOperation)operation, progressMonitor, null);
            if (!status.isOK()) {
                Log.log((Plugin)CommonUIActionPlugin.getDefault(), (IStatus)status);
            }
        }
        catch (ExecutionException e) {
            Trace.catching((Plugin)CommonUIActionPlugin.getDefault(), (String)CommonUIActionDebugOptions.EXCEPTIONS_CATCHING, ((Object)((Object)this)).getClass(), (String)"doRun", (Throwable)e);
            Log.error((Plugin)CommonUIActionPlugin.getDefault(), (int)3, (String)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public void refresh() {
        boolean enable = false;
        try {
            List handlerInfo = this.getGlobalActionHandlerData();
            if (this.defaultLabel != null) {
                this.setText(this.defaultLabel);
            }
            for (GlobalActionHandlerData data : handlerInfo) {
                String label;
                if (data.getHandler().canHandle(data.getContext()) && !enable) {
                    enable = true;
                }
                if (handlerInfo.size() != 1 || (label = data.getHandler().getLabel(data.getContext())) == null) continue;
                this.setText(label);
            }
        }
        catch (Throwable exception) {
            enable = false;
            Trace.catching((Plugin)CommonUIActionPlugin.getDefault(), (String)CommonUIActionDebugOptions.EXCEPTIONS_CATCHING, ((Object)((Object)this)).getClass(), (String)"refresh", (Throwable)exception);
            Status status = new Status(2, CommonUIActionPlugin.getPluginId(), 6, String.valueOf(exception.getMessage()), exception);
            Log.log((Plugin)CommonUIActionPlugin.getDefault(), (IStatus)status);
        }
        this.setEnabled(enable);
    }

    public abstract String getActionId();

    protected CompositeCommand createCompositeCommand(List commands) {
        assert (commands != null);
        CompositeCommand result = new CompositeCommand(this.getLabel(), commands);
        IUndoContext undoContext = this.getUndoContext();
        if (undoContext != null) {
            result.addContext(undoContext);
        }
        return result;
    }

    protected IUndoContext getUndoContext() {
        IWorkbenchPart part = this.getWorkbenchPart();
        if (part != null) {
            return (IUndoContext)part.getAdapter(IUndoContext.class);
        }
        return null;
    }

    protected IGlobalActionContext createContext() {
        return new GlobalActionContext(this.getWorkbenchPart(), this.getSelection(), this.getLabel(), this.getActionId());
    }

    protected List getGlobalActionHandlerData() {
        if (this.getSelection() instanceof ITextSelection) {
            return this.getGlobalActionHandlerData((ITextSelection)this.getSelection());
        }
        if (this.getSelection() instanceof IStructuredSelection) {
            return this.getGlobalActionHandlerData((IStructuredSelection)this.getSelection());
        }
        return new ArrayList();
    }

    private List getGlobalActionHandlerData(List listOfElementTypes) {
        assert (listOfElementTypes != null);
        ArrayList<IGlobalActionHandler> listOfHandlers = new ArrayList<IGlobalActionHandler>();
        for (Class clazz : listOfElementTypes) {
            GlobalActionHandlerContext context = new GlobalActionHandlerContext(this.getWorkbenchPart(), this.getActionId(), clazz, false);
            IGlobalActionHandler handler = GlobalActionHandlerService.getInstance().getGlobalActionHandler((IGlobalActionHandlerContext)context);
            if (handler == null) {
                context = new GlobalActionHandlerContext(this.getWorkbenchPart(), this.getActionId(), clazz, true);
                handler = GlobalActionHandlerService.getInstance().getGlobalActionHandler((IGlobalActionHandlerContext)context);
            }
            if (handler == null || listOfHandlers.contains(handler)) continue;
            listOfHandlers.add(handler);
        }
        ArrayList<GlobalActionHandlerData> handlerData = new ArrayList<GlobalActionHandlerData>();
        IGlobalActionContext actionContext = this.createContext();
        int i = 0;
        while (i < listOfHandlers.size()) {
            IGlobalActionHandler handler = (IGlobalActionHandler)listOfHandlers.get(i);
            handlerData.add(new GlobalActionHandlerData(handler, actionContext));
            ++i;
        }
        return handlerData;
    }

    private List getGlobalActionHandlerData(IStructuredSelection selection) {
        assert (selection != null);
        ArrayList listOfElementTypes = new ArrayList();
        if (selection.isEmpty()) {
            listOfElementTypes.add(IGlobalActionHandlerProvider.NullElementType.class);
        } else {
            Object[] array = selection.toArray();
            int i = 0;
            while (i < array.length) {
                if (!listOfElementTypes.contains(array[i].getClass())) {
                    listOfElementTypes.add(array[i].getClass());
                }
                ++i;
            }
        }
        return this.getGlobalActionHandlerData(listOfElementTypes);
    }

    private List getGlobalActionHandlerData(ITextSelection selection) {
        assert (selection != null);
        Class<?> clazz = selection.getClass();
        ArrayList listOfElementTypes = new ArrayList();
        listOfElementTypes.add(clazz);
        return this.getGlobalActionHandlerData(listOfElementTypes);
    }

    protected String getWorkbenchActionConstant() {
        return this.workbenchActionConstant;
    }

    protected List getObjectContextGlobalActionHandlerData() {
        GlobalActionHandlerContext context = new GlobalActionHandlerContext(this.getWorkbenchPart(), this.getActionId(), Object.class, false);
        IGlobalActionHandler globalActionHandler = GlobalActionHandlerService.getInstance().getGlobalActionHandler((IGlobalActionHandlerContext)context);
        if (globalActionHandler == null) {
            return new ArrayList();
        }
        GlobalActionHandlerData data = new GlobalActionHandlerData(globalActionHandler, this.createContext());
        ArrayList<GlobalActionHandlerData> list = new ArrayList<GlobalActionHandlerData>();
        list.add(data);
        return list;
    }

    public void init() {
        super.init();
        this.defaultLabel = this.getLabel();
    }
}

