/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.tools.internal.resource;

import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.sirius.common.tools.api.resource.ResourceSyncClient;

public class ResourceSyncClientNotifier
extends Job {
    public static final String FAMILY = "org.eclipse.sirius.common.ResourceSyncClientNotification";
    private static final String ACTION_NAME = "ResourceSyncClient notification";
    private static final ISchedulingRule MUTEX = new ISchedulingRule(){

        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return rule == this;
        }
    };
    private ResourceSyncClient resourceSyncClient;
    private Collection<ResourceSyncClient.ResourceStatusChange> changes;

    public ResourceSyncClientNotifier(ResourceSyncClient resourceSyncClient, Collection<ResourceSyncClient.ResourceStatusChange> changes) {
        super(ACTION_NAME);
        this.resourceSyncClient = resourceSyncClient;
        this.changes = changes;
        this.setRule(MUTEX);
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            monitor.beginTask(ACTION_NAME, this.changes.size());
            this.resourceSyncClient.statusesChanged(this.changes);
            monitor.worked(this.changes.size());
        }
        finally {
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    public boolean belongsTo(Object family) {
        return FAMILY.equals(family);
    }
}

