/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.business.internal.dialect;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.image.ImageFileFormat;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditDomain;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.parts.DiagramDocumentEditor;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.sirius.business.api.helper.SiriusResourceHelper;
import org.eclipse.sirius.business.api.query.EObjectQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.common.tools.DslCommonPlugin;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.DiagramPlugin;
import org.eclipse.sirius.diagram.business.api.diagramtype.DiagramTypeDescriptorRegistry;
import org.eclipse.sirius.diagram.business.api.diagramtype.IDiagramTypeDescriptor;
import org.eclipse.sirius.diagram.business.api.refresh.CanonicalSynchronizer;
import org.eclipse.sirius.diagram.business.api.refresh.CanonicalSynchronizerFactory;
import org.eclipse.sirius.diagram.description.DescriptionFactory;
import org.eclipse.sirius.diagram.description.DescriptionPackage;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.DiagramExtensionDescription;
import org.eclipse.sirius.diagram.description.Layer;
import org.eclipse.sirius.diagram.description.concern.provider.ConcernItemProviderAdapterFactory;
import org.eclipse.sirius.diagram.description.filter.provider.FilterItemProviderAdapterFactory;
import org.eclipse.sirius.diagram.description.provider.DescriptionItemProviderAdapterFactory;
import org.eclipse.sirius.diagram.description.style.provider.StyleItemProviderAdapterFactory;
import org.eclipse.sirius.diagram.description.tool.EdgeCreationDescription;
import org.eclipse.sirius.diagram.description.tool.ToolFactory;
import org.eclipse.sirius.diagram.description.tool.provider.ToolItemProviderAdapterFactory;
import org.eclipse.sirius.diagram.provider.DiagramItemProviderAdapterFactory;
import org.eclipse.sirius.diagram.ui.business.api.view.SiriusGMFHelper;
import org.eclipse.sirius.diagram.ui.business.internal.command.CreateAndStoreGMFDiagramCommand;
import org.eclipse.sirius.diagram.ui.business.internal.dialect.DiagramDialectArrangeOperation;
import org.eclipse.sirius.diagram.ui.business.internal.dialect.HierarchyLabelProvider;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDDiagramEditPart;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.tools.api.part.DiagramEditPartService;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ui.business.api.dialect.DialectEditor;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIServices;
import org.eclipse.sirius.ui.business.api.dialect.ExportFormat;
import org.eclipse.sirius.ui.business.api.session.SessionEditorInput;
import org.eclipse.sirius.ui.business.api.viewpoint.ViewpointSelection;
import org.eclipse.sirius.ui.business.api.viewpoint.ViewpointSelectionCallback;
import org.eclipse.sirius.ui.business.internal.commands.ChangeViewpointSelectionCommand;
import org.eclipse.sirius.ui.tools.api.actions.export.SizeTooLargeException;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.sirius.viewpoint.description.DescriptionPackage;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.RepresentationExtensionDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.sirius.viewpoint.description.tool.ToolPackage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class DiagramDialectUIServices
implements DialectUIServices {
    public static final String REFRESH_DIAGRAM = "Refresh diagram";
    private static final String EXPORT_DIAGRAM_AS_IMAGE_ERROR_ON_CREATE_IMAGE = "The program was not able to create image file ";

    public IEditorPart openEditor(Session session, DRepresentation dRepresentation, IProgressMonitor monitor) {
        DialectEditor result = null;
        try {
            monitor.beginTask("diagram opening", 15);
            DslCommonPlugin.PROFILER.startWork("Open diagram");
            if (dRepresentation instanceof DSemanticDiagram) {
                DSemanticDiagram diag = (DSemanticDiagram)dRepresentation;
                Collection gmfDiags = session.getServices().getCustomData("GMF_DIAGRAMS", (EObject)diag);
                if (gmfDiags.isEmpty()) {
                    TransactionalEditingDomain domain = session.getTransactionalEditingDomain();
                    domain.getCommandStack().execute((Command)new CreateAndStoreGMFDiagramCommand(session, diag));
                    gmfDiags.addAll(session.getServices().getCustomData("GMF_DIAGRAMS", (EObject)diag));
                    monitor.worked(1);
                }
                Set<Viewpoint> viewpointsActivated = null;
                if ("cdo".equals(diag.eResource().getURI().scheme())) {
                    viewpointsActivated = this.activateNeededViewpoints(session, (DDiagram)diag, monitor);
                }
                for (EObject object : gmfDiags) {
                    Diagram gmfDiag = (Diagram)object;
                    if (gmfDiag == null) continue;
                    result = this.openEditor(session, gmfDiag, dRepresentation, monitor);
                    new DiagramDialectArrangeOperation().arrange((IEditorPart)result, (DDiagram)diag);
                    monitor.worked(3);
                }
                if (viewpointsActivated != null && !viewpointsActivated.isEmpty()) {
                    this.informOfActivateNeededViewpoints(viewpointsActivated);
                }
            }
            DslCommonPlugin.PROFILER.stopWork("Open diagram");
        }
        finally {
            monitor.done();
        }
        return result;
    }

    private DialectEditor openEditor(Session session, Diagram gmfDiag, DRepresentation dRepresentation, IProgressMonitor monitor) {
        DialectEditor dialectEditor = null;
        URI uri = EcoreUtil.getURI((EObject)gmfDiag);
        String editorName = DialectUIManager.INSTANCE.getEditorName(dRepresentation);
        monitor.worked(1);
        SessionEditorInput editorInput = new SessionEditorInput(uri, editorName, session);
        monitor.subTask("diagram editor opening : " + dRepresentation.getName());
        RunnableWithResult.Impl<DialectEditor> runnable = new RunnableWithResult.Impl<DialectEditor>((IEditorInput)editorInput){
            private final /* synthetic */ IEditorInput val$editorInput;
            {
                this.val$editorInput = iEditorInput;
            }

            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IEditorPart editorPart = page.openEditor(this.val$editorInput, "org.eclipse.sirius.diagram.ui.part.SiriusDiagramEditorID");
                    if (editorPart instanceof DialectEditor) {
                        this.setResult((DialectEditor)editorPart);
                    }
                }
                catch (PartInitException e) {
                    DiagramPlugin.getDefault().logError("diagram editor opening error", (Throwable)e);
                }
            }
        };
        PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)runnable);
        monitor.worked(10);
        if (runnable.getResult() != null) {
            dialectEditor = (DialectEditor)runnable.getResult();
        }
        return dialectEditor;
    }

    private Set<Viewpoint> activateNeededViewpoints(Session session, DDiagram dDiagram, IProgressMonitor monitor) {
        EList activatedLayers = dDiagram.getActivatedLayers();
        LinkedHashSet<Viewpoint> neededViewpoints = new LinkedHashSet<Viewpoint>();
        for (Layer activatedLayer : activatedLayers) {
            if (activatedLayer.eIsProxy() || activatedLayer.eContainer() == null) continue;
            Viewpoint viewpoint = (Viewpoint)activatedLayer.eContainer().eContainer();
            neededViewpoints.add(viewpoint);
        }
        LinkedHashSet<Viewpoint> selectedViewpoints = new LinkedHashSet<Viewpoint>();
        for (Viewpoint viewpoint : session.getSelectedViewpoints(false)) {
            selectedViewpoints.add(SiriusResourceHelper.getCorrespondingViewpoint((Session)session, (Viewpoint)viewpoint));
        }
        neededViewpoints.removeAll(selectedViewpoints);
        if (!neededViewpoints.isEmpty()) {
            ChangeViewpointSelectionCommand changeViewpointsSelectionCmd = new ChangeViewpointSelectionCommand(session, (ViewpointSelection.Callback)new ViewpointSelectionCallback(), neededViewpoints, Collections.emptySet(), (IProgressMonitor)new SubProgressMonitor(monitor, neededViewpoints.size()));
            session.getTransactionalEditingDomain().getCommandStack().execute((Command)changeViewpointsSelectionCmd);
            monitor.worked(1);
        }
        return neededViewpoints;
    }

    private void informOfActivateNeededViewpoints(Set<Viewpoint> viewpointsActivated) {
        Iterator<Viewpoint> iterator = viewpointsActivated.iterator();
        Viewpoint neededSirius = iterator.next();
        String viewpointsName = neededSirius.getName();
        while (iterator.hasNext()) {
            neededSirius = iterator.next();
            viewpointsName = String.valueOf(viewpointsName) + ", " + neededSirius.getName();
        }
        final String description = viewpointsName;
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)"Viewpoints selection", (String)("The current diagram requires some viewpoints selected (" + description + "), because some activated layers are contributed by these viewpoints"));
            }
        });
    }

    private void synchronizeDiagram(Diagram diagram) {
        CanonicalSynchronizer canonicalSynchronizer = CanonicalSynchronizerFactory.INSTANCE.createCanonicalSynchronizer(diagram);
        canonicalSynchronizer.storeViewsToArrange(false);
        canonicalSynchronizer.synchronize();
    }

    public boolean canHandleEditor(IEditorPart editorPart) {
        return editorPart instanceof DiagramDocumentEditor;
    }

    public boolean closeEditor(IEditorPart editorPart, boolean save) {
        boolean result = false;
        if (editorPart instanceof DiagramDocumentEditor) {
            block5: {
                try {
                    ((DiagramDocumentEditor)editorPart).getDiagramEditPart().deactivate();
                }
                catch (NullPointerException nullPointerException) {
                    DiagramPlugin.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.sirius.diagram", "Error while deactivating the representation, the remote server may be unreachable."));
                }
                try {
                    ((DiagramDocumentEditor)editorPart).close(save);
                }
                catch (NullPointerException nullPointerException) {
                    if (!DiagramUIPlugin.getPlugin().isDebugging()) break block5;
                    DiagramUIPlugin.getPlugin().getLog().log((IStatus)new Status(2, "org.eclipse.sirius.diagram.ui", "Error while closing the representation, the remote server may be unreachable."));
                }
            }
            result = true;
        }
        return result;
    }

    public Collection<CommandParameter> provideNewChildDescriptors() {
        ArrayList<CommandParameter> newChilds = new ArrayList<CommandParameter>();
        newChilds.addAll(this.getDiagramTypesCreation());
        return newChilds;
    }

    public Collection<CommandParameter> provideRepresentationCreationToolDescriptors(Object feature) {
        ArrayList<CommandParameter> newChilds = new ArrayList<CommandParameter>();
        newChilds.add(new CommandParameter(null, feature, (Object)ToolFactory.eINSTANCE.createDiagramCreationDescription()));
        return newChilds;
    }

    public Collection<CommandParameter> provideRepresentationNavigationToolDescriptors(Object feature) {
        ArrayList<CommandParameter> newChilds = new ArrayList<CommandParameter>();
        newChilds.add(new CommandParameter(null, feature, (Object)ToolFactory.eINSTANCE.createDiagramNavigationDescription()));
        return newChilds;
    }

    public AdapterFactory createAdapterFactory() {
        ComposedAdapterFactory factory = new ComposedAdapterFactory();
        for (IDiagramTypeDescriptor diagramTypeDescriptor : DiagramTypeDescriptorRegistry.getInstance().getAllDiagramTypeDescriptors()) {
            AdapterFactory aFactory = diagramTypeDescriptor.getDiagramDescriptionProvider().getAdapterFactory();
            if (aFactory == null) continue;
            factory.addAdapterFactory(aFactory);
        }
        factory.addAdapterFactory((AdapterFactory)new DescriptionItemProviderAdapterFactory());
        factory.addAdapterFactory((AdapterFactory)new DiagramItemProviderAdapterFactory());
        factory.addAdapterFactory((AdapterFactory)new StyleItemProviderAdapterFactory());
        factory.addAdapterFactory((AdapterFactory)new ToolItemProviderAdapterFactory());
        factory.addAdapterFactory((AdapterFactory)new FilterItemProviderAdapterFactory());
        factory.addAdapterFactory((AdapterFactory)new ConcernItemProviderAdapterFactory());
        return factory;
    }

    public boolean isRepresentationManagedByEditor(DRepresentation representation, IEditorPart editorPart) {
        IDDiagramEditPart idDiagramEditPart;
        DiagramDocumentEditor diagramDocumentEditor;
        DiagramEditPart diagramEditPart;
        boolean isRepresentationManagedByEditor = false;
        if (editorPart instanceof DiagramDocumentEditor && (diagramEditPart = (diagramDocumentEditor = (DiagramDocumentEditor)editorPart).getDiagramEditPart()) instanceof IDDiagramEditPart && (idDiagramEditPart = (IDDiagramEditPart)diagramEditPart).resolveSemanticElement().equals(representation)) {
            isRepresentationManagedByEditor = true;
        }
        return isRepresentationManagedByEditor;
    }

    public boolean isRepresentationDescriptionManagedByEditor(RepresentationDescription representationDescription, IEditorPart editor) {
        DiagramDocumentEditor diagramDocumentEditor;
        EObject element;
        if (editor instanceof DiagramDocumentEditor && (element = (diagramDocumentEditor = (DiagramDocumentEditor)editor).getDiagram().getElement()) instanceof DSemanticDiagram) {
            DSemanticDiagram dSemanticDiagram = (DSemanticDiagram)element;
            DiagramDescription description = dSemanticDiagram.getDescription();
            return EcoreUtil.equals((EObject)description, (EObject)representationDescription);
        }
        return false;
    }

    public boolean canHandle(DRepresentation representation) {
        return representation instanceof DSemanticDiagram;
    }

    public boolean canHandle(RepresentationDescription description) {
        return description instanceof DiagramDescription;
    }

    public boolean canHandle(RepresentationExtensionDescription description) {
        return description instanceof DiagramExtensionDescription;
    }

    public boolean canExport(ExportFormat format) {
        return format.getDocumentFormat().equals((Object)ExportFormat.ExportDocumentFormat.NONE) || format.getDocumentFormat().equals((Object)ExportFormat.ExportDocumentFormat.HTML) && DiagramEditPartService.canExportToHtml();
    }

    public void export(DRepresentation representation, Session session, IPath path, ExportFormat format, IProgressMonitor monitor) throws SizeTooLargeException {
        boolean exportToHtml = this.exportToHtml(format);
        String imageFileExtension = this.getImageFileExtension(format);
        IPath correctPath = this.getRealPath(path, exportToHtml);
        Shell shell = new Shell();
        try {
            Collection data = session.getServices().getCustomData("GMF_DIAGRAMS", (EObject)representation);
            for (EObject dataElement : data) {
                if (!(dataElement instanceof Diagram)) continue;
                Diagram diagram = (Diagram)dataElement;
                this.synchronizeDiagram(diagram);
                DiagramEditPartService tool = new DiagramEditPartService();
                if (exportToHtml) {
                    tool.exportToHtml();
                }
                DiagramEditPart diagramEditPart = tool.createDiagramEditPart(diagram, shell, PreferencesHint.USE_DEFAULTS);
                try {
                    try {
                        diagramEditPart.getRoot().refresh();
                        diagramEditPart.getFigure().validate();
                        diagramEditPart.getRoot().refresh();
                        diagramEditPart.getRoot().getViewer().flush();
                        tool.copyToImage(diagramEditPart, correctPath, ImageFileFormat.resolveImageFormat((String)imageFileExtension), monitor);
                        if (!new File(correctPath.toOSString()).exists()) {
                            throw new CoreException((IStatus)new Status(4, "org.eclipse.sirius", EXPORT_DIAGRAM_AS_IMAGE_ERROR_ON_CREATE_IMAGE + correctPath));
                        }
                    }
                    catch (CoreException exception) {
                        if (exception instanceof SizeTooLargeException) {
                            throw (SizeTooLargeException)exception;
                        }
                        SiriusPlugin.getDefault().error(EXPORT_DIAGRAM_AS_IMAGE_ERROR_ON_CREATE_IMAGE + correctPath, (Throwable)exception);
                        diagramEditPart.deactivate();
                        diagramEditPart.getViewer().flush();
                        diagramEditPart.getViewer().getEditDomain().getCommandStack().flush();
                        diagramEditPart.getViewer().getControl().dispose();
                        ((DiagramEditDomain)diagramEditPart.getViewer().getEditDomain()).removeViewer(diagramEditPart.getViewer());
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    diagramEditPart.deactivate();
                    diagramEditPart.getViewer().flush();
                    diagramEditPart.getViewer().getEditDomain().getCommandStack().flush();
                    diagramEditPart.getViewer().getControl().dispose();
                    ((DiagramEditDomain)diagramEditPart.getViewer().getEditDomain()).removeViewer(diagramEditPart.getViewer());
                    throw throwable;
                }
                diagramEditPart.deactivate();
                diagramEditPart.getViewer().flush();
                diagramEditPart.getViewer().getEditDomain().getCommandStack().flush();
                diagramEditPart.getViewer().getControl().dispose();
                ((DiagramEditDomain)diagramEditPart.getViewer().getEditDomain()).removeViewer(diagramEditPart.getViewer());
            }
        }
        finally {
            this.disposeShell(shell);
        }
    }

    private void disposeShell(final Shell shell) {
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                shell.dispose();
            }
        });
    }

    private boolean exportToHtml(ExportFormat format) {
        return format.getDocumentFormat().equals((Object)ExportFormat.ExportDocumentFormat.HTML);
    }

    private String getImageFileExtension(ExportFormat format) {
        return format.getImageFormat().getName();
    }

    private IPath getRealPath(IPath path, boolean exportToHtml) {
        if (exportToHtml) {
            return path.removeFileExtension().addFileExtension("html");
        }
        return path;
    }

    private Collection<CommandParameter> getDiagramTypesCreation() {
        HashSet<CommandParameter> result = new HashSet<CommandParameter>();
        for (IDiagramTypeDescriptor diagramTypeDescriptor : DiagramTypeDescriptorRegistry.getInstance().getAllDiagramTypeDescriptors()) {
            DiagramDescription specificDiagramDescription = diagramTypeDescriptor.getDiagramDescriptionProvider().createDiagramDescription();
            specificDiagramDescription.setEnablePopupBars(true);
            if (specificDiagramDescription.getDefaultLayer() == null) {
                Layer layer = DescriptionFactory.eINSTANCE.createLayer();
                layer.setName("Default");
                specificDiagramDescription.setDefaultLayer(layer);
            }
            CommandParameter typeCommandParameter = new CommandParameter(null, (Object)DescriptionPackage.Literals.VIEWPOINT__OWNED_REPRESENTATIONS, (Object)specificDiagramDescription);
            result.add(typeCommandParameter);
        }
        return result;
    }

    public String getEditorName(DRepresentation representation) {
        String editorName = representation.getName();
        if (StringUtil.isEmpty((String)editorName)) {
            editorName = "New Diagram";
        }
        return editorName;
    }

    public Collection<CommandParameter> provideTools(EObject context) {
        ArrayList toolsParameters = Lists.newArrayList();
        for (IDiagramTypeDescriptor diagramTypeDescriptor : DiagramTypeDescriptorRegistry.getInstance().getAllDiagramTypeDescriptors()) {
            DiagramDescription diagramType = diagramTypeDescriptor.getDiagramDescriptionProvider().createDiagramDescription();
            if (!this.hasParentOfType(context, diagramType.eClass())) continue;
            toolsParameters.addAll(diagramTypeDescriptor.getDiagramDescriptionProvider().collectToolCommands(context));
        }
        return toolsParameters;
    }

    public Collection<CommandParameter> provideAdditionalMappings(EObject context) {
        ArrayList mappings = Lists.newArrayList();
        for (IDiagramTypeDescriptor diagramTypeDescriptor : DiagramTypeDescriptorRegistry.getInstance().getAllDiagramTypeDescriptors()) {
            DiagramDescription diagramType = diagramTypeDescriptor.getDiagramDescriptionProvider().createDiagramDescription();
            if (!this.hasParentOfType(context, diagramType.eClass())) continue;
            mappings.addAll(diagramTypeDescriptor.getDiagramDescriptionProvider().collectMappingsCommands());
        }
        return mappings;
    }

    public ILabelProvider getHierarchyLabelProvider(ILabelProvider currentLabelProvider) {
        return new HierarchyLabelProvider(currentLabelProvider);
    }

    public void setSelection(DialectEditor dialectEditor, List<DRepresentationElement> selection) {
        if (dialectEditor instanceof DiagramEditor && selection != null && !selection.isEmpty()) {
            DiagramEditor diagramEditor = (DiagramEditor)dialectEditor;
            ArrayList selectedParts = Lists.newArrayList();
            IDiagramGraphicalViewer graphicalViewer = diagramEditor.getDiagramGraphicalViewer();
            Iterable ddeSelection = Iterables.filter(selection, DDiagramElement.class);
            if (!Iterables.isEmpty((Iterable)ddeSelection) && graphicalViewer != null) {
                Session session = SessionManager.INSTANCE.getSession(((DDiagramElement)ddeSelection.iterator().next()).getTarget());
                for (DDiagramElement dRepresentationElement : ddeSelection) {
                    IGraphicalEditPart selectedEditPart = this.getEditPart(dRepresentationElement, (EditPartViewer)graphicalViewer, session);
                    if (selectedEditPart == null || !selectedEditPart.isSelectable()) continue;
                    selectedParts.add(selectedEditPart);
                }
            }
            if (graphicalViewer != null) {
                graphicalViewer.setSelection((ISelection)new StructuredSelection((List)selectedParts));
            }
        }
    }

    public Collection<DSemanticDecorator> getSelection(DialectEditor editor) {
        DiagramEditor dEditor;
        IDiagramGraphicalViewer graphicalViewer;
        LinkedHashSet selection = Sets.newLinkedHashSet();
        if (editor instanceof DiagramEditor && (graphicalViewer = (dEditor = (DiagramEditor)editor).getDiagramGraphicalViewer()) != null) {
            for (IGraphicalEditPart ep : Iterables.filter((Iterable)graphicalViewer.getSelectedEditParts(), IGraphicalEditPart.class)) {
                View view = ep.getNotationView();
                if (view == null || !(view.getElement() instanceof DSemanticDecorator)) continue;
                selection.add((DSemanticDecorator)view.getElement());
            }
        }
        return selection;
    }

    protected IGraphicalEditPart getEditPart(DDiagramElement diagramElement, EditPartViewer graphicalViewer, Session session) {
        Object editPart;
        IGraphicalEditPart result = null;
        View gmfView = SiriusGMFHelper.getGmfView(diagramElement, session);
        Map editPartRegistry = graphicalViewer.getEditPartRegistry();
        if (editPartRegistry != null && (editPart = editPartRegistry.get(gmfView)) instanceof IGraphicalEditPart) {
            result = (IGraphicalEditPart)editPart;
        }
        return result;
    }

    private boolean hasParentOfType(EObject element, EClass eClass) {
        EObject context = element;
        boolean found = context.eClass() == eClass;
        while (!found && context != null) {
            found = context.eClass() == eClass;
            context = context.eContainer();
        }
        return found;
    }

    public String completeToolTipText(String toolTipText, EObject eObject, EStructuralFeature feature) {
        String toolTip = toolTipText;
        if (eObject instanceof EdgeCreationDescription && feature != null && feature.equals(ToolPackage.Literals.ABSTRACT_TOOL_DESCRIPTION__PRECONDITION)) {
            StringBuilder sb = new StringBuilder();
            sb.append(toolTipText);
            String cr = "\n . ";
            sb.append(String.valueOf(cr) + "preSourceView" + ": diagram.EdgeTarget | (edge only) the source view of the current potential edge.");
            sb.append(String.valueOf(cr) + "preSource" + ": ecore.EObject | (edge only) the semantic element of $preSourceView.");
            sb.append(String.valueOf(cr) + "preTargetView" + ": diagram.EdgeTarget | (edge only) the target view of the current potential edge.");
            sb.append(String.valueOf(cr) + "preTarget" + ": ecore.EObject | (edge only) the semantic element of $preTargetView.");
            sb.append(String.valueOf(cr) + "diagram" + ": diagram.DDiagram | the diagram of the current potential edge");
            toolTip = sb.toString();
        }
        EPackage parentPackage = null;
        Option parentDiagramDescription = new EObjectQuery(eObject).getFirstAncestorOfType(DescriptionPackage.eINSTANCE.getDiagramDescription());
        if (parentDiagramDescription.some()) {
            parentPackage = ((EObject)parentDiagramDescription.get()).eClass().getEPackage();
        } else {
            Option parentDiagramExtensionDescription = new EObjectQuery(eObject).getFirstAncestorOfType(DescriptionPackage.eINSTANCE.getDiagramExtensionDescription());
            if (parentDiagramExtensionDescription.some()) {
                parentPackage = ((EObject)parentDiagramExtensionDescription.get()).eClass().getEPackage();
            }
        }
        if (parentPackage != null) {
            for (IDiagramTypeDescriptor diagramTypeDescriptor : DiagramTypeDescriptorRegistry.getInstance().getAllDiagramTypeDescriptors()) {
                if (!diagramTypeDescriptor.getDiagramDescriptionProvider().handles(parentPackage)) continue;
                toolTip = diagramTypeDescriptor.getDiagramDescriptionProvider().completeToolTipText(toolTip, eObject, feature);
            }
        }
        return toolTip;
    }

    @Deprecated
    public String completeToolTipText(String toolTipText, EObject eObject) {
        return this.completeToolTipText(toolTipText, eObject, null);
    }
}

