/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.edit.internal.part;

import com.google.common.collect.Iterables;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.diagram.BackgroundStyle;
import org.eclipse.sirius.diagram.ContainerStyle;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.FlatContainerStyle;
import org.eclipse.sirius.diagram.ShapeContainerStyle;
import org.eclipse.sirius.diagram.WorkspaceImage;
import org.eclipse.sirius.diagram.description.style.ContainerStyleDescription;
import org.eclipse.sirius.diagram.ui.business.internal.edit.helpers.LabelAlignmentHelper;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractDiagramElementContainerEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.DiagramNameEditPartOperation;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramNameEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.AbstractDNodeContainerCompartmentEditPart;
import org.eclipse.sirius.diagram.ui.tools.api.figure.GradientRoundedRectangle;
import org.eclipse.sirius.diagram.ui.tools.api.figure.IWorkspaceImageFigure;
import org.eclipse.sirius.diagram.ui.tools.api.figure.OneLineMarginBorder;
import org.eclipse.sirius.diagram.ui.tools.api.figure.SVGWorkspaceImageFigure;
import org.eclipse.sirius.diagram.ui.tools.api.figure.ViewNodeContainerFigureDesc;
import org.eclipse.sirius.diagram.ui.tools.api.figure.ViewNodeContainerParallelogram;
import org.eclipse.sirius.diagram.ui.tools.api.figure.ViewNodeContainerRectangleFigureDesc;
import org.eclipse.sirius.diagram.ui.tools.api.figure.WorkspaceImageFigure;
import org.eclipse.sirius.ui.tools.api.color.VisualBindingManager;
import org.eclipse.sirius.viewpoint.DStylizable;
import org.eclipse.sirius.viewpoint.LabelAlignment;
import org.eclipse.sirius.viewpoint.RGBValues;
import org.eclipse.sirius.viewpoint.Style;

public final class DiagramContainerEditPartOperation {
    private DiagramContainerEditPartOperation() {
    }

    public static void refreshForegroundColor(AbstractDiagramElementContainerEditPart self) {
        RGBValues rgb;
        DDiagramElementContainer container;
        ContainerStyle style;
        EObject eObj = self.resolveSemanticElement();
        if (eObj instanceof DDiagramElementContainer && (style = (container = (DDiagramElementContainer)eObj).getOwnedStyle()) != null && (rgb = style.getBorderColor()) != null) {
            self.getFigure().setForegroundColor(VisualBindingManager.getDefault().getColorFromRGBValues(rgb));
        }
    }

    public static void refreshBackgroundColor(AbstractDiagramElementContainerEditPart self) {
        EObject eObj = self.resolveSemanticElement();
        if (eObj instanceof DDiagramElementContainer) {
            DDiagramElementContainer container = (DDiagramElementContainer)eObj;
            RGBValues rgb = null;
            ContainerStyle style = container.getOwnedStyle();
            if (style instanceof FlatContainerStyle) {
                rgb = ((FlatContainerStyle)style).getBackgroundColor();
            } else if (style instanceof ShapeContainerStyle) {
                rgb = ((ShapeContainerStyle)style).getBackgroundColor();
            }
            if (rgb != null) {
                self.getFigure().setBackgroundColor(VisualBindingManager.getDefault().getColorFromRGBValues(rgb));
            }
        }
    }

    public static void refreshFont(AbstractDiagramElementContainerEditPart self) {
        Object firstChild;
        if (!self.getChildren().isEmpty() && (firstChild = self.getChildren().get(0)) instanceof IDiagramNameEditPart) {
            DiagramNameEditPartOperation.refreshFont((IDiagramNameEditPart)firstChild);
        }
    }

    public static void refreshVisuals(AbstractDiagramElementContainerEditPart self) {
        DDiagramElement diagElement = self.resolveDiagramElement();
        if (diagElement instanceof DDiagramElementContainer) {
            RGBValues rgb;
            ContainerStyle style;
            DDiagramElementContainer ddec = (DDiagramElementContainer)diagElement;
            if (self.getBackgroundFigure() instanceof IWorkspaceImageFigure && ddec.getOwnedStyle() != null) {
                ((IWorkspaceImageFigure)self.getBackgroundFigure()).refreshFigure(ddec.getOwnedStyle());
            }
            if (DiagramContainerEditPartOperation.isPrimaryShapeChanging(self, (Style)(style = ddec.getOwnedStyle()))) {
                self.reInitFigure();
            }
            ViewNodeContainerFigureDesc primaryShape = self.getPrimaryShape();
            DiagramContainerEditPartOperation.refreshBorder(self, primaryShape, style);
            if (style instanceof FlatContainerStyle && (rgb = ((FlatContainerStyle)style).getForegroundColor()) != null && primaryShape instanceof GradientRoundedRectangle) {
                ((GradientRoundedRectangle)primaryShape).setGradientColor(VisualBindingManager.getDefault().getColorFromRGBValues(rgb));
                ((GradientRoundedRectangle)primaryShape).setCornerDimensions(DiagramContainerEditPartOperation.getCornerDimension(self));
            }
        }
        if (diagElement != null) {
            self.setTooltipText(diagElement.getTooltipText());
            DiagramContainerEditPartOperation.refreshLabelAlignment(self, diagElement);
        }
    }

    private static ViewNodeContainerFigureDesc refreshBorder(AbstractDiagramElementContainerEditPart self, ViewNodeContainerFigureDesc primaryShape, ContainerStyle style) {
        int borderSize = 0;
        if (style != null && style.getBorderSize() != null) {
            borderSize = style.getBorderSize();
        }
        if (borderSize == 0) {
            borderSize = 1;
        }
        if (borderSize > 0) {
            if (primaryShape instanceof Shape) {
                ((Shape)primaryShape).setLineWidth(borderSize);
            } else if (primaryShape instanceof NodeFigure) {
                ((NodeFigure)primaryShape).setLineWidth(borderSize);
            }
            int labelOffset = 5;
            if (primaryShape.getLabelFigure() == null || !primaryShape.getLabelFigure().isVisible()) {
                labelOffset = 0;
            }
            if (primaryShape != null && primaryShape.getBorder() instanceof LineBorder) {
                ((LineBorder)primaryShape.getBorder()).setWidth(borderSize);
                if (primaryShape.getBorder() instanceof OneLineMarginBorder) {
                    ((OneLineMarginBorder)primaryShape.getBorder()).setMargin(labelOffset, 0, 0, 0);
                }
            } else if (primaryShape != null && primaryShape.getBorder() instanceof MarginBorder) {
                MarginBorder margin = null;
                int borderMagin = borderSize;
                switch (self.getParentStackDirection()) {
                    case 5: {
                        borderMagin = DiagramContainerEditPartOperation.isFirstRegionPart(self) ? 0 : borderSize - 1;
                        margin = new MarginBorder(borderMagin + labelOffset, 0, 0, 0);
                        break;
                    }
                    case 24: {
                        borderMagin = DiagramContainerEditPartOperation.isFirstRegionPart(self) ? 0 : borderSize;
                        margin = new MarginBorder(labelOffset, borderMagin, 0, 0);
                        break;
                    }
                    default: {
                        margin = new MarginBorder(borderMagin + labelOffset - 1, borderMagin, borderMagin, borderMagin);
                    }
                }
                primaryShape.setBorder((Border)margin);
            }
        }
        return primaryShape;
    }

    private static boolean isFirstRegionPart(AbstractDiagramElementContainerEditPart self) {
        EditPart parent = self.getParent();
        if (parent instanceof AbstractDNodeContainerCompartmentEditPart) {
            Iterable regionParts = Iterables.filter((Iterable)parent.getChildren(), AbstractDiagramElementContainerEditPart.class);
            return !Iterables.isEmpty((Iterable)regionParts) && regionParts.iterator().next() == self;
        }
        return false;
    }

    private static boolean isPrimaryShapeChanging(AbstractDiagramElementContainerEditPart self, Style style) {
        boolean result = false;
        boolean bl = result = self.getPrimaryShape() instanceof ViewNodeContainerParallelogram && (style instanceof FlatContainerStyle || style instanceof WorkspaceImage);
        if (!result) {
            boolean bl2 = result = self.getPrimaryShape() instanceof GradientRoundedRectangle && (style instanceof ShapeContainerStyle || style instanceof WorkspaceImage);
            if (!result) {
                result = self.getPrimaryShape() instanceof ViewNodeContainerRectangleFigureDesc && (style instanceof FlatContainerStyle || style instanceof ShapeContainerStyle);
            }
        }
        return result;
    }

    private static void refreshLabelAlignment(AbstractDiagramElementContainerEditPart self, DDiagramElement diagElement) {
        IFigure firstGrandChild;
        IFigure firstChild;
        IFigure fig;
        LabelAlignment alignment = LabelAlignmentHelper.getLabelAlignementFor(diagElement);
        if (alignment != null && (fig = self.getFigure()).getChildren().size() > 0 && (firstChild = (IFigure)fig.getChildren().get(0)) != null && firstChild.getChildren().size() > 0 && (firstGrandChild = (IFigure)firstChild.getChildren().get(0)) != null && firstGrandChild.getLayoutManager() instanceof ConstrainedToolbarLayout) {
            ConstrainedToolbarLayout ctl = (ConstrainedToolbarLayout)firstGrandChild.getLayoutManager();
            ctl.setMinorAlignment(LabelAlignmentHelper.getAsCTLMinorAlignment(alignment));
        }
    }

    public static IFigure createBackgroundFigure(IGraphicalEditPart self) {
        DDiagramElementContainer container;
        EObject eObj = self.resolveSemanticElement();
        if (eObj instanceof DDiagramElementContainer && (container = (DDiagramElementContainer)eObj).getOwnedStyle() != null && container.getOwnedStyle() instanceof WorkspaceImage) {
            WorkspaceImage img = (WorkspaceImage)container.getOwnedStyle();
            return DiagramContainerEditPartOperation.createWkpImageFigure(img);
        }
        return null;
    }

    private static IFigure createWkpImageFigure(WorkspaceImage img) {
        IWorkspaceImageFigure imageFigure = null;
        if (img != null && !StringUtil.isEmpty((String)img.getWorkspacePath())) {
            String workspacePath = img.getWorkspacePath();
            imageFigure = WorkspaceImageFigure.isSvgImage(workspacePath) ? SVGWorkspaceImageFigure.createImageFigure(img) : WorkspaceImageFigure.createImageFigure(workspacePath);
        }
        return imageFigure;
    }

    public static Dimension getCornerDimension(IGraphicalEditPart self) {
        ContainerStyleDescription description;
        Style style;
        Dimension corner = new Dimension(0, 0);
        EObject eObj = self.resolveSemanticElement();
        if (eObj instanceof DStylizable && (style = ((DStylizable)eObj).getStyle()) != null && style.getDescription() instanceof ContainerStyleDescription && (description = (ContainerStyleDescription)style.getDescription()).isRoundedCorner()) {
            corner.height = description.getArcHeight();
            corner.width = description.getArcWidth();
        }
        return corner;
    }

    public static BackgroundStyle getBackgroundStyle(IGraphicalEditPart self) {
        Style style;
        BackgroundStyle bgStyle = BackgroundStyle.GRADIENT_LEFT_TO_RIGHT_LITERAL;
        EObject eObj = self.resolveSemanticElement();
        if (eObj instanceof DStylizable && (style = ((DStylizable)eObj).getStyle()) instanceof FlatContainerStyle) {
            bgStyle = ((FlatContainerStyle)style).getBackgroundStyle();
        }
        return bgStyle;
    }
}

