/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.actions.visibility;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.RootEditPart;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.tools.api.command.IDiagramCommandFactory;
import org.eclipse.sirius.diagram.tools.api.command.IDiagramCommandFactoryProvider;
import org.eclipse.sirius.diagram.ui.business.api.provider.AbstractDDiagramElementLabelItemProvider;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramElementEditPart;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.tools.api.editor.DDiagramEditor;
import org.eclipse.sirius.diagram.ui.tools.internal.actions.visibility.AbstractRevealElementsAction;
import org.eclipse.sirius.diagram.ui.tools.internal.editor.DiagramOutlinePage;
import org.eclipse.sirius.ext.base.Option;

public class RevealOutlineLabelsAction
extends AbstractRevealElementsAction<Object> {
    public static final String REVEAL_LABEL_LABEL = "Show label";

    public RevealOutlineLabelsAction() {
        this(REVEAL_LABEL_LABEL);
    }

    public RevealOutlineLabelsAction(String text) {
        this(text, DiagramUIPlugin.Implementation.getBundledImageDescriptor("icons/categoryLabelVisible.gif"));
    }

    public RevealOutlineLabelsAction(String text, ImageDescriptor image) {
        super(text, image);
        this.setId(text);
    }

    @Override
    protected boolean doRun(Object element) {
        if (element instanceof DDiagramElement) {
            this.run((DDiagramElement)element);
        } else if (element instanceof AbstractDDiagramElementLabelItemProvider) {
            Option<DDiagramElement> optionTarget = ((AbstractDDiagramElementLabelItemProvider)((Object)element)).getDiagramElementTarget();
            if (optionTarget.some()) {
                this.run((DDiagramElement)optionTarget.get());
            }
        } else if (element instanceof IDiagramElementEditPart) {
            IDiagramElementEditPart diagramElementEditPart = (IDiagramElementEditPart)element;
            RootEditPart root = diagramElementEditPart.getRoot();
            DDiagramEditor diagramEditor = (DDiagramEditor)root.getViewer().getProperty("org.eclipse.sirius.diagram.ui.part.SiriusDiagramEditorID");
            this.runRevealCommand(root, diagramEditor, diagramElementEditPart.resolveDiagramElement());
        }
        return true;
    }

    @Override
    protected Class<Object> getElementType() {
        return Object.class;
    }

    private void run(DDiagramElement diagramElement) {
        if (this.selection instanceof DiagramOutlinePage.TreeSelectionWrapper) {
            DiagramOutlinePage.TreeSelectionWrapper wrapper = (DiagramOutlinePage.TreeSelectionWrapper)this.selection;
            RootEditPart root = wrapper.getRoot();
            DDiagramEditor diagramEditor = (DDiagramEditor)wrapper.getViewer().getProperty("org.eclipse.sirius.diagram.ui.part.SiriusDiagramEditorID");
            this.runRevealCommand(root, diagramEditor, diagramElement);
        }
    }

    private void runRevealCommand(RootEditPart root, DDiagramEditor editor, DDiagramElement vpe) {
        Object adapter = editor.getAdapter(IDiagramCommandFactoryProvider.class);
        IDiagramCommandFactoryProvider cmdFactoryProvider = (IDiagramCommandFactoryProvider)adapter;
        TransactionalEditingDomain transactionalEditingDomain = TransactionUtil.getEditingDomain((ResourceSet)editor.getEditingDomain().getResourceSet());
        IDiagramCommandFactory emfCommandFactory = cmdFactoryProvider.getCommandFactory(transactionalEditingDomain);
        Command cmd = emfCommandFactory.buildRevealLabelCommand(vpe);
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)vpe);
        CompoundCommand allInOne = new CompoundCommand(cmd.getLabel());
        allInOne.append(cmd);
        domain.getCommandStack().execute((Command)allInOne);
    }
}

