/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.graphical.edit.styles;

import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.gef.ui.figures.SlidableAnchor;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.ResizeKind;
import org.eclipse.sirius.diagram.ui.tools.api.figure.AirDefaultSizeNodeFigure;
import org.eclipse.sirius.diagram.ui.tools.api.figure.SiriusWrapLabel;
import org.eclipse.sirius.diagram.ui.tools.api.figure.anchor.AnchorProvider;
import org.eclipse.sirius.diagram.ui.tools.api.graphical.edit.styles.BorderItemLocatorProvider;
import org.eclipse.sirius.diagram.ui.tools.api.graphical.edit.styles.DefaultBorderItemLocatorProvider;
import org.eclipse.sirius.diagram.ui.tools.api.graphical.edit.styles.SimpleStyleConfiguration;

class SquareStyleConfiguration
extends SimpleStyleConfiguration {
    private static final double X1 = 15.333;
    private static final double X2 = 8.0;
    private static final double Y1 = 6.993;
    private static final double Y2 = 20.979;

    SquareStyleConfiguration() {
    }

    @Override
    public BorderItemLocatorProvider getBorderItemLocatorProvider() {
        return DefaultBorderItemLocatorProvider.getInstance();
    }

    @Override
    public void adaptNodeLabel(DNode node, SiriusWrapLabel nodeLabel) {
        if (nodeLabel.getParent() != null) {
            Rectangle origin = nodeLabel.getParent().getBounds();
            int x = (int)((double)origin.width * 15.333 / 100.0);
            int y = (int)((double)origin.height * 6.993 / 100.0);
            int width = (int)((double)origin.width - ((double)origin.width * 15.333 / 100.0 + (double)origin.width * 8.0 / 100.0));
            int height = (int)((double)origin.height - ((double)origin.height * 6.993 / 100.0 + (double)origin.height * 20.979 / 100.0));
            Rectangle bounds = new Rectangle(x, y, width, height);
            nodeLabel.setBounds(bounds);
            nodeLabel.getParent().setConstraint((IFigure)nodeLabel, (Object)bounds);
        }
    }

    @Override
    public int adaptViewNodeSizeWithLabel(DNode viewNode, SiriusWrapLabel nodeLabel, int nodeWidth) {
        if (viewNode.getResizeKind() != ResizeKind.NONE_LITERAL) {
            return nodeWidth;
        }
        return nodeWidth;
    }

    @Override
    public AnchorProvider getAnchorProvider() {
        return SquareAnchorProvider.INSTANCE;
    }

    private static final class SquareAnchorProvider
    implements AnchorProvider {
        public static final SquareAnchorProvider INSTANCE = new SquareAnchorProvider();

        private SquareAnchorProvider() {
        }

        @Override
        public ConnectionAnchor createAnchor(AirDefaultSizeNodeFigure figure, PrecisionPoint p) {
            if (p == null) {
                return this.createDefaultAnchor(figure);
            }
            return new SquareStyleSlidableAnchor((IFigure)figure, p);
        }

        @Override
        public ConnectionAnchor createDefaultAnchor(AirDefaultSizeNodeFigure figure) {
            return new SquareStyleSlidableAnchor((IFigure)figure);
        }
    }

    private static class SquareStyleSlidableAnchor
    extends SlidableAnchor {
        public SquareStyleSlidableAnchor(IFigure f, PrecisionPoint p) {
            super(f, p);
        }

        public SquareStyleSlidableAnchor(IFigure f) {
            super(f);
        }

        protected Rectangle getBox() {
            Rectangle origin = super.getBox();
            int x = (int)((double)origin.width * 15.333 / 100.0) + origin.x;
            int y = (int)((double)origin.height * 6.993 / 100.0) + origin.y;
            int width = (int)((double)origin.width - ((double)origin.width * 15.333 / 100.0 + (double)origin.width * 8.0 / 100.0));
            int height = (int)((double)origin.height - ((double)origin.height * 6.993 / 100.0 + (double)origin.height * 20.979 / 100.0));
            Rectangle box = new Rectangle(x, y, width, height);
            return box;
        }
    }
}

