/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.providers.decorators;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.AbstractDecorator;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoratorTarget;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.business.api.componentization.ViewpointRegistry;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerManager;
import org.eclipse.sirius.business.api.query.DRepresentationElementQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.common.tools.DslCommonPlugin;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.profiler.ProfilerTask;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.tools.api.figure.WorkspaceImageFigure;
import org.eclipse.sirius.diagram.ui.tools.api.graphical.edit.styles.IBorderItemOffsets;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.sirius.viewpoint.description.tool.RepresentationNavigationDescription;
import org.eclipse.sirius.viewpoint.description.tool.ToolPackage;
import org.eclipse.swt.graphics.Image;

public class SubDiagramDecorator
extends AbstractDecorator {
    private static final ProfilerTask DECORATOR_REFRESH = new ProfilerTask("DDiagram", "SubDiagramDecorator refresh", "/images/viewpoint.gif");
    private Session session;

    public SubDiagramDecorator(IDecoratorTarget decoratorTarget) {
        super(decoratorTarget);
        View view = (View)this.getDecoratorTarget().getAdapter(View.class);
        DRepresentationElement model = (DRepresentationElement)view.getElement();
        this.session = SessionManager.INSTANCE.getSession(model.getTarget());
    }

    public void activate() {
    }

    public void deactivate() {
        super.deactivate();
        this.session = null;
    }

    public void refresh() {
        DslCommonPlugin.PROFILER.startWork(DECORATOR_REFRESH);
        this.removeDecoration();
        View view = (View)this.getDecoratorTarget().getAdapter(View.class);
        if (view != null && view.eResource() != null) {
            DRepresentationElement node;
            EObject model;
            EditPart editPart = (EditPart)this.getDecoratorTarget().getAdapter(EditPart.class);
            if (editPart == null || editPart.getParent() == null || editPart.getViewer() == null) {
                return;
            }
            if (editPart instanceof GraphicalEditPart) {
                IFigure figure = ((GraphicalEditPart)editPart).getFigure();
                Dimension size = figure.getSize();
                if (size.width <= 30 && size.width > 0 && size.height <= 30 && size.height > 0) {
                    return;
                }
            }
            if ((model = view.getElement()) instanceof DRepresentationElement && this.shouldHaveSubDiagDecoration(node = (DRepresentationElement)model)) {
                int margin = -(IBorderItemOffsets.DEFAULT_OFFSET.width / 2 + 1);
                if (editPart instanceof GraphicalEditPart) {
                    margin = MapModeUtil.getMapMode((IFigure)((GraphicalEditPart)editPart).getFigure()).DPtoLP(margin);
                }
                this.setDecoration(this.getDecoratorTarget().addShapeDecoration(this.getSubDiagramImage(), IDecoratorTarget.Direction.SOUTH_EAST, margin, false));
            }
        }
        DslCommonPlugin.PROFILER.stopWork(DECORATOR_REFRESH);
    }

    private Image getSubDiagramImage() {
        return WorkspaceImageFigure.flyWeightImage(DiagramUIPlugin.Implementation.getBundledImageDescriptor("icons/HasLink.gif"));
    }

    private boolean shouldHaveSubDiagDecoration(DRepresentationElement node) {
        EObject target = node.getTarget();
        boolean shouldHaveSubDiagramDecorator = false;
        if (target != null && target.eResource() != null && this.session != null && !this.parentHasSameSemanticElement(node)) {
            DRepresentation representation = new DRepresentationElementQuery(node).getParentRepresentation();
            Predicate otherReperesentation = Predicates.not((Predicate)Predicates.equalTo((Object)representation));
            shouldHaveSubDiagramDecorator = Iterables.any((Iterable)DialectManager.INSTANCE.getRepresentations(target, this.session), (Predicate)otherReperesentation);
            if (node.getMapping() != null && !shouldHaveSubDiagramDecorator) {
                shouldHaveSubDiagramDecorator = this.checkRepresentationNavigationDescriptions(node);
            }
        }
        return shouldHaveSubDiagramDecorator;
    }

    private boolean parentHasSameSemanticElement(DRepresentationElement element) {
        return element.eContainer() instanceof DDiagramElement && ((DDiagramElement)element.eContainer()).getTarget() == element.getTarget();
    }

    private boolean checkRepresentationNavigationDescriptions(DRepresentationElement element) {
        EObject target = element.getTarget();
        if (this.session.isOpen()) {
            IInterpreter interpreter = this.session.getInterpreter();
            for (RepresentationNavigationDescription navDesc : element.getMapping().getNavigationDescriptions()) {
                if (!this.isFromActiveViewpoint(navDesc.getRepresentationDescription())) continue;
                interpreter.setVariable(navDesc.getContainerVariable().getName(), (Object)target);
                interpreter.setVariable(navDesc.getContainerViewVariable().getName(), (Object)element);
                boolean precondition = true;
                if (!StringUtil.isEmpty((String)navDesc.getPrecondition())) {
                    try {
                        precondition = interpreter.evaluateBoolean(target, navDesc.getPrecondition());
                    }
                    catch (EvaluationException e) {
                        RuntimeLoggerManager.INSTANCE.error((EObject)navDesc, (EStructuralFeature)ToolPackage.eINSTANCE.getAbstractToolDescription_Precondition(), (Throwable)e);
                    }
                }
                if (precondition && this.checkRepresentationNavigationDescription(interpreter, navDesc, element)) {
                    return true;
                }
                interpreter.unSetVariable(navDesc.getContainerVariable().getName());
                interpreter.unSetVariable(navDesc.getContainerViewVariable().getName());
            }
        }
        return false;
    }

    private boolean isFromActiveViewpoint(RepresentationDescription description) {
        Viewpoint vp = ViewpointRegistry.getInstance().getViewpoint(description);
        return vp != null && this.session.getSelectedViewpoints(false).contains(vp);
    }

    private boolean checkRepresentationNavigationDescription(IInterpreter interpreter, RepresentationNavigationDescription navDesc, DRepresentationElement element) {
        Collection<EObject> candidates = null;
        if (!StringUtil.isEmpty((String)navDesc.getBrowseExpression())) {
            candidates = RuntimeLoggerManager.INSTANCE.decorate(interpreter).evaluateCollection(element.getTarget(), (EObject)navDesc, (EStructuralFeature)ToolPackage.eINSTANCE.getRepresentationNavigationDescription_BrowseExpression());
        } else {
            candidates = new ArrayList();
            TreeIterator it = SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor(element.getTarget()).eAllContents(element.getTarget());
            while (it.hasNext()) {
                candidates.add((EObject)it.next());
            }
        }
        for (EObject candidate : candidates) {
            Collection representations = DialectManager.INSTANCE.getRepresentations(candidate, this.session);
            for (DRepresentation representation : representations) {
                if (navDesc.getRepresentationDescription() == null || !navDesc.getRepresentationDescription().equals(DialectManager.INSTANCE.getDescription(representation))) continue;
                return true;
            }
        }
        return false;
    }
}

