/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class DiagramPlugin
extends Plugin {
    public static final String ID = "org.eclipse.sirius.diagram";
    private static DiagramPlugin defaultPlugin;

    public DiagramPlugin() {
        defaultPlugin = this;
    }

    public static DiagramPlugin getDefault() {
        return defaultPlugin;
    }

    public static String getString(String key) {
        return Platform.getResourceString((Bundle)DiagramPlugin.getDefault().getBundle(), (String)("%" + key));
    }

    public void logError(String error) {
        this.logError(error, null);
    }

    public void logError(String error, Throwable throwable) {
        this.logMessage(error, throwable, 4);
    }

    public void logInfo(String message) {
        this.logInfo(message, null);
    }

    public void logInfo(String message, Throwable throwable) {
        this.logMessage(message, throwable, 1);
    }

    public void logWarning(String message) {
        this.logWarning(message, null);
    }

    public void logWarning(String message, Throwable throwable) {
        this.logMessage(message, throwable, 2);
    }

    private void logMessage(String message, Throwable throwable, int code) {
        String msg = message;
        if (message == null && throwable != null) {
            msg = throwable.getMessage();
        }
        this.getLog().log((IStatus)new Status(code, ID, 0, msg, throwable));
        this.debug(msg, throwable);
    }

    private void debug(String message, Throwable throwable) {
        if (!this.isDebugging()) {
            return;
        }
        if (message != null) {
            System.err.println(message);
        }
        if (throwable != null) {
            throwable.printStackTrace();
        }
    }

    public void stop(BundleContext context) throws Exception {
        try {
            InstanceScope.INSTANCE.getNode(ID).flush();
        }
        finally {
            super.stop(context);
        }
    }
}

