/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.internal.metamodel.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EcoreEList;
import org.eclipse.sirius.business.api.componentization.ViewpointRegistry;
import org.eclipse.sirius.common.tools.api.util.EqualityHelper;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramMappingsManager;
import org.eclipse.sirius.diagram.business.internal.metamodel.description.operations.EdgeMappingImportWrapper;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.ContentHelper;
import org.eclipse.sirius.diagram.description.ContainerMapping;
import org.eclipse.sirius.diagram.description.DescriptionPackage;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.diagram.description.EdgeMappingImport;
import org.eclipse.sirius.diagram.description.IEdgeMapping;
import org.eclipse.sirius.diagram.description.Layer;
import org.eclipse.sirius.diagram.description.NodeMapping;
import org.eclipse.sirius.viewpoint.description.AbstractMappingImport;
import org.eclipse.sirius.viewpoint.description.DecorationDescription;

public final class LayerHelper {
    private LayerHelper() {
    }

    public static EList<Layer> getAllLayers(DiagramDescription description) {
        ArrayList<Layer> layers = new ArrayList<Layer>();
        if (description.getDefaultLayer() != null) {
            layers.add(description.getDefaultLayer());
        }
        layers.addAll((Collection<Layer>)description.getAdditionalLayers());
        return new EcoreEList.UnmodifiableEList((InternalEObject)description, (EStructuralFeature)DescriptionPackage.eINSTANCE.getDiagramDescription_AllLayers(), layers.size(), layers.toArray());
    }

    public static Collection<Layer> getParentLayers(DiagramElementMapping mapping) {
        LinkedHashSet<Layer> layers = new LinkedHashSet<Layer>();
        Layer parentLayer = LayerHelper.getContainingLayer(mapping);
        if (parentLayer != null) {
            layers.add(parentLayer);
        }
        EObject registryMappingInstance = ViewpointRegistry.getInstance().find((EObject)mapping);
        Collection settings = ViewpointRegistry.getInstance().getCrossReferencer().getInverseReferences(registryMappingInstance);
        for (EStructuralFeature.Setting setting : settings) {
            EObject eReferencer = setting.getEObject();
            EStructuralFeature eFeature = setting.getEStructuralFeature();
            if (eReferencer instanceof Layer && eFeature.equals(DescriptionPackage.eINSTANCE.getLayer_ReusedMappings())) {
                layers.add((Layer)eReferencer);
                continue;
            }
            if (!eFeature.equals(DescriptionPackage.eINSTANCE.getContainerMapping_ReusedNodeMappings()) && !eFeature.equals(DescriptionPackage.eINSTANCE.getContainerMapping_ReusedContainerMappings()) && !eFeature.equals(DescriptionPackage.eINSTANCE.getAbstractNodeMapping_ReusedBorderedNodeMappings())) continue;
            Layer eReferencerLayer = LayerHelper.getContainingLayer((DiagramElementMapping)eReferencer);
            Layer mappingSourceLayer = LayerHelper.getContainingLayer(mapping);
            if (eReferencerLayer == null || layers.contains(eReferencerLayer) || EqualityHelper.areEquals((EObject)mappingSourceLayer.eContainer(), (EObject)eReferencerLayer.eContainer())) continue;
            layers.add(eReferencerLayer);
        }
        if (mapping.eContainer() instanceof ContainerMapping) {
            layers.addAll(LayerHelper.getParentLayers((ContainerMapping)mapping.eContainer()));
        }
        return layers;
    }

    public static Layer getContainingLayer(DiagramElementMapping mapping) {
        DiagramElementMapping current = mapping;
        while (current != null) {
            if (!((current = current.eContainer()) instanceof Layer)) continue;
            return (Layer)((Object)current);
        }
        return null;
    }

    public static Layer getParentLayer(DecorationDescription decorationDescription) {
        DecorationDescription current = decorationDescription;
        while (current != null) {
            if (!((current = current.eContainer()) instanceof Layer)) continue;
            return (Layer)current;
        }
        return null;
    }

    public static boolean isInActivatedLayer(DiagramMappingsManager session, DDiagramElement element) {
        return LayerHelper.isInActivatedLayer(session, element, element.getParentDiagram());
    }

    public static boolean isInActivatedLayer(DiagramMappingsManager session, DDiagramElement element, DDiagram parentDiagram) {
        DiagramElementMapping mapping = element.getDiagramElementMapping();
        if (!LayerHelper.withoutLayersMode(mapping)) {
            DDiagram diagram = element.getParentDiagram() != null ? element.getParentDiagram() : parentDiagram;
            boolean visible = false;
            if (diagram != null && session.getActiveParentLayers(mapping).size() > 0) {
                EObject registryMappingInstance = ViewpointRegistry.getInstance().find((EObject)mapping);
                Collection settings = ViewpointRegistry.getInstance().getCrossReferencer().getInverseReferences(registryMappingInstance, true);
                if (!LayerHelper.hideSubMappingsInImporters(session, diagram, settings, mapping)) {
                    EObject container = element.eContainer();
                    if (container instanceof DDiagramElement && LayerHelper.isInActivatedLayer(session, (DDiagramElement)container, parentDiagram)) {
                        visible = LayerHelper.caseDiagramElementContainer((DDiagramElement)container, mapping);
                    } else if (container instanceof DDiagram) {
                        visible = LayerHelper.caseDiagramContainer(diagram, mapping);
                    } else if (container == null) {
                        visible = LayerHelper.caseDiagramContainer(parentDiagram, mapping);
                    }
                }
            }
            return visible;
        }
        return true;
    }

    private static boolean caseDiagramElementContainer(DDiagramElement container, DiagramElementMapping mapping) {
        DiagramElementMapping containerMapping = container.getDiagramElementMapping();
        return containerMapping.getAllMappings().contains((Object)mapping);
    }

    private static boolean caseDiagramContainer(DDiagram diagram, DiagramElementMapping mapping) {
        for (Layer activatedLayer : diagram.getActivatedLayers()) {
            if (!EqualityHelper.contains(LayerHelper.getAllLayerMappings(activatedLayer), (EObject)mapping)) continue;
            return true;
        }
        return false;
    }

    private static boolean hideSubMappingsInImporters(DiagramMappingsManager session, DDiagram diagram, Collection<EStructuralFeature.Setting> settings, DiagramElementMapping mapping) {
        boolean hide = false;
        for (EStructuralFeature.Setting setting : settings) {
            EObject eObject = setting.getEObject();
            EStructuralFeature eFeature = setting.getEStructuralFeature();
            if (!(eObject instanceof AbstractMappingImport) || !(eObject instanceof DiagramElementMapping) || eFeature != DescriptionPackage.eINSTANCE.getContainerMappingImport_ImportedMapping() && eFeature != DescriptionPackage.eINSTANCE.getNodeMappingImport_ImportedMapping()) continue;
            DiagramElementMapping importerMapping = (DiagramElementMapping)eObject;
            if (((AbstractMappingImport)importerMapping).isHideSubMappings() && LayerHelper.isInActivatedLayer(session, diagram, importerMapping)) {
                hide = true;
                break;
            }
            Collection importerSettings = ViewpointRegistry.getInstance().getCrossReferencer().getInverseReferences((EObject)importerMapping);
            if (!LayerHelper.hideSubMappingsInImporters(session, diagram, importerSettings, importerMapping)) continue;
            hide = true;
            break;
        }
        return hide;
    }

    private static Collection<DiagramElementMapping> getAllLayerMappings(Layer layer) {
        HashSet<DiagramElementMapping> result = new HashSet<DiagramElementMapping>();
        result.addAll((Collection<DiagramElementMapping>)layer.getNodeMappings());
        result.addAll((Collection<DiagramElementMapping>)layer.getContainerMappings());
        result.addAll((Collection<DiagramElementMapping>)layer.getEdgeMappings());
        Iterator iterMappingImport = layer.getEdgeMappingImports().iterator();
        while (iterMappingImport.hasNext()) {
            result.add(EdgeMappingImportWrapper.getWrapper((EdgeMappingImport)iterMappingImport.next()));
        }
        result.addAll(ContentHelper.getReuseMappings(layer));
        return result;
    }

    public static boolean isInActivatedLayer(DiagramMappingsManager session, DDiagram diagram, DiagramElementMapping mapping) {
        if (!LayerHelper.withoutLayersMode(mapping)) {
            boolean visible = false;
            Collection<Layer> layers = session.getActiveParentLayers(mapping);
            for (Layer layer : layers) {
                if (!EqualityHelper.contains(diagram.getActivatedLayers(), (EObject)layer)) continue;
                EObject registryMappingInstance = ViewpointRegistry.getInstance().find((EObject)mapping);
                Collection settings = ViewpointRegistry.getInstance().getCrossReferencer().getInverseReferences(registryMappingInstance);
                if (LayerHelper.hideSubMappingsInImporters(session, diagram, settings, mapping)) continue;
                visible = true;
                break;
            }
            return visible;
        }
        return true;
    }

    public static boolean isInActivatedLayer(DDiagram diagram, IEdgeMapping mapping) {
        boolean found = false;
        if (!found && (diagram.getDescription().getEdgeMappings().contains((Object)mapping) || diagram.getDescription().getEdgeMappingImports().contains((Object)mapping) || LayerHelper.containsWrapped(diagram.getDescription().getEdgeMappingImports(), mapping))) {
            found = true;
        }
        for (Layer layer : diagram.getActivatedLayers()) {
            if (!layer.getEdgeMappings().contains((Object)mapping) && !layer.getEdgeMappingImports().contains((Object)mapping) && !LayerHelper.containsWrapped(layer.getEdgeMappingImports(), mapping)) continue;
            found = true;
            break;
        }
        return found;
    }

    private static boolean containsWrapped(EList<EdgeMappingImport> edgeMappingImports, IEdgeMapping mapping) {
        for (EdgeMappingImport edgeMappingImport : edgeMappingImports) {
            if (!mapping.equals(EdgeMappingImportWrapper.getWrapper(edgeMappingImport))) continue;
            return true;
        }
        return false;
    }

    public static boolean withoutLayersMode(DiagramElementMapping mapping) {
        return LayerHelper.getContainingLayer(mapping) == null;
    }

    public static void updateActualMapping(DDiagramElement element, DiagramElementMapping mapping) {
        if (element instanceof DNode && mapping instanceof NodeMapping) {
            ((DNode)element).setActualMapping((NodeMapping)mapping);
        } else if (element instanceof DDiagramElementContainer && mapping instanceof ContainerMapping) {
            ((DDiagramElementContainer)element).setActualMapping((ContainerMapping)mapping);
        }
    }

    public static EdgeMapping getBestMapping(EdgeMapping edgeMapping, DDiagram diagram) {
        BasicEList edgeMappingImportWrappers = new BasicEList();
        for (EdgeMappingImport edgeMappingImport : diagram.getDescription().getEdgeMappingImports()) {
            edgeMappingImportWrappers.add((Object)EdgeMappingImportWrapper.getWrapper(edgeMappingImport));
        }
        for (Layer layer : diagram.getActivatedLayers()) {
            for (EdgeMapping otherEdgeMapping : layer.getAllEdgeMappings()) {
                if (!(otherEdgeMapping instanceof EdgeMappingImportWrapper)) continue;
                edgeMappingImportWrappers.add((Object)((EdgeMappingImportWrapper)otherEdgeMapping));
            }
        }
        EdgeMapping result = edgeMapping instanceof EdgeMappingImportWrapper && !edgeMappingImportWrappers.contains((Object)edgeMapping) ? null : LayerHelper.getBestMapping(edgeMapping, (EList<EdgeMappingImportWrapper>)edgeMappingImportWrappers);
        return result;
    }

    public static EdgeMapping getBestMapping(EdgeMapping edgeMapping, EList<EdgeMappingImportWrapper> edgeMappingImportWrappers) {
        EdgeMapping result = edgeMapping;
        for (EdgeMappingImportWrapper edgeMappingImportWrapper : edgeMappingImportWrappers) {
            if (!LayerHelper.isImported(edgeMapping, edgeMappingImportWrapper.getWrappedEdgeMappingImport())) continue;
            result = LayerHelper.getBestMapping((EdgeMapping)edgeMappingImportWrapper, edgeMappingImportWrappers);
            break;
        }
        return result;
    }

    public static boolean isImported(IEdgeMapping searchImportedMapping, EdgeMappingImport edgeMappingImport) {
        boolean result = false;
        IEdgeMapping importedMapping = edgeMappingImport.getImportedMapping();
        IEdgeMapping mappingToCompare = searchImportedMapping;
        if (searchImportedMapping instanceof EdgeMappingImportWrapper) {
            mappingToCompare = ((EdgeMappingImportWrapper)searchImportedMapping).getWrappedEdgeMappingImport();
        }
        result = importedMapping == null ? false : (importedMapping.equals(mappingToCompare) ? true : (importedMapping instanceof EdgeMappingImport ? LayerHelper.isImported(searchImportedMapping, (EdgeMappingImport)importedMapping) : importedMapping.equals(searchImportedMapping)));
        return result;
    }

    public static boolean containsOnlyTools(Layer layer) {
        boolean isNoDecorationDescritionSet;
        boolean isNoMapping = layer.getContainerMappings().isEmpty() && layer.getEdgeMappings().isEmpty() && layer.getNodeMappings().isEmpty();
        boolean isNoImportOrReusedMapping = layer.getEdgeMappingImports().isEmpty() && layer.getReusedMappings().isEmpty();
        boolean bl = isNoDecorationDescritionSet = layer.getDecorationDescriptionsSet() == null || layer.getDecorationDescriptionsSet().getDecorationDescriptions().isEmpty();
        return isNoMapping && isNoImportOrReusedMapping && isNoDecorationDescritionSet;
    }
}

