/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.internal.metamodel.helper;

import java.util.Collections;
import java.util.Iterator;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerManager;
import org.eclipse.sirius.common.tools.DslCommonPlugin;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.EObjectCouple;
import org.eclipse.sirius.common.tools.api.util.RefreshIdsHolder;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DNodeListElement;
import org.eclipse.sirius.diagram.DiagramFactory;
import org.eclipse.sirius.diagram.NodeStyle;
import org.eclipse.sirius.diagram.ResizeKind;
import org.eclipse.sirius.diagram.business.internal.metamodel.description.extensions.INodeMappingExt;
import org.eclipse.sirius.diagram.business.internal.metamodel.description.operations.SiriusElementMappingSpecOperations;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.DiagramElementMappingHelper;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.MappingHelper;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.StyleHelper;
import org.eclipse.sirius.diagram.description.NodeMapping;
import org.eclipse.sirius.diagram.description.style.NodeStyleDescription;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.sirius.viewpoint.Style;
import org.eclipse.sirius.viewpoint.description.style.BasicLabelStyleDescription;
import org.eclipse.sirius.viewpoint.description.style.StyleDescription;
import org.eclipse.sirius.viewpoint.description.style.StylePackage;

public final class NodeMappingHelper {
    private IInterpreter interpreter;
    private StyleHelper styleHelper;

    public NodeMappingHelper(IInterpreter interpreter) {
        this.interpreter = interpreter;
        this.styleHelper = new StyleHelper(interpreter);
    }

    public static EList<EObject> getNodesCandidates(NodeMapping self, EObject semanticOrigin, EObject container) {
        SiriusPlugin.getDefault().warning("[NodeMapping.getNodesCandidates(EObject semanticOrigin, EObject container)] This method must not be invoked. Use [NodeMapping.getNodesCandidates(EObject semanticOrigin, EObject container, EObject containerView)] instead.", null);
        return self.getNodesCandidates(semanticOrigin, container, null);
    }

    public static EList<EObject> getNodesCandidates(INodeMappingExt self, EObject semanticOrigin, EObject container, EObject containerView) {
        DslCommonPlugin.PROFILER.startWork("Get node's candidates");
        EObject safeContainer = container == null ? semanticOrigin : container;
        DDiagram diagram = null;
        if (containerView instanceof DDiagramElement) {
            diagram = ((DDiagramElement)containerView).getParentDiagram();
        } else if (containerView instanceof DDiagram) {
            diagram = (DDiagram)containerView;
        }
        EObjectCouple couple = new EObjectCouple(semanticOrigin, safeContainer, RefreshIdsHolder.getOrCreateHolder((EObject)diagram));
        UniqueEList result = self.getCandidatesCache().get(couple);
        if (result == null) {
            result = new UniqueEList();
            Iterator<EObject> it = DiagramElementMappingHelper.getSemanticIterator(self, semanticOrigin, diagram);
            if (self.getDomainClass() != null) {
                while (it.hasNext()) {
                    EObject eObj = it.next();
                    if (!NodeMappingHelper.isInstanceOf(eObj, self.getDomainClass()) || !SiriusElementMappingSpecOperations.checkPrecondition(self, eObj, safeContainer, containerView)) continue;
                    result.add((Object)eObj);
                }
            } else {
                SiriusPlugin.getDefault().error("Error creating nodes : domain class is not defined on a mapping", (Throwable)new RuntimeException());
            }
            self.getCandidatesCache().put(couple, (EList<EObject>)result);
        }
        DslCommonPlugin.PROFILER.stopWork("Get node's candidates");
        return result;
    }

    public DNode createNode(INodeMappingExt self, EObject modelElement, EObject container, DDiagram diagram) {
        NodeStyle bestStyle;
        DNode newNode = DiagramFactory.eINSTANCE.createDNode();
        NodeStyleDescription style = (NodeStyleDescription)new MappingHelper(this.interpreter).getBestStyleDescription(self, modelElement, newNode, container, diagram);
        newNode.setTarget(modelElement);
        newNode.setActualMapping(self);
        DiagramElementMappingHelper.refreshSemanticElements(self, newNode, this.interpreter);
        this.interpreter.setVariable("diagram", (Object)diagram);
        this.interpreter.setVariable("view", (Object)newNode);
        if (style != null && style.getLabelExpression() != null) {
            try {
                String name = this.interpreter.evaluateString(modelElement, style.getLabelExpression());
                newNode.setName(name);
            }
            catch (EvaluationException e) {
                RuntimeLoggerManager.INSTANCE.error((EObject)style, (EStructuralFeature)StylePackage.eINSTANCE.getBasicLabelStyleDescription_LabelExpression(), (Throwable)e);
            }
        }
        if (style != null) {
            newNode.setResizeKind(style.getResizeKind());
            this.styleHelper.setComputedSize(newNode, style);
        }
        if ((bestStyle = (NodeStyle)new MappingHelper(this.interpreter).getBestStyle(self, modelElement, newNode, container, diagram)) != null) {
            newNode.setOwnedStyle(bestStyle);
        }
        self.addDoneNode((DSemanticDecorator)newNode);
        this.interpreter.unSetVariable("view");
        this.interpreter.unSetVariable("diagram");
        self.createBorderingNodes(modelElement, newNode, Collections.EMPTY_LIST, diagram);
        if (newNode.getOwnedStyle() != null) {
            Option noPreviousStyle = Options.newNone();
            new StyleHelper(this.interpreter).refreshStyle(newNode.getOwnedStyle(), (Option<? extends Style>)noPreviousStyle);
        }
        return newNode;
    }

    public void updateNode(NodeMapping self, DNode node) {
        NodeStyleDescription style;
        EObject modelElement;
        block17: {
            block15: {
                modelElement = node.getTarget();
                DSemanticDecorator container = (DSemanticDecorator)node.eContainer();
                style = null;
                if (container != null) {
                    style = (NodeStyleDescription)new MappingHelper(this.interpreter).getBestStyleDescription(self, modelElement, node, container.getTarget(), node.getParentDiagram());
                }
                if (style != null && style.getLabelExpression() != null) {
                    try {
                        try {
                            this.interpreter.setVariable("diagram", (Object)node.getParentDiagram());
                            this.interpreter.setVariable("view", (Object)node);
                            String name = this.interpreter.evaluateString(modelElement, style.getLabelExpression());
                            node.setName(name);
                        }
                        catch (EvaluationException e) {
                            RuntimeLoggerManager.INSTANCE.error((EObject)style, (EStructuralFeature)StylePackage.eINSTANCE.getBasicLabelStyleDescription_LabelExpression(), (Throwable)e);
                            this.interpreter.unSetVariable("diagram");
                            this.interpreter.unSetVariable("view");
                            break block15;
                        }
                    }
                    catch (Throwable throwable) {
                        this.interpreter.unSetVariable("diagram");
                        this.interpreter.unSetVariable("view");
                        throw throwable;
                    }
                    this.interpreter.unSetVariable("diagram");
                    this.interpreter.unSetVariable("view");
                }
            }
            if (style != null && style.getTooltipExpression() != null) {
                try {
                    try {
                        this.interpreter.setVariable("diagram", (Object)node.getParentDiagram());
                        this.interpreter.setVariable("view", (Object)node);
                        String tooltip = this.interpreter.evaluateString(modelElement, style.getTooltipExpression());
                        node.setTooltipText(tooltip);
                    }
                    catch (EvaluationException e) {
                        RuntimeLoggerManager.INSTANCE.error((EObject)style, (EStructuralFeature)StylePackage.eINSTANCE.getTooltipStyleDescription_TooltipExpression(), (Throwable)e);
                        this.interpreter.unSetVariable("diagram");
                        this.interpreter.unSetVariable("view");
                        break block17;
                    }
                }
                catch (Throwable throwable) {
                    this.interpreter.unSetVariable("diagram");
                    this.interpreter.unSetVariable("view");
                    throw throwable;
                }
                this.interpreter.unSetVariable("diagram");
                this.interpreter.unSetVariable("view");
            }
        }
        if (node.getResizeKind() == ResizeKind.NONE_LITERAL) {
            this.styleHelper.setComputedSize(node, style);
        }
        DiagramElementMappingHelper.refreshSemanticElements(self, node, this.interpreter);
        EObject containerVariable = null;
        if (node.eContainer() instanceof DSemanticDecorator) {
            containerVariable = ((DSemanticDecorator)node.eContainer()).getTarget();
        }
        StyleDescription bestStyleDescription = new MappingHelper(this.interpreter).getBestStyleDescription(self, modelElement, node, containerVariable, node.getParentDiagram());
        Style bestStyle = node.getStyle();
        if ((bestStyle == null || bestStyle.getDescription() != bestStyleDescription) && bestStyleDescription != null) {
            bestStyle = this.styleHelper.createStyle(bestStyleDescription);
        }
        this.styleHelper.setAndRefreshStyle(node, node.getStyle(), bestStyle);
        self.addDoneNode((DSemanticDecorator)node);
    }

    public DNodeListElement createListElement(NodeMapping self, EObject modelElement, DDiagram diagram) {
        DNodeListElement newNode = DiagramFactory.eINSTANCE.createDNodeListElement();
        NodeStyleDescription style = (NodeStyleDescription)new MappingHelper(this.interpreter).getBestStyleDescription(self, modelElement, (EObject)newNode, null, diagram);
        newNode.setTarget(modelElement);
        newNode.setActualMapping(self);
        DiagramElementMappingHelper.refreshSemanticElements(self, newNode, this.interpreter);
        if (style != null && !StringUtil.isEmpty((String)style.getLabelExpression())) {
            newNode.setName(DiagramElementMappingHelper.computeLabel(newNode, (BasicLabelStyleDescription)style, diagram, this.interpreter));
        }
        self.addDoneNode((DSemanticDecorator)newNode);
        NodeStyle bestStyle = (NodeStyle)new MappingHelper(this.interpreter).getBestStyle(self, modelElement, (EObject)newNode, null, diagram);
        if (bestStyle != null) {
            newNode.setOwnedStyle(bestStyle);
        }
        return newNode;
    }

    public void updateListElement(NodeMapping self, DNodeListElement listElement) {
        EObject modelElement = listElement.getTarget();
        DSemanticDecorator container = (DSemanticDecorator)listElement.eContainer();
        NodeStyleDescription style = null;
        if (container != null) {
            style = (NodeStyleDescription)new MappingHelper(this.interpreter).getBestStyleDescription(self, modelElement, (EObject)listElement, container.getTarget(), listElement.getParentDiagram());
        }
        if (style != null && !StringUtil.isEmpty((String)style.getLabelExpression())) {
            listElement.setName(DiagramElementMappingHelper.computeLabel(listElement, style, listElement.getParentDiagram(), this.interpreter));
        }
        EObject containerVariable = null;
        if (listElement.eContainer() instanceof DSemanticDecorator) {
            containerVariable = ((DSemanticDecorator)listElement.eContainer()).getTarget();
        }
        DiagramElementMappingHelper.refreshSemanticElements(self, listElement, this.interpreter);
        NodeStyle bestStyle = (NodeStyle)new MappingHelper(this.interpreter).getBestStyle(self, modelElement, (EObject)listElement, containerVariable, listElement.getParentDiagram());
        if ((bestStyle == null || bestStyle.getDescription() != style) && style != null) {
            listElement.setOwnedStyle(bestStyle);
        }
        this.styleHelper.setAndRefreshStyle(listElement, listElement.getStyle(), bestStyle);
        self.addDoneNode((DSemanticDecorator)listElement);
    }

    public static EList<DDiagramElement> findDNodeFromEObject(INodeMappingExt self, EObject object) {
        BasicEList result = self.getViewNodesDone().get(object);
        if (result == null) {
            result = new BasicEList();
        }
        return result;
    }

    public static void addDoneNode(INodeMappingExt self, DSemanticDecorator node) {
        BasicEList list = self.getViewNodesDone().get(node.getTarget());
        if (list == null) {
            list = new BasicEList();
            self.getViewNodesDone().put(node.getTarget(), (EList<DSemanticDecorator>)list);
        }
        list.add((Object)node);
    }

    public static void clearDNodesDone(INodeMappingExt self) {
        self.getViewNodesDone().clear();
        self.getCandidatesCache().clear();
    }

    private static boolean isInstanceOf(EObject eObj, String typename) {
        DslCommonPlugin.PROFILER.startWork("EInstance of ");
        boolean result = SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor(eObj).eInstanceOf(eObj, typename);
        DslCommonPlugin.PROFILER.stopWork("EInstance of ");
        return result;
    }
}

