/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tree.tools.internal.command;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.api.helper.task.InitInterpreterVariablesTask;
import org.eclipse.sirius.business.api.helper.task.TaskHelper;
import org.eclipse.sirius.business.api.helper.task.UnexecutableTask;
import org.eclipse.sirius.business.api.helper.task.label.InitInterpreterFromParsedVariableTask2;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerManager;
import org.eclipse.sirius.business.internal.helper.task.DeleteDRepresentationElementsTask;
import org.eclipse.sirius.business.internal.helper.task.DeleteWithoutToolTask;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.ecore.extender.business.api.permission.IPermissionAuthority;
import org.eclipse.sirius.tools.api.command.AbstractCommandFactory;
import org.eclipse.sirius.tools.api.command.DCommand;
import org.eclipse.sirius.tools.api.command.InvalidPermissionCommand;
import org.eclipse.sirius.tools.api.command.NoNullResourceCommand;
import org.eclipse.sirius.tools.api.command.SiriusCommand;
import org.eclipse.sirius.tools.api.command.view.JavaActionFromToolCommand;
import org.eclipse.sirius.tools.api.interpreter.InterpreterUtil;
import org.eclipse.sirius.tools.api.ui.IExternalJavaAction;
import org.eclipse.sirius.tree.DTree;
import org.eclipse.sirius.tree.DTreeElement;
import org.eclipse.sirius.tree.DTreeItem;
import org.eclipse.sirius.tree.DTreeItemContainer;
import org.eclipse.sirius.tree.business.api.command.ITreeCommandFactory;
import org.eclipse.sirius.tree.business.internal.helper.RefreshTreeElementTask;
import org.eclipse.sirius.tree.business.internal.helper.TreeHelper;
import org.eclipse.sirius.tree.business.internal.refresh.CreateTreeTask;
import org.eclipse.sirius.tree.description.TreeDescription;
import org.eclipse.sirius.tree.description.TreeItemContainerDropTool;
import org.eclipse.sirius.tree.description.TreeItemCreationTool;
import org.eclipse.sirius.tree.description.TreeItemDeletionTool;
import org.eclipse.sirius.tree.description.TreeItemEditionTool;
import org.eclipse.sirius.tree.description.TreeVariable;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.description.tool.AbstractToolDescription;
import org.eclipse.sirius.viewpoint.description.tool.ContainerViewVariable;
import org.eclipse.sirius.viewpoint.description.tool.ElementDropVariable;
import org.eclipse.sirius.viewpoint.description.tool.ExternalJavaAction;
import org.eclipse.sirius.viewpoint.description.tool.NameVariable;
import org.eclipse.sirius.viewpoint.description.tool.OperationAction;
import org.eclipse.sirius.viewpoint.description.tool.RepresentationCreationDescription;
import org.eclipse.sirius.viewpoint.description.tool.ToolPackage;

public class TreeCommandFactory
extends AbstractCommandFactory
implements ITreeCommandFactory {
    private TaskHelper commandTaskHelper;

    public TreeCommandFactory(TransactionalEditingDomain domain) {
        super(domain);
    }

    private IPermissionAuthority getPermissionAuthority() {
        return this.modelAccessor.getPermissionAuthority();
    }

    public TaskHelper getCommandTaskHelper() {
        return this.commandTaskHelper;
    }

    @Override
    public void setModelAccessor(ModelAccessor modelAccessor) {
        this.modelAccessor = modelAccessor;
        this.commandTaskHelper = new TaskHelper(modelAccessor, this.uiCallBack);
    }

    @Override
    public Command buildDeleteTreeElement(DTreeElement element) {
        UnexecutableCommand cmd = UnexecutableCommand.INSTANCE;
        if (element instanceof DTreeItem) {
            if (!this.getPermissionAuthority().canEditInstance((EObject)element)) {
                cmd = new InvalidPermissionCommand(this.domain, new EObject[]{element});
            } else if (!this.getPermissionAuthority().canEditInstance(element.eContainer())) {
                cmd = new InvalidPermissionCommand(this.domain, new EObject[]{element.eContainer()});
            } else {
                SiriusCommand result = new SiriusCommand(this.domain);
                TreeItemDeletionTool deleteTool = this.getDeleteTool(element);
                DTree parentTree = TreeHelper.getTree((EObject)element);
                if (deleteTool != null) {
                    this.addDeleteTreeElementFromTool(result, element, deleteTool);
                    this.addRefreshTask(parentTree, (DCommand)result, deleteTool);
                    cmd = new NoNullResourceCommand((Command)result, (EObject)element);
                } else {
                    result.getTasks().add(new DeleteWithoutToolTask((DRepresentationElement)element, this.modelAccessor, this.commandTaskHelper));
                    this.addRefreshTask(parentTree, (DCommand)result, deleteTool);
                    cmd = new NoNullResourceCommand((Command)result, (EObject)element);
                }
            }
        }
        return cmd;
    }

    private void addDeleteTreeElementFromTool(SiriusCommand cmd, DTreeElement element, TreeItemDeletionTool deleteTool) {
        EObject semanticElement = element.getTarget();
        EObject rootContainer = TreeHelper.getTree((EObject)element).getTarget();
        boolean delete = true;
        if (deleteTool.getPrecondition() != null && !StringUtil.isEmpty((String)deleteTool.getPrecondition().trim())) {
            delete = false;
            IInterpreter acceleoInterpreter = InterpreterUtil.getInterpreter((EObject)semanticElement);
            acceleoInterpreter.setVariable("root", (Object)rootContainer);
            acceleoInterpreter.setVariable("element", (Object)semanticElement);
            try {
                delete = acceleoInterpreter.evaluateBoolean(semanticElement, deleteTool.getPrecondition());
            }
            catch (EvaluationException e) {
                RuntimeLoggerManager.INSTANCE.error((EObject)deleteTool, (EStructuralFeature)ToolPackage.eINSTANCE.getAbstractToolDescription_Precondition(), (Throwable)e);
            }
            acceleoInterpreter.unSetVariable("root");
            acceleoInterpreter.unSetVariable("element");
        }
        if (delete) {
            cmd.getTasks().addAll(this.buildCommandFromModelOfTool(semanticElement, deleteTool, element.eContainer()).getTasks());
            cmd.getTasks().add(new DeleteDRepresentationElementsTask(this.modelAccessor, (DCommand)cmd, this.commandTaskHelper, (DRepresentationElement)element));
        } else {
            cmd.getTasks().add(UnexecutableTask.INSTANCE);
        }
    }

    protected SiriusCommand buildCommandFromModelOfTool(EObject semanticCurrentElement, AbstractToolDescription tool, EObject containerView) {
        SiriusCommand result = new SiriusCommand(this.domain);
        if (!this.getPermissionAuthority().canEditInstance(containerView)) {
            result = new InvalidPermissionCommand(this.domain, new EObject[]{containerView});
        } else {
            HashMap<TreeVariable, EObject> variables = new HashMap<TreeVariable, EObject>();
            if (tool instanceof TreeItemDeletionTool) {
                TreeItemDeletionTool deleteTool = (TreeItemDeletionTool)tool;
                if (containerView instanceof DTreeElement) {
                    variables.put(TreeHelper.getVariable(deleteTool, "root"), TreeHelper.getTree(containerView).getTarget());
                } else if (containerView instanceof DTree) {
                    variables.put(TreeHelper.getVariable(deleteTool, "root"), ((DTree)containerView).getTarget());
                }
                variables.put(TreeHelper.getVariable(deleteTool, "element"), semanticCurrentElement);
                result.getTasks().add(new InitInterpreterVariablesTask(variables, InterpreterUtil.getInterpreter((EObject)semanticCurrentElement), this.uiCallBack));
                result.getTasks().add(this.commandTaskHelper.buildTaskFromModelOperation((DRepresentation)TreeHelper.getTree(containerView), semanticCurrentElement, deleteTool.getFirstModelOperation()));
            } else if (tool instanceof TreeItemCreationTool) {
                TreeItemCreationTool creationTool = (TreeItemCreationTool)tool;
                if (containerView instanceof DTreeElement) {
                    variables.put(TreeHelper.getVariable(creationTool, "root"), TreeHelper.getTree(containerView).getTarget());
                    if (containerView instanceof DTreeItem) {
                        variables.put(TreeHelper.getVariable(creationTool, "container"), ((DTreeItem)containerView).getTarget());
                    }
                } else if (containerView instanceof DTree) {
                    variables.put(TreeHelper.getVariable(creationTool, "root"), ((DTree)containerView).getTarget());
                    variables.put(TreeHelper.getVariable(creationTool, "container"), ((DTree)containerView).getTarget());
                }
                variables.put(TreeHelper.getVariable(creationTool, "element"), semanticCurrentElement);
                result.getTasks().add(new InitInterpreterVariablesTask(variables, InterpreterUtil.getInterpreter((EObject)semanticCurrentElement), this.uiCallBack));
                result.getTasks().add(this.commandTaskHelper.buildTaskFromModelOperation((DRepresentation)TreeHelper.getTree(containerView), semanticCurrentElement, creationTool.getFirstModelOperation()));
            }
        }
        return result;
    }

    private TreeItemDeletionTool getDeleteTool(DTreeElement element) {
        TreeItemDeletionTool result = null;
        if (element instanceof DTreeItem) {
            result = ((DTreeItem)element).getActualMapping().getDelete();
        }
        return result;
    }

    @Override
    public Command buildCreateLineCommandFromTool(DTreeItemContainer lineContainer, EObject semanticCurrentElement, TreeItemCreationTool tool) {
        UnexecutableCommand result = UnexecutableCommand.INSTANCE;
        if (!this.getPermissionAuthority().canEditInstance((EObject)lineContainer)) {
            result = new InvalidPermissionCommand(this.domain, new EObject[]{lineContainer});
        } else if (this.commandTaskHelper.checkPrecondition(semanticCurrentElement, (AbstractToolDescription)tool)) {
            SiriusCommand createLineCommand = this.buildCommandFromModelOfTool(semanticCurrentElement, tool, (EObject)lineContainer);
            this.addRefreshTask(lineContainer, (DCommand)createLineCommand, tool);
            result = createLineCommand;
        }
        return result;
    }

    public DCommand buildCreateTreeFromDescription(TreeDescription description, EObject semanticElement, IProgressMonitor monitor) {
        SiriusCommand command = new SiriusCommand(this.domain){

            public boolean canUndo() {
                return false;
            }
        };
        command.getTasks().add(new CreateTreeTask(description, semanticElement, monitor));
        return command;
    }

    public AbstractCommand buildDoExecuteDetailsOperation(DSemanticDecorator target, RepresentationCreationDescription desc, String newRepresentationName) {
        SiriusCommand cmd = new SiriusCommand(this.domain);
        HashMap<ContainerViewVariable, DSemanticDecorator> variables = new HashMap<ContainerViewVariable, DSemanticDecorator>();
        variables.put(desc.getContainerViewVariable(), target);
        HashMap<NameVariable, String> stringVariables = new HashMap<NameVariable, String>();
        stringVariables.put(desc.getRepresentationNameVariable(), newRepresentationName);
        InitInterpreterVariablesTask initInterpreterVariables = new InitInterpreterVariablesTask(variables, stringVariables, InterpreterUtil.getInterpreter((EObject)target), this.uiCallBack);
        cmd.getTasks().add(initInterpreterVariables);
        cmd.getTasks().add(this.commandTaskHelper.buildTaskFromModelOperation((DRepresentation)TreeHelper.getTree((EObject)target), target.getTarget(), desc.getInitialOperation().getFirstModelOperations()));
        return cmd;
    }

    @Override
    public Command buildDirectEditLabelFromTool(DTreeItem editedTreeItem, TreeItemEditionTool directEditTool, String newValue) {
        SiriusCommand result = new SiriusCommand(this.domain, "Direct Edit on " + editedTreeItem.getName());
        if (!this.getPermissionAuthority().canEditInstance((EObject)editedTreeItem)) {
            result = new InvalidPermissionCommand(this.domain, new EObject[]{editedTreeItem});
        } else if (editedTreeItem.getUpdater() != null && editedTreeItem.getUpdater().getDirectEdit() != null) {
            EObject interpreterContext = editedTreeItem.getTarget();
            HashMap<ElementDropVariable, EObject> variables = new HashMap<ElementDropVariable, EObject>();
            variables.put(directEditTool.getRoot(), TreeHelper.getTree((EObject)editedTreeItem).getTarget());
            variables.put(directEditTool.getElement(), editedTreeItem.getTarget());
            result.getTasks().add(new InitInterpreterVariablesTask(variables, InterpreterUtil.getInterpreter((EObject)interpreterContext), this.uiCallBack));
            if (directEditTool.getMask() != null) {
                String messageFormat = directEditTool.getMask().getMask();
                result.getTasks().add(new InitInterpreterFromParsedVariableTask2(InterpreterUtil.getInterpreter((EObject)interpreterContext), messageFormat, (Object)newValue));
            }
            result.getTasks().add(this.commandTaskHelper.buildTaskFromModelOperation((DRepresentation)TreeHelper.getTree((EObject)editedTreeItem), interpreterContext, directEditTool.getFirstModelOperation()));
            RefreshTreeElementTask refreshTreeElementTask = new RefreshTreeElementTask((EObject)editedTreeItem);
            result.getTasks().add(refreshTreeElementTask);
        }
        return result;
    }

    @Override
    public Command buildDropItemFromTool(EObject dropped, DTreeItemContainer dropTarget, Collection<DTreeItem> precedingSiblings, TreeItemContainerDropTool dropTool) {
        SiriusCommand result = new SiriusCommand(this.domain, "Drop the item " + dropped);
        EObject dropSem = dropped;
        DSemanticDecorator dropDec = null;
        DSemanticDecorator oldContainer = null;
        if (dropped instanceof DSemanticDecorator) {
            dropDec = (DSemanticDecorator)dropped;
            dropSem = dropDec.getTarget();
            oldContainer = this.getOldContainer(dropDec);
        }
        EObject interpreterContext = dropTarget.getTarget();
        HashMap<Object, Object> variables = new HashMap<Object, Object>();
        if (dropDec != null) {
            variables.put(dropTool.getOldContainer(), oldContainer);
        }
        variables.put(dropTool.getNewContainer(), dropTarget.getTarget());
        variables.put(dropTool.getElement(), dropSem);
        variables.put(dropTool.getNewViewContainer(), dropTarget);
        variables.put(dropTool.getPrecedingSiblings(), precedingSiblings);
        result.getTasks().add(new InitInterpreterVariablesTask(variables, InterpreterUtil.getInterpreter((EObject)interpreterContext), this.uiCallBack));
        DTree droppedTree = TreeHelper.getTree((EObject)dropTarget);
        if (dropTool.getFirstModelOperation() != null) {
            result.getTasks().add(this.commandTaskHelper.buildTaskFromModelOperation((DRepresentation)droppedTree, interpreterContext, dropTool.getFirstModelOperation()));
        }
        if (droppedTree != null) {
            this.addRefreshTask(droppedTree, (DCommand)result, dropTool);
        }
        if (dropDec != null) {
            this.addRefreshTask(dropDec, (DCommand)result, dropTool);
        }
        return result;
    }

    private DSemanticDecorator getOldContainer(DSemanticDecorator dropDec) {
        EObject semanticOldContainer = null;
        DSemanticDecorator oldContainer = null;
        EObject currentOldContainer = dropDec.eContainer();
        while (currentOldContainer != null && semanticOldContainer == null) {
            if (currentOldContainer instanceof DSemanticDecorator) {
                oldContainer = (DSemanticDecorator)currentOldContainer;
                semanticOldContainer = oldContainer.getTarget();
            }
            currentOldContainer = currentOldContainer.eContainer();
        }
        return oldContainer;
    }

    @Override
    public Command buildOperationActionFromTool(OperationAction operationAction, final DTreeItem selectedItem) {
        SiriusCommand result = new SiriusCommand(this.domain, String.valueOf(operationAction.getName()) + " on " + selectedItem.getName());
        HashMap<ContainerViewVariable, DTreeItem> variables = new HashMap<ContainerViewVariable, DTreeItem>();
        EObject interpreterContext = selectedItem.getTarget();
        variables.put(operationAction.getView(), selectedItem);
        result.getTasks().add(new InitInterpreterVariablesTask(variables, InterpreterUtil.getInterpreter((EObject)interpreterContext), this.uiCallBack));
        DTree targetTree = TreeHelper.getTree((EObject)selectedItem);
        result.getTasks().add(this.commandTaskHelper.buildTaskFromModelOperation((DRepresentation)targetTree, interpreterContext, operationAction.getInitialOperation().getFirstModelOperations()));
        this.addRefreshTask(targetTree, (DCommand)result, null);
        return result.chain((Command)new RecordingCommand(this.domain){

            protected void doExecute() {
                selectedItem.setExpanded(true);
            }
        });
    }

    @Override
    public Command buildJavaActionFromTool(ExternalJavaAction javaActionItem, DTreeItem selectedItem, IExternalJavaAction javaAction) {
        CompoundCommand compoundCommand = new CompoundCommand();
        LinkedHashSet views = Sets.newLinkedHashSet();
        views.add(selectedItem);
        JavaActionFromToolCommand javaActionFromToolCommand = new JavaActionFromToolCommand(this.domain, javaAction, javaActionItem, (Collection)views);
        compoundCommand.append((Command)javaActionFromToolCommand);
        SiriusCommand dCommand = new SiriusCommand(this.domain, selectedItem.getName());
        this.addRefreshTask(selectedItem, (DCommand)dCommand, (AbstractToolDescription)javaActionItem);
        compoundCommand.append((Command)dCommand);
        return compoundCommand;
    }
}

