/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.api.resource;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLParserPoolImpl;
import org.eclipse.sirius.business.internal.resource.parser.XMIModelFileSaxParser;
import org.eclipse.sirius.viewpoint.SiriusPlugin;

public class LoadEMFResource
implements Runnable {
    private final IFile file;
    private Resource res;
    private ResourceSet set;

    public LoadEMFResource(ResourceSet set, IFile file) {
        this.file = (IFile)Preconditions.checkNotNull((Object)file);
        this.set = (ResourceSet)Preconditions.checkNotNull((Object)set);
    }

    @Override
    public void run() {
        String path = this.file.getFullPath().toOSString();
        try {
            URI uri = URI.createPlatformResourceURI((String)path, (boolean)true);
            if (this.shouldBeAbleToLoad()) {
                this.res = this.set.getResource(uri, true);
                if (!this.res.getErrors().isEmpty()) {
                    this.unload();
                }
                this.res.load(this.getOptions());
            }
        }
        catch (RuntimeException e) {
            this.error(path, e);
        }
        catch (IOException e) {
            this.error(path, e);
        }
    }

    private Map<?, ?> getOptions() {
        HashMap<String, Boolean> options = new HashMap<String, Boolean>();
        options.put("DEFER_ATTACHMENT", Boolean.TRUE);
        options.put("DEFER_IDREF_RESOLUTION", Boolean.TRUE);
        options.put("USE_DEPRECATED_METHODS", Boolean.FALSE);
        options.put("USE_PARSER_POOL", (Boolean)new XMLParserPoolImpl(true));
        return options;
    }

    private void error(String path, Exception e) {
        SiriusPlugin.getDefault().error("Unable to load resource " + path, e);
        this.unload();
    }

    private void unload() {
        if (this.res != null) {
            this.res.unload();
            this.set.getResources().remove((Object)this.res);
            this.res = null;
        }
    }

    public Resource getLoadedResource() {
        return this.res;
    }

    private boolean shouldBeAbleToLoad() {
        URI uri = URI.createPlatformResourceURI((String)this.file.getFullPath().toOSString(), (boolean)true);
        boolean ableToLoad = true;
        if (this.set.getResourceFactoryRegistry().getFactory(uri, null).getClass() == XMIResourceFactoryImpl.class) {
            XMIModelFileSaxParser modelFileSaxParser = new XMIModelFileSaxParser(this.file);
            modelFileSaxParser.analyze((IProgressMonitor)new NullProgressMonitor());
            ableToLoad = modelFileSaxParser.isLoadable();
        }
        return ableToLoad;
    }
}

