/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.helper.task;

import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.business.api.helper.task.DeleteEObjectTask;
import org.eclipse.sirius.business.api.helper.task.ICommandTask;
import org.eclipse.sirius.business.api.helper.task.TaskHelper;
import org.eclipse.sirius.business.api.preferences.SiriusPreferencesKeys;
import org.eclipse.sirius.business.api.query.EObjectQuery;
import org.eclipse.sirius.business.internal.helper.task.AbstractCompoundTask;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.tools.api.command.DCommand;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;

public class DeleteDRepresentationElementsTask
extends AbstractCompoundTask {
    private DCommand cmd;
    private DRepresentationElement repElt;
    private ModelAccessor modelAccessor;
    private TaskHelper taskHelper;

    public DeleteDRepresentationElementsTask(ModelAccessor modelAcessor, DCommand cmd, TaskHelper taskHelper, DRepresentationElement repElt) {
        this.cmd = cmd;
        this.modelAccessor = modelAcessor;
        this.taskHelper = taskHelper;
        this.repElt = repElt;
    }

    @Override
    protected List<ICommandTask> prepareSubTasks() {
        ArrayList<ICommandTask> tasks = new ArrayList<ICommandTask>();
        EObject root = null;
        boolean automaticRefresh = Platform.getPreferencesService().getBoolean("org.eclipse.sirius", SiriusPreferencesKeys.PREF_AUTO_REFRESH.name(), false, null);
        if (automaticRefresh) {
            root = EcoreUtil.getRootContainer((EObject)this.repElt);
        } else {
            EObjectQuery eObjectQuery = new EObjectQuery(this.repElt);
            root = (EObject)eObjectQuery.getRepresentation().get();
        }
        Set<DSemanticDecorator> vpElements = this.taskHelper.getDElementToClearFromSemanticElements(root, this.completeCollection(this.cmd.getDeletedObjects()));
        if (this.repElt.eContainer() != null && (this.repElt.getTarget() == null || this.repElt.getTarget().eContainer() == null)) {
            vpElements.add(this.repElt);
        }
        for (DSemanticDecorator semDec : vpElements) {
            tasks.add(new DeleteEObjectTask(semDec, this.modelAccessor));
            this.addDialectSpecificAdditionalDeleteSubTasks(semDec, tasks);
        }
        return tasks;
    }

    protected void addDialectSpecificAdditionalDeleteSubTasks(DSemanticDecorator decorator, List<ICommandTask> subTasks) {
    }

    @Override
    public String getLabel() {
        return "Delete representation elements task";
    }

    private Set<EObject> completeCollection(Collection<EObject> semantics) {
        HashSet result = Sets.newHashSet(semantics);
        for (EObject sem : semantics) {
            Iterators.addAll((Collection)result, (Iterator)sem.eAllContents());
        }
        return result;
    }
}

