/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.helper.task.operations;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.helper.task.AbstractCommandTask;
import org.eclipse.sirius.business.api.helper.task.ICommandTask;
import org.eclipse.sirius.business.api.helper.task.ICreationTask;
import org.eclipse.sirius.business.internal.helper.task.ExecuteToolOperationTask;
import org.eclipse.sirius.business.internal.helper.task.IDeletionTask;
import org.eclipse.sirius.business.internal.helper.task.IModificationTask;
import org.eclipse.sirius.business.internal.helper.task.operations.AbstractOperationTask;
import org.eclipse.sirius.business.internal.helper.task.operations.InterpretedExpressionVariableTask;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.ecore.extender.business.api.accessor.exception.FeatureNotFoundException;
import org.eclipse.sirius.ecore.extender.business.api.accessor.exception.MetaClassNotFoundException;
import org.eclipse.sirius.tools.api.command.CommandContext;
import org.eclipse.sirius.tools.api.command.ui.UICallBack;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.sirius.viewpoint.description.tool.For;
import org.eclipse.sirius.viewpoint.description.tool.ModelOperation;

public class ForTask
extends AbstractOperationTask
implements ICreationTask,
IDeletionTask {
    private final UICallBack uiCallback;
    private final For forOp;

    public ForTask(CommandContext context, ModelAccessor extPackage, For forOp, IInterpreter interpreter, UICallBack uiCallback) {
        super(context, extPackage, interpreter);
        this.forOp = forOp;
        this.uiCallback = uiCallback;
    }

    @Override
    public void execute() throws MetaClassNotFoundException, FeatureNotFoundException {
        List<Object> contextTargets = CommandContext.getContextTargets(this.forOp, this.context);
        String iteratorName = this.forOp.getIteratorName();
        EObject childOperationsContext = this.context.getCurrentTarget();
        for (Object currentTarget : contextTargets) {
            if (currentTarget instanceof EObject) {
                childOperationsContext = (EObject)currentTarget;
            }
            AbstractCommandTask childTask = new InterpretedExpressionVariableTask(this.context, this.extPackage, 0, iteratorName, currentTarget, this.interpreter);
            this.getChildrenTasks().add(childTask);
            for (ModelOperation currentOperation : this.forOp.getSubModelOperations()) {
                childTask = new ExecuteToolOperationTask(this.extPackage, childOperationsContext, this.context.getRepresentation(), currentOperation, this.uiCallback);
                this.getChildrenTasks().add(childTask);
            }
            childTask = new InterpretedExpressionVariableTask(this.context, this.extPackage, 1, iteratorName, currentTarget, this.interpreter);
            this.getChildrenTasks().add(childTask);
        }
        for (ICommandTask childTask : this.getChildrenTasks()) {
            childTask.execute();
        }
    }

    @Override
    public boolean executeMyselfChildrenTasks() {
        return true;
    }

    @Override
    public String getLabel() {
        return "a for task";
    }

    @Override
    public Collection<EObject> getCreatedReferences() {
        HashSet<EObject> result = new HashSet<EObject>();
        for (ICommandTask task : this.getChildrenTasks()) {
            if (!(task instanceof IModificationTask)) continue;
            result.addAll(((IModificationTask)((Object)task)).getCreatedReferences());
        }
        return result;
    }

    @Override
    public Collection<EObject> getAffectedElements() {
        HashSet<EObject> result = new HashSet<EObject>();
        for (ICommandTask task : this.getChildrenTasks()) {
            if (!(task instanceof IModificationTask)) continue;
            result.addAll(((IModificationTask)((Object)task)).getAffectedElements());
        }
        return result;
    }

    @Override
    public Collection<EObject> getCreatedElements() {
        HashSet<EObject> result = new HashSet<EObject>();
        for (ICommandTask task : this.getChildrenTasks()) {
            if (!(task instanceof ICreationTask)) continue;
            result.addAll(((ICreationTask)((Object)task)).getCreatedElements());
        }
        return result;
    }

    @Override
    public Collection<EObject> getDeletedElements() {
        HashSet<EObject> result = new HashSet<EObject>();
        for (ICommandTask task : this.getChildrenTasks()) {
            if (!(task instanceof IDeletionTask)) continue;
            result.addAll(((IDeletionTask)((Object)task)).getDeletedElements());
        }
        return result;
    }

    @Override
    public Collection<DRepresentationElement> getCreatedRepresentationElements() {
        return Collections.emptySet();
    }
}

