/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.migration;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xml.type.AnyType;
import org.eclipse.sirius.business.api.migration.AbstractRepresentationsFileMigrationParticipant;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DView;
import org.osgi.framework.Version;

public class Sirius3CleanUpParticipant
extends AbstractRepresentationsFileMigrationParticipant {
    private static final Version MIGRATION_VERSION = new Version("10.0.0.201504010000");
    private Map<DView, EStructuralFeature> initializedFeature = new HashMap<DView, EStructuralFeature>();

    @Override
    protected void postLoad(DAnalysis dAnalysis, Version loadedVersion) {
        if (loadedVersion.compareTo(MIGRATION_VERSION) < 0) {
            Set<DView> keySet = this.initializedFeature.keySet();
            for (DView dView : keySet) {
                EStructuralFeature eStructuralFeature = this.initializedFeature.get(dView);
                Resource eResource = dView.eResource();
                AnyType anyType = (AnyType)((XMLResource)eResource).getEObjectToExtensionMap().get(dView);
                FeatureMap any = anyType.getAnyAttribute();
                FeatureMap.Entry entryToRemove = null;
                for (FeatureMap.Entry entry : any) {
                    if (!entry.getEStructuralFeature().equals(eStructuralFeature)) continue;
                    entryToRemove = entry;
                    break;
                }
                any.remove(entryToRemove);
            }
        }
        this.initializedFeature.clear();
        super.postLoad(dAnalysis, loadedVersion);
    }

    @Override
    protected void handleFeature(EObject owner, EStructuralFeature unkownFeature, Object valueOfUnknownFeature) {
        AnyType anyType;
        Resource eResource;
        if (owner instanceof DView && unkownFeature.getName().equals("initialized") && (eResource = owner.eResource()) != null && (anyType = (AnyType)((XMLResource)eResource).getEObjectToExtensionMap().get(owner)) != null) {
            FeatureMap any = anyType.getAnyAttribute();
            for (FeatureMap.Entry entry : any) {
                if (!entry.getEStructuralFeature().equals(unkownFeature)) continue;
                this.initializedFeature.put((DView)owner, unkownFeature);
            }
        }
        super.handleFeature(owner, unkownFeature, valueOfUnknownFeature);
    }

    @Override
    public Version getMigrationVersion() {
        return MIGRATION_VERSION;
    }
}

