/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.modelingproject.manager;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.sirius.business.api.modelingproject.ModelingProject;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.viewpoint.SiriusPlugin;

public class InitializeModelingProjectJob
extends WorkspaceJob {
    public static final String JOB_LABEL = "Initializing Modeling Projects";
    public static final String JOB_LABEL_FOR_EMPTY_PROJECTS = "Initializing Empty Modeling Projects";
    private static final String JOB_FAMILY_ID = "org.eclipse.sirius.initializemodelingprojects";
    private List<IProject> projects;
    private boolean forceInit;

    public InitializeModelingProjectJob() {
        this(JOB_LABEL);
    }

    public InitializeModelingProjectJob(List<IProject> projects) {
        this(Iterators.all(projects.iterator(), (Predicate)new Predicate<IProject>(){

            public boolean apply(IProject input) {
                try {
                    return input.members().length == 1;
                }
                catch (CoreException coreException) {
                    return false;
                }
            }
        }) ? JOB_LABEL_FOR_EMPTY_PROJECTS : JOB_LABEL);
        this.projects = projects;
    }

    public InitializeModelingProjectJob(String name) {
        super(name);
    }

    public static IStatus initializeModelingProjects(List<IProject> projects, boolean forceInit, IProgressMonitor monitor) {
        ArrayList errorStatus = Lists.newArrayList();
        try {
            IProject[] projectsTable = projects != null ? projects.toArray(new IProject[0]) : ResourcesPlugin.getWorkspace().getRoot().getProjects();
            monitor.beginTask("", projectsTable.length);
            int i = 0;
            while (i < projectsTable.length) {
                Option<ModelingProject> optionalModelingProject = ModelingProject.asModelingProject(projectsTable[i]);
                if (optionalModelingProject.some()) {
                    try {
                        ((ModelingProject)optionalModelingProject.get()).getProject().deleteMarkers("org.eclipse.sirius.modelingMarker", false, 0);
                    }
                    catch (CoreException e) {
                        SiriusPlugin.getDefault().getLog().log(e.getStatus());
                    }
                    try {
                        ((ModelingProject)optionalModelingProject.get()).getMainRepresentationsFileURI((IProgressMonitor)new SubProgressMonitor(monitor, 1), forceInit, true);
                    }
                    catch (IllegalArgumentException e) {
                        errorStatus.add(new Status(4, "org.eclipse.sirius", 0, e.getMessage(), null));
                    }
                } else {
                    monitor.worked(1);
                }
                ++i;
            }
        }
        finally {
            monitor.done();
        }
        IStatus result = Status.OK_STATUS;
        if (errorStatus.size() == 1) {
            result = new MultiStatus("org.eclipse.sirius", 4, errorStatus.toArray(new IStatus[0]), "One modeling project is invalid.", null);
        } else if (errorStatus.size() > 1) {
            result = new MultiStatus("org.eclipse.sirius", 4, errorStatus.toArray(new IStatus[0]), "Several modeling projects are invalid.", null);
        }
        return result;
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) {
        return InitializeModelingProjectJob.initializeModelingProjects(this.projects, this.forceInit, monitor);
    }

    public void setForceInit(boolean forceInit) {
        this.forceInit = forceInit;
    }

    public boolean belongsTo(Object family) {
        return JOB_FAMILY_ID.equals(family);
    }
}

