/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.session;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.api.helper.SiriusUtil;
import org.eclipse.sirius.business.api.session.AbstractSavingPolicy;
import org.eclipse.sirius.business.internal.session.danalysis.ResourceSaveDiagnose;
import org.eclipse.sirius.common.tools.api.resource.ResourceMigrationMarker;
import org.eclipse.sirius.common.tools.api.resource.ResourceSetSync;
import org.eclipse.sirius.viewpoint.SiriusPlugin;

public class IsModifiedSavingPolicy
extends AbstractSavingPolicy {
    private Predicate<Resource> isModified = new Predicate<Resource>(){

        public boolean apply(Resource resource) {
            return resource.isModified() || ResourceMigrationMarker.hasMigrationMarker((Resource)resource);
        }
    };
    private Predicate<Resource> underlyingFileIsDeletedOrConflicting = new Predicate<Resource>(){

        public boolean apply(Resource resource) {
            ResourceSetSync.ResourceStatus resourceStatus = ResourceSetSync.getStatus((Resource)resource);
            return resourceStatus == ResourceSetSync.ResourceStatus.DELETED || resourceStatus == ResourceSetSync.ResourceStatus.CONFLICTING_DELETED;
        }
    };

    public IsModifiedSavingPolicy(TransactionalEditingDomain domain) {
        super(domain);
    }

    @Override
    public Collection<Resource> computeResourcesToSave(Set<Resource> scope, Map<?, ?> options, IProgressMonitor monitor) {
        final HashMap mergedOptions = new HashMap(this.getDefaultSaveOptions());
        if (options != null) {
            mergedOptions.putAll(options);
        }
        LinkedHashSet saveable = Sets.newLinkedHashSet((Iterable)Iterables.filter(scope, (Predicate)new Predicate<Resource>(){

            public boolean apply(Resource resourcetoSave) {
                return resourcetoSave.getURI().isFile() || resourcetoSave.getURI().isPlatformResource() && !SiriusUtil.isModelerDescriptionFile(resourcetoSave);
            }
        }));
        LinkedHashSet logicallyModified = Sets.newLinkedHashSet((Iterable)Iterables.filter((Iterable)saveable, this.isModified));
        LinkedHashSet dependOnLogicallyModified = Sets.newLinkedHashSet();
        if (logicallyModified.size() > 0) {
            Iterables.addAll((Collection)dependOnLogicallyModified, (Iterable)Iterables.filter((Iterable)Sets.difference((Set)saveable, (Set)logicallyModified), (Predicate)new ResourceHasReferenceTo(this.isModified)));
        }
        Predicate<Resource> exists = new Predicate<Resource>(){
            private URIConverter defaultConverter;

            public boolean apply(Resource resourcetoSave) {
                ResourceSet rs = resourcetoSave.getResourceSet();
                URIConverter uriConverter = rs == null ? this.getDefaultURIConverter() : rs.getURIConverter();
                return uriConverter.exists(resourcetoSave.getURI(), mergedOptions);
            }

            private URIConverter getDefaultURIConverter() {
                if (this.defaultConverter == null) {
                    this.defaultConverter = new ResourceSetImpl().getURIConverter();
                }
                return this.defaultConverter;
            }
        };
        LinkedHashSet underlyingFileDoesNotExist = Sets.newLinkedHashSet((Iterable)Iterables.filter((Iterable)saveable, (Predicate)Predicates.not((Predicate)exists)));
        LinkedHashSet isConflictingOrDeleted = Sets.newLinkedHashSet((Iterable)Iterables.filter((Iterable)saveable, this.underlyingFileIsDeletedOrConflicting));
        LinkedHashSet toSave = Sets.newLinkedHashSet();
        for (Resource resource : Sets.union((Set)logicallyModified, (Set)dependOnLogicallyModified)) {
            if (this.hasDifferentSerialization(resource, mergedOptions)) {
                toSave.add(resource);
                continue;
            }
            ResourceMigrationMarker.clearMigrationMarker((Resource)resource);
        }
        Iterables.addAll((Collection)toSave, (Iterable)Sets.union((Set)underlyingFileDoesNotExist, (Set)isConflictingOrDeleted));
        return toSave;
    }

    private boolean hasDifferentSerialization(Resource input, Map<?, ?> options) {
        ResourceSaveDiagnose diagnose = new ResourceSaveDiagnose(input);
        try {
            return diagnose.isSaveable() && diagnose.hasDifferentSerialization(options);
        }
        catch (IOException e) {
            SiriusPlugin.getDefault().error("Error saving resource", e);
            return false;
        }
    }

    private static class EObjectHasReferencesTo
    implements Predicate<EObject> {
        private final Predicate<Resource> modifiedResources;

        public EObjectHasReferencesTo(Predicate<Resource> logicallyModifieds) {
            this.modifiedResources = logicallyModifieds;
        }

        public boolean apply(EObject source) {
            if (!source.eIsProxy()) {
                for (EReference ref : source.eClass().getEAllReferences()) {
                    if (ref.isTransient() || ref.isContainment()) continue;
                    for (EObject target : this.getReferencedEObjects(source, ref)) {
                        Resource targetResource = target.eResource();
                        if (target.eIsProxy() || targetResource == null || !this.modifiedResources.apply((Object)targetResource)) continue;
                        return true;
                    }
                }
            }
            return false;
        }

        protected Collection<EObject> getReferencedEObjects(EObject source, EReference ref) {
            Object val = source.eGet((EStructuralFeature)ref, false);
            Collection<Object> values = Collections.emptySet();
            if (ref.isMany() && val instanceof Collection) {
                values = (Collection)val;
            } else if (val instanceof EObject) {
                values = Collections.singleton((EObject)val);
            }
            return values;
        }
    }

    private static class ResourceHasReferenceTo
    implements Predicate<Resource> {
        private final Predicate<Resource> modifiedResources;

        public ResourceHasReferenceTo(Predicate<Resource> logicallyModifieds) {
            this.modifiedResources = logicallyModifieds;
        }

        public boolean apply(Resource resource) {
            EObjectHasReferencesTo hasOuterRef = new EObjectHasReferencesTo(this.modifiedResources);
            return Iterators.any((Iterator)EcoreUtil.getAllProperContents((Resource)resource, (boolean)false), (Predicate)hasOuterRef);
        }
    }
}

