/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tools.api.interpreter;

import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.query.EObjectQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.tools.api.interpreter.CompoundInterpreter;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.sirius.viewpoint.description.JavaExtension;
import org.eclipse.sirius.viewpoint.description.Viewpoint;

public class InterpreterRegistry {
    public static final String ERROR_MSG_IMPOSSIBLE_TO_FIND_AN_INTERPRETER = "Impossible to find an interpreter";

    public IInterpreter getInterpreter(EObject modelElement) {
        IInterpreter result = null;
        Session session = new EObjectQuery(modelElement).getSession();
        if (session == null && modelElement instanceof DSemanticDecorator) {
            DSemanticDecorator dSemanticDecorator = (DSemanticDecorator)modelElement;
            session = new EObjectQuery(dSemanticDecorator.getTarget()).getSession();
        }
        if (session != null) {
            result = session.getInterpreter();
        } else {
            String reason = modelElement == null ? "Model element is null" : "Could not find a session for model element : " + modelElement;
            SiriusPlugin.getDefault().error("Impossible to find an interpreter - " + reason, new RuntimeException());
            result = CompoundInterpreter.INSTANCE;
        }
        return result;
    }

    public static void prepareImportsFromSession(IInterpreter inter, Session session) {
        Collection imports = inter.getImports();
        LinkedHashSet<String> allImports = new LinkedHashSet<String>();
        if (session != null) {
            for (Viewpoint vp : session.getSelectedViewpoints(false)) {
                if (vp.eResource() == null) continue;
                for (JavaExtension javaExtension : vp.getOwnedJavaExtensions()) {
                    allImports.add(javaExtension.getQualifiedClassName());
                }
            }
        }
        if (allImports.size() != imports.size() || !Iterables.elementsEqual(allImports, (Iterable)imports)) {
            inter.clearImports();
            for (String dependency : allImports) {
                inter.addImport(dependency);
            }
        }
    }
}

