/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.ui.synchronize;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareNavigator;
import org.eclipse.compare.ICompareNavigator;
import org.eclipse.compare.INavigatable;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.synchronize.SyncInfoModelElement;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.team.ui.synchronize.SaveableCompareEditorInput;
import org.eclipse.ui.progress.UIJob;

public final class SyncInfoCompareInput
extends SaveableCompareEditorInput
implements IResourceChangeListener {
    private MyDiffNode node;
    private String description;
    private IResource resource;
    private ISynchronizeParticipant participant;
    private ISynchronizePageConfiguration synchronizeConfiguration;
    static /* synthetic */ Class class$0;

    public SyncInfoCompareInput(String description, SyncInfo sync) {
        super(SyncInfoCompareInput.getDefaultCompareConfiguration(), null);
        Assert.isNotNull((Object)sync);
        Assert.isNotNull((Object)description);
        this.description = description;
        this.resource = sync.getLocal();
        this.node = new MyDiffNode(null, sync);
        this.setTitle(NLS.bind((String)TeamUIMessages.SyncInfoCompareInput_title, (Object[])new String[]{sync.getLocal().getName()}));
    }

    public SyncInfoCompareInput(ISynchronizeParticipant participant, SyncInfo sync) {
        this(participant.getName(), sync);
        this.participant = participant;
    }

    public SyncInfoCompareInput(ISynchronizePageConfiguration configuration, SyncInfo info) {
        this(configuration.getParticipant(), info);
        this.synchronizeConfiguration = configuration;
    }

    protected void handleDispose() {
        ICompareNavigator navigator;
        super.handleDispose();
        if (this.synchronizeConfiguration != null && (navigator = (ICompareNavigator)this.synchronizeConfiguration.getProperty("org.eclipse.team.ui.P_INPUT_NAVIGATOR")) != null && navigator == super.getNavigator()) {
            this.synchronizeConfiguration.setProperty("org.eclipse.team.ui.P_INPUT_NAVIGATOR", new CompareNavigator(){

                protected INavigatable[] getNavigatables() {
                    return new INavigatable[0];
                }
            });
        }
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IFile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(adapter) && this.resource.getType() == 1) {
            return this.resource;
        }
        return super.getAdapter(adapter);
    }

    private static CompareConfiguration getDefaultCompareConfiguration() {
        CompareConfiguration cc = new CompareConfiguration();
        return cc;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta resourceDelta;
        IResourceDelta delta = event.getDelta();
        if (delta != null && (resourceDelta = delta.findMember(this.resource.getFullPath())) != null) {
            UIJob job = new UIJob(""){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    SyncInfoCompareInput.this.isSaveNeeded();
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
        }
    }

    protected ICompareInput prepareCompareInput(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        this.setTitle(this.getTitle());
        monitor.beginTask(TeamUIMessages.SyncInfoCompareInput_3, 100);
        monitor.setTaskName(TeamUIMessages.SyncInfoCompareInput_3);
        try {
            try {
                if (this.participant != null) {
                    this.participant.prepareCompareInput(this.node, this.getCompareConfiguration(), Policy.subMonitorFor(monitor, 100));
                } else {
                    Utils.updateLabels(this.node.getSyncInfo(), this.getCompareConfiguration(), monitor);
                    this.node.cacheContents(Policy.subMonitorFor(monitor, 100));
                }
            }
            catch (TeamException e) {
                throw new InvocationTargetException(e);
            }
        }
        finally {
            monitor.done();
        }
        return this.node;
    }

    public String getToolTipText() {
        return NLS.bind((String)TeamUIMessages.SyncInfoCompareInput_tooltip, (Object[])new String[]{Utils.shortenText(30, this.description), this.node.getResource().getFullPath().toString()});
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof SyncInfoCompareInput) {
            SyncInfo otherSyncInfo = ((SyncInfoCompareInput)((Object)other)).getSyncInfo();
            SyncInfo thisSyncInfo = this.getSyncInfo();
            return thisSyncInfo.equals((Object)otherSyncInfo) && this.node.getLeft().equals(((SyncInfoCompareInput)((Object)other)).node.getLeft());
        }
        return false;
    }

    public int hashCode() {
        return this.getSyncInfo().hashCode();
    }

    public SyncInfo getSyncInfo() {
        return this.node.getSyncInfo();
    }

    public boolean canRunAsJob() {
        return true;
    }

    public synchronized ICompareNavigator getNavigator() {
        if (this.synchronizeConfiguration != null && this.isSelectedInSynchronizeView()) {
            ICompareNavigator nav = (ICompareNavigator)this.synchronizeConfiguration.getProperty("org.eclipse.team.ui.P_NAVIGATOR");
            this.synchronizeConfiguration.setProperty("org.eclipse.team.ui.P_INPUT_NAVIGATOR", super.getNavigator());
            return nav;
        }
        return super.getNavigator();
    }

    private boolean isSelectedInSynchronizeView() {
        IStructuredSelection ss;
        Object element;
        ISelection s;
        if (this.synchronizeConfiguration != null && (s = this.synchronizeConfiguration.getSite().getSelectionProvider().getSelection()) instanceof IStructuredSelection && (element = (ss = (IStructuredSelection)s).getFirstElement()) instanceof SyncInfoModelElement) {
            SyncInfoModelElement sime = (SyncInfoModelElement)element;
            return sime.getSyncInfo().getLocal().equals((Object)this.resource);
        }
        return false;
    }

    protected void fireInputChange() {
        this.node.fireChange();
    }

    private static class MyDiffNode
    extends SyncInfoModelElement {
        public MyDiffNode(IDiffContainer parent, SyncInfo info) {
            super(parent, info);
        }

        public void fireChange() {
            super.fireChange();
        }
    }
}

