/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.services;

import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.acceleo.query.ast.Call;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IValidationResult;
import org.eclipse.acceleo.query.runtime.impl.ValidationServices;
import org.eclipse.acceleo.query.services.FilterService;
import org.eclipse.acceleo.query.validation.type.EClassifierLiteralType;
import org.eclipse.acceleo.query.validation.type.EClassifierSetLiteralType;
import org.eclipse.acceleo.query.validation.type.EClassifierType;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.acceleo.query.validation.type.SequenceType;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EcorePackage;

class EAllContentsService
extends FilterService {
    EAllContentsService(Method serviceMethod, Object serviceInstance) {
        super(serviceMethod, serviceInstance);
    }

    @Override
    public Set<IType> getType(Call call, ValidationServices services, IValidationResult validationResult, IReadOnlyQueryEnvironment queryEnvironment, List<IType> argTypes) {
        LinkedHashSet<IType> result = new LinkedHashSet<IType>();
        if (argTypes.get(0).getType() instanceof EClass) {
            EClass eCls = (EClass)argTypes.get(0).getType();
            if (eCls == EcorePackage.eINSTANCE.getEObject()) {
                if (argTypes.size() == 1) {
                    result.add(new SequenceType(queryEnvironment, argTypes.get(0)));
                } else if (argTypes.size() == 2 && argTypes.get(1) instanceof EClassifierLiteralType) {
                    result.add(new SequenceType(queryEnvironment, new EClassifierType(queryEnvironment, ((EClassifierLiteralType)argTypes.get(1)).getType())));
                } else if (argTypes.size() == 2 && argTypes.get(1) instanceof EClassifierSetLiteralType) {
                    for (EClassifier eClsFilter : ((EClassifierSetLiteralType)argTypes.get(1)).getEClassifiers()) {
                        result.add(new SequenceType(queryEnvironment, new EClassifierType(queryEnvironment, eClsFilter)));
                    }
                } else if (argTypes.size() == 2) {
                    result.addAll(super.getType(call, services, validationResult, queryEnvironment, argTypes));
                }
            } else {
                result.addAll(this.getTypeForSpecificType(services, queryEnvironment, argTypes, eCls));
            }
        } else {
            result.add(new SequenceType(queryEnvironment, services.nothing("Only EClass can contain other EClasses not %s", argTypes.get(0))));
        }
        return result;
    }

    private Set<IType> getTypeForSpecificType(ValidationServices services, IReadOnlyQueryEnvironment queryEnvironment, List<IType> argTypes, EClass receiverEClass) {
        LinkedHashSet<IType> result = new LinkedHashSet<IType>();
        if (argTypes.size() == 1) {
            LinkedHashSet<SequenceType> containedTypes = new LinkedHashSet<SequenceType>();
            for (EClass contained : queryEnvironment.getEPackageProvider().getAllContainedEClasses(receiverEClass)) {
                containedTypes.add(new SequenceType(queryEnvironment, new EClassifierType(queryEnvironment, (EClassifier)contained)));
            }
            result.addAll(containedTypes);
            if (result.isEmpty()) {
                result.add(new SequenceType(queryEnvironment, services.nothing("%s doesn't contain any other EClass", argTypes.get(0))));
            }
        } else if (argTypes.size() == 2) {
            LinkedHashSet filterTypes = Sets.newLinkedHashSet();
            if (argTypes.get(1) instanceof EClassifierSetLiteralType) {
                for (EClassifier eClassifier : ((EClassifierSetLiteralType)argTypes.get(1)).getEClassifiers()) {
                    filterTypes.add(new EClassifierType(queryEnvironment, eClassifier));
                }
            } else if (argTypes.get(1) instanceof EClassifierLiteralType) {
                filterTypes.add(argTypes.get(1));
            } else {
                Collection<EClassifier> eObjectEClasses = queryEnvironment.getEPackageProvider().getTypes("ecore", "EObject");
                for (EClassifier eObjectEClass : eObjectEClasses) {
                    filterTypes.add(new EClassifierType(queryEnvironment, eObjectEClass));
                }
            }
            for (IType filterType : filterTypes) {
                for (EClass containedEClass : queryEnvironment.getEPackageProvider().getAllContainedEClasses(receiverEClass)) {
                    IType lowerType = services.lower(new EClassifierType(queryEnvironment, (EClassifier)containedEClass), filterType);
                    if (lowerType == null) continue;
                    result.add(new SequenceType(queryEnvironment, lowerType));
                }
            }
            if (result.isEmpty()) {
                result.add(new SequenceType(queryEnvironment, services.nothing("%s can't contain %s direclty or indirectly", argTypes.get(0), argTypes.get(1))));
            }
        }
        return result;
    }
}

