/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.css.swt.dom;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Scrollable;

public abstract class AbstractControlSelectionEraseListener
implements Listener {
    public void handleEvent(Event event) {
        Scrollable control = (Scrollable)event.widget;
        int columnCount = this.getNumberOfColumns((Control)control);
        boolean selected = (event.detail & 2) != 0;
        boolean hot = (event.detail & 0x20) != 0;
        event.detail &= 0xFFFFFFDF;
        if (selected || hot) {
            String dataBorderKey;
            String dataBackgroundKey;
            boolean handlingOnlyHot;
            GC gc = event.gc;
            Rectangle area = control.getClientArea();
            boolean bl = handlingOnlyHot = !selected && hot;
            if (handlingOnlyHot && columnCount > 1) {
                return;
            }
            if (handlingOnlyHot) {
                dataBackgroundKey = "org.eclipse.e4.ui.css.swt.hotBackgroundColor";
                dataBorderKey = "org.eclipse.e4.ui.css.swt.hotBorderColor";
            } else {
                dataBackgroundKey = "org.eclipse.e4.ui.css.swt.selectionBackgroundColor";
                dataBorderKey = "org.eclipse.e4.ui.css.swt.selectionBorderColor";
            }
            Object dataBackground = control.getData(dataBackgroundKey);
            Object dataBorder = control.getData(dataBorderKey);
            Object dataSelectionForeground = control.getData("org.eclipse.e4.ui.css.swt.selectionForegroundColor");
            Color background = null;
            if (dataBackground instanceof Color && (background = (Color)dataBackground).isDisposed()) {
                return;
            }
            Color border = null;
            if (dataBorder instanceof Color && (border = (Color)dataBorder).isDisposed()) {
                return;
            }
            Color selectionForeground = null;
            selectionForeground = dataSelectionForeground instanceof Color ? (Color)dataSelectionForeground : control.getForeground();
            if (selectionForeground.isDisposed()) {
                return;
            }
            if (background == null && border == null) {
                return;
            }
            int width = area.width;
            if ((event.index == columnCount - 1 || columnCount == 0) && width > 0) {
                Region region = new Region();
                gc.getClipping(region);
                region.add(event.x, event.y, width, event.height);
                gc.setClipping(region);
                region.dispose();
            }
            if (background != null) {
                Color oldbackground = gc.getBackground();
                gc.setBackground(background);
                try {
                    gc.fillRectangle(0, area.y, area.width + 2, area.height);
                }
                finally {
                    gc.setBackground(oldbackground);
                }
            }
            if (border != null) {
                gc.setForeground(border);
                gc.drawRectangle(0, event.y, width - 1, event.height - 1);
            }
            gc.setForeground(selectionForeground);
            event.detail &= 0xFFFFFFF7;
            this.fixEventDetail((Control)control, event);
        }
    }

    protected abstract void fixEventDetail(Control var1, Event var2);

    protected abstract int getNumberOfColumns(Control var1);
}

