/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.tools.api.find;

import com.google.common.collect.Lists;
import java.util.List;

public abstract class AbstractFindLabelEngine {
    public static final int FORWARD = 1;
    public static final int BACKWARD = 0;
    private List<?> lastFilteredLabels = Lists.newArrayList();
    private String lastSearchText = "";
    private int lastSearchIndex = 0;
    private int direction = 1;

    public void initFind(String search) {
        if (this.lastSearchText != null && !this.lastSearchText.equals(search)) {
            this.lastFilteredLabels = this.filterLabels(search);
            this.lastSearchText = search;
            this.lastSearchIndex = -1;
        }
    }

    protected abstract List<?> filterLabels(String var1);

    public Object getNext() {
        if (this.lastFilteredLabels != null && this.lastFilteredLabels.size() > 0) {
            this.lastSearchIndex = this.lastSearchIndex == -1 ? 0 : (this.direction == 1 ? (this.lastSearchIndex + 1) % this.lastFilteredLabels.size() : (this.lastSearchIndex - 1 + this.lastFilteredLabels.size()) % this.lastFilteredLabels.size());
            if (this.lastSearchIndex < this.lastFilteredLabels.size()) {
                return this.lastFilteredLabels.get(this.lastSearchIndex);
            }
        }
        return null;
    }

    public void setDirection(int direction) {
        if (direction == 1 || direction == 0) {
            this.direction = direction;
        }
    }
}

