/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.api.part;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gmf.runtime.common.core.command.FileModificationValidator;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.image.ImageFileFormat;
import org.eclipse.gmf.runtime.diagram.ui.render.clipboard.DiagramGenerator;
import org.eclipse.gmf.runtime.diagram.ui.render.util.CopyToImageUtil;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.ui.internal.refresh.layout.SiriusCanonicalLayoutHandler;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.internal.part.OffscreenEditPartFactory;
import org.eclipse.sirius.ui.tools.api.actions.export.SizeTooLargeException;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Shell;

public class DiagramEditPartService
extends CopyToImageUtil {
    private static Class<?> exportToHtmlClass;
    private static Boolean canExportToHtml;
    private boolean exportToHtml;

    public static boolean canExportToHtml() {
        if (canExportToHtml == null) {
            try {
                exportToHtmlClass = Class.forName("org.eclipse.gmf.runtime.diagram.ui.render.util.CopyToHTMLImageUtil");
                canExportToHtml = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                canExportToHtml = false;
            }
        }
        return canExportToHtml;
    }

    public DiagramEditPart createDiagramEditPart(Diagram diagram, Shell shell, PreferencesHint preferencesHint) {
        return OffscreenEditPartFactory.getInstance().createDiagramEditPart(diagram, shell, preferencesHint);
    }

    public void arrangeCreatedViews(DiagramEditPart diagramEditPart) {
        SiriusCanonicalLayoutHandler.launchArrangeCommand(diagramEditPart);
    }

    public void exportToHtml() {
        this.exportToHtml = true;
    }

    public DiagramGenerator copyToImage(DiagramEditPart diagramEP, IPath destination, ImageFileFormat format, IProgressMonitor monitor) throws CoreException {
        if (this.exportToHtml && DiagramEditPartService.canExportToHtml()) {
            try {
                CopyToImageUtil copyToHmlUtil = (CopyToImageUtil)exportToHtmlClass.newInstance();
                return copyToHmlUtil.copyToImage(diagramEP, destination, format, monitor);
            }
            catch (InstantiationException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.sirius", -1, MessageFormat.format(Messages.DiagramEditPartService_imageExportException, "InstanciationException"), (Throwable)e));
            }
            catch (IllegalAccessException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.sirius", -1, MessageFormat.format(Messages.DiagramEditPartService_imageExportException, "IllegalAccessException"), (Throwable)e));
            }
            catch (OutOfMemoryError e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.sirius", -1, MessageFormat.format(Messages.DiagramEditPartService_imageExportException, "OutofMemoryError"), (Throwable)e));
            }
        }
        DiagramGenerator gen = this.getDiagramGenerator(diagramEP, format);
        List editParts = diagramEP.getPrimaryEditParts();
        Rectangle imageRect = gen.calculateImageRectangle(editParts);
        int maxSize = Integer.parseInt(DiagramUIPlugin.INSTANCE.getString("_Pref_DiagramExportSizeMax"));
        if (imageRect.height * imageRect.width > maxSize && format != ImageFileFormat.SVG) {
            String representationName = ((DSemanticDiagram)((Diagram)diagramEP.getModel()).getElement()).getName();
            throw new SizeTooLargeException((IStatus)new Status(4, "org.eclipse.sirius", representationName));
        }
        return super.copyToImage(diagramEP, destination, format, monitor);
    }

    protected void saveToFile(IPath destination, Image image, ImageFileFormat imageFormat, IProgressMonitor monitor) throws CoreException {
        IStatus fileModificationStatus = this.createFile(destination);
        if (!fileModificationStatus.isOK()) {
            return;
        }
        try {
            FileOutputStream stream = new FileOutputStream(destination.toOSString());
            this.saveToOutputStream(stream, image, imageFormat, monitor);
            stream.close();
        }
        catch (Exception e) {
            SiriusPlugin.getDefault().error(e.getMessage(), (Throwable)e);
            Status status = new Status(4, "exportToFile", 0, e.getMessage(), null);
            throw new CoreException((IStatus)status);
        }
        this.refreshLocal(destination);
    }

    private IStatus createFile(IPath destination) throws CoreException {
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(destination);
        if (file != null && !file.exists()) {
            File osFile = new File(destination.toOSString());
            if (osFile.exists()) {
                file.refreshLocal(0, null);
            } else {
                ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, null);
                ByteArrayInputStream input = new ByteArrayInputStream(new byte[0]);
                file.create((InputStream)input, false, null);
            }
        }
        if (file != null) {
            return FileModificationValidator.approveFileModification((IFile[])new IFile[]{file});
        }
        return Status.OK_STATUS;
    }

    private void refreshLocal(IPath destination) throws CoreException {
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(destination);
        if (file != null) {
            file.refreshLocal(0, null);
        }
    }

    private void saveToOutputStream(OutputStream stream, Image image, ImageFileFormat imageFormat, IProgressMonitor monitor) {
        monitor.worked(1);
        ImageData imageData = image.getImageData();
        if (imageFormat.equals((Object)ImageFileFormat.GIF) || imageFormat.equals((Object)ImageFileFormat.BMP)) {
            imageData = this.createImageData(image);
        }
        monitor.worked(1);
        ImageLoader imageLoader = new ImageLoader();
        imageLoader.data = new ImageData[]{imageData};
        imageLoader.logicalScreenHeight = image.getBounds().width;
        imageLoader.logicalScreenHeight = image.getBounds().height;
        if (imageFormat.equals((Object)ImageFileFormat.JPG)) {
            imageLoader.compression = 100;
        }
        imageLoader.save(stream, imageFormat.getOrdinal());
        monitor.worked(1);
    }

    private ImageData createImageData(Image image) {
        ImageData imageData = image.getImageData();
        if (imageData.depth <= 8) {
            return imageData;
        }
        ImageData newImageData = this.get8BitPaletteImageData(imageData);
        if (newImageData == null) {
            newImageData = this.getWebSafePalletteImageData(imageData);
        }
        return newImageData;
    }

    private ImageData get8BitPaletteImageData(ImageData imageData) {
        PaletteData palette = imageData.palette;
        RGB[] colours = new RGB[256];
        PaletteData newPaletteData = new PaletteData(colours);
        ImageData newImageData = new ImageData(imageData.width, imageData.height, 8, newPaletteData);
        int lastPixel = -1;
        int newPixel = -1;
        int i = 0;
        while (i < imageData.width) {
            int j = 0;
            while (j < imageData.height) {
                int pixel = imageData.getPixel(i, j);
                if (pixel != lastPixel) {
                    lastPixel = pixel;
                    RGB colour = palette.getRGB(pixel);
                    newPixel = 0;
                    while (newPixel < 256) {
                        if (colours[newPixel] == null) {
                            colours[newPixel] = colour;
                            break;
                        }
                        if (colours[newPixel].equals((Object)colour)) break;
                        ++newPixel;
                    }
                    if (newPixel >= 256) {
                        return null;
                    }
                }
                newImageData.setPixel(i, j, newPixel);
                ++j;
            }
            ++i;
        }
        RGB colour = new RGB(0, 0, 0);
        int k = 0;
        while (k < 256) {
            if (colours[k] == null) {
                colours[k] = colour;
            }
            ++k;
        }
        return newImageData;
    }

    private ImageData getWebSafePalletteImageData(ImageData imageData) {
        PaletteData palette = imageData.palette;
        RGB[] webSafePallette = this.getWebSafePallette();
        PaletteData newPaletteData = new PaletteData(webSafePallette);
        ImageData newImageData = new ImageData(imageData.width, imageData.height, 8, newPaletteData);
        int lastPixel = -1;
        int newPixel = -1;
        int i = 0;
        while (i < imageData.width) {
            int j = 0;
            while (j < imageData.height) {
                int pixel = imageData.getPixel(i, j);
                if (pixel != lastPixel) {
                    lastPixel = pixel;
                    RGB colour = palette.getRGB(pixel);
                    RGB webSafeColour = this.getWebSafeColour(colour);
                    newPixel = 0;
                    while (newPixel < 256) {
                        if (webSafePallette[newPixel].equals((Object)webSafeColour)) break;
                        ++newPixel;
                    }
                    Assert.isTrue((newPixel < 216 ? 1 : 0) != 0);
                }
                newImageData.setPixel(i, j, newPixel);
                ++j;
            }
            ++i;
        }
        return newImageData;
    }

    private RGB[] getWebSafePallette() {
        RGB[] colours = new RGB[256];
        int i = 0;
        int red = 0;
        while (red <= 255) {
            int green = 0;
            while (green <= 255) {
                int blue = 0;
                while (blue <= 255) {
                    RGB colour = new RGB(red, green, blue);
                    colours[i++] = colour;
                    blue += 51;
                }
                green += 51;
            }
            red += 51;
        }
        RGB colour = new RGB(0, 0, 0);
        int k = 0;
        while (k < 256) {
            if (colours[k] == null) {
                colours[k] = colour;
            }
            ++k;
        }
        return colours;
    }

    private RGB getWebSafeColour(RGB colour) {
        int red = Math.round((colour.red + 25) / 51) * 51;
        int green = Math.round((colour.green + 25) / 51) * 51;
        int blue = Math.round((colour.blue + 25) / 51) * 51;
        return new RGB(red, green, blue);
    }
}

