/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.draw2d.ui.figures.BaseSlidableAnchor;
import org.eclipse.gmf.runtime.notation.Anchor;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.IdentityAnchor;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.RelativeBendpoints;
import org.eclipse.gmf.runtime.notation.datatype.RelativeBendpoint;
import org.eclipse.sirius.diagram.ui.business.api.query.EdgeQuery;
import org.eclipse.sirius.diagram.ui.internal.refresh.GMFHelper;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;

public final class GMFNotationUtilities {
    private GMFNotationUtilities() {
    }

    public static Option<Point> setSourceAnchor(Edge edge, PointList newPoints) {
        PrecisionPoint referencePointOfChangedAnchor = null;
        if (edge.getSource() instanceof Node) {
            Rectangle sourceFigure = GMFHelper.getBounds((Node)edge.getSource(), true);
            int newXAnchorLocation = newPoints.getPoint((int)1).x;
            double newXAnchorPercentage = (double)(newXAnchorLocation - sourceFigure.x) / (double)sourceFigure.width;
            if (edge.getSourceAnchor() instanceof IdentityAnchor) {
                IdentityAnchor anchor = (IdentityAnchor)edge.getSourceAnchor();
                PrecisionPoint relativeReferencePoint = BaseSlidableAnchor.parseTerminalString((String)anchor.getId());
                if (relativeReferencePoint.preciseX() != newXAnchorPercentage) {
                    GMFNotationUtilities.setIdentityAnchorId(anchor, newXAnchorPercentage, relativeReferencePoint.preciseY());
                    referencePointOfChangedAnchor = new PrecisionPoint((double)sourceFigure.getLocation().x + (double)sourceFigure.width * newXAnchorPercentage, (double)sourceFigure.getLocation().y + (double)sourceFigure.height * relativeReferencePoint.preciseY());
                }
            } else if (edge.getSourceAnchor() == null) {
                IdentityAnchor anchor = NotationFactory.eINSTANCE.createIdentityAnchor();
                GMFNotationUtilities.setIdentityAnchorId(anchor, newXAnchorPercentage, 0.5);
                edge.setSourceAnchor((Anchor)anchor);
                referencePointOfChangedAnchor = new PrecisionPoint((double)sourceFigure.getLocation().x + (double)sourceFigure.width * newXAnchorPercentage, (double)sourceFigure.getLocation().y + (double)sourceFigure.height * 0.5);
            }
        } else if (edge.getSource() instanceof Edge) {
            throw new UnsupportedOperationException(Messages.GMFNotationUtilities_edgeOnEdgeNotManaged);
        }
        if (referencePointOfChangedAnchor == null) {
            return Options.newNone();
        }
        return Options.newSome(referencePointOfChangedAnchor);
    }

    public static Option<Point> setTargetAnchor(Edge edge, PointList newPoints) {
        PrecisionPoint referencePointOfChangedAnchor = null;
        if (edge.getTarget() instanceof Node) {
            Rectangle targetFigure = GMFHelper.getBounds((Node)edge.getTarget(), true);
            int newXAnchorLocation = newPoints.getPoint((int)2).x;
            double newXAnchorPercentage = (double)(newXAnchorLocation - targetFigure.x) / (double)targetFigure.width;
            if (edge.getTargetAnchor() instanceof IdentityAnchor) {
                IdentityAnchor anchor = (IdentityAnchor)edge.getTargetAnchor();
                PrecisionPoint relativeReferencePoint = BaseSlidableAnchor.parseTerminalString((String)anchor.getId());
                if (relativeReferencePoint.preciseX() != newXAnchorPercentage) {
                    GMFNotationUtilities.setIdentityAnchorId(anchor, newXAnchorPercentage, relativeReferencePoint.preciseY());
                    referencePointOfChangedAnchor = new PrecisionPoint((double)targetFigure.getLocation().x + (double)targetFigure.width * newXAnchorPercentage, (double)targetFigure.getLocation().y + (double)targetFigure.height * relativeReferencePoint.preciseY());
                }
            } else if (edge.getTargetAnchor() == null) {
                IdentityAnchor anchor = NotationFactory.eINSTANCE.createIdentityAnchor();
                GMFNotationUtilities.setIdentityAnchorId(anchor, newXAnchorPercentage, 0.5);
                edge.setTargetAnchor((Anchor)anchor);
                referencePointOfChangedAnchor = new PrecisionPoint((double)targetFigure.getLocation().x + (double)targetFigure.width * newXAnchorPercentage, (double)targetFigure.getLocation().y + (double)targetFigure.height * 0.5);
            }
        } else if (edge.getTarget() instanceof Edge) {
            throw new UnsupportedOperationException(Messages.GMFNotationUtilities_edgeOnEdgeNotManaged);
        }
        if (referencePointOfChangedAnchor == null) {
            return Options.newNone();
        }
        return Options.newSome(referencePointOfChangedAnchor);
    }

    public static void setIdentityAnchorId(IdentityAnchor anchor, double xPercentage, double yPercentage) {
        anchor.setId(GMFNotationUtilities.getTerminalString(xPercentage, yPercentage));
    }

    public static String getTerminalString(double xPercentage, double yPercentage) {
        return "(" + String.valueOf(xPercentage) + "," + String.valueOf(yPercentage) + ")";
    }

    public static void setGMFBendpoints(Edge edge, PointList newPoints, Point sourceRefPoint, Point targetRefPoint) {
        ArrayList newBendpoints = Lists.newArrayList();
        int numOfPoints = newPoints.size();
        int i = 0;
        while (i < numOfPoints) {
            Dimension s = newPoints.getPoint(i).getDifference(sourceRefPoint);
            Dimension t = newPoints.getPoint(i).getDifference(targetRefPoint);
            newBendpoints.add(new RelativeBendpoint(s.width, s.height, t.width, t.height));
            i = (short)(i + 1);
        }
        RelativeBendpoints points = (RelativeBendpoints)edge.getBendpoints();
        points.setPoints((List)newBendpoints);
    }

    public static Option<PrecisionPoint> setSourceAnchor(Edge edge, int deltaX) {
        if (edge.getSource() instanceof Node) {
            Rectangle sourceFigure = GMFHelper.getBounds((Node)edge.getSource(), true);
            if (edge.getSourceAnchor() instanceof IdentityAnchor) {
                IdentityAnchor anchor = (IdentityAnchor)edge.getSourceAnchor();
                PrecisionPoint relativeReferencePoint = BaseSlidableAnchor.parseTerminalString((String)anchor.getId());
                double xCurrentPosition = (double)sourceFigure.x + (double)sourceFigure.width * relativeReferencePoint.preciseX();
                double xNewPosition = xCurrentPosition - (double)deltaX;
                double newXAnchorPercentage = (xNewPosition - (double)sourceFigure.x) / (double)sourceFigure.width;
                GMFNotationUtilities.setIdentityAnchorId(anchor, newXAnchorPercentage, relativeReferencePoint.preciseY());
                return Options.newSome((Object)new PrecisionPoint((double)sourceFigure.getLocation().x + (double)sourceFigure.width * newXAnchorPercentage, (double)sourceFigure.getLocation().y + (double)sourceFigure.height * relativeReferencePoint.preciseY()));
            }
        } else {
            throw new UnsupportedOperationException(Messages.GMFNotationUtilities_edgeOnEdgeNotManaged);
        }
        return Options.newNone();
    }

    public static Option<PrecisionPoint> setTargetAnchor(Edge edge, int deltaX) {
        if (edge.getTarget() instanceof Node) {
            Rectangle targetFigure = GMFHelper.getBounds((Node)edge.getTarget(), true);
            if (edge.getTargetAnchor() instanceof IdentityAnchor) {
                IdentityAnchor anchor = (IdentityAnchor)edge.getTargetAnchor();
                PrecisionPoint relativeReferencePoint = BaseSlidableAnchor.parseTerminalString((String)anchor.getId());
                double xCurrentPosition = (double)targetFigure.x + (double)targetFigure.width * relativeReferencePoint.preciseX();
                double xNewPosition = xCurrentPosition - (double)deltaX;
                double newXAnchorPercentage = (xNewPosition - (double)targetFigure.x) / (double)targetFigure.width;
                GMFNotationUtilities.setIdentityAnchorId(anchor, newXAnchorPercentage, relativeReferencePoint.preciseY());
                return Options.newSome((Object)new PrecisionPoint((double)targetFigure.getLocation().x + (double)targetFigure.width * newXAnchorPercentage, (double)targetFigure.getLocation().y + (double)targetFigure.height * relativeReferencePoint.preciseY()));
            }
        } else {
            throw new UnsupportedOperationException(Messages.GMFNotationUtilities_edgeOnEdgeNotManaged);
        }
        return Options.newNone();
    }

    public static void setBendpoints(Edge referenceEdge, Edge edgeToModify) {
        Object objectSecondRelativeBendpointOfMovedEdge;
        String sourceTerminalString = GMFNotationUtilities.getTerminalString(0.5, 0.5);
        if (edgeToModify.getSourceAnchor() instanceof IdentityAnchor) {
            sourceTerminalString = ((IdentityAnchor)edgeToModify.getSourceAnchor()).getId();
        }
        String targetTerminalString = GMFNotationUtilities.getTerminalString(0.5, 0.5);
        if (edgeToModify.getTargetAnchor() instanceof IdentityAnchor) {
            targetTerminalString = ((IdentityAnchor)edgeToModify.getTargetAnchor()).getId();
        }
        PrecisionPoint sourceAnchorReference = BaseSlidableAnchor.parseTerminalString((String)sourceTerminalString);
        PrecisionPoint targetAnchorReference = BaseSlidableAnchor.parseTerminalString((String)targetTerminalString);
        PrecisionPoint sourceLocation = null;
        PrecisionPoint targetLocation = null;
        Rectangle sourceBounds = null;
        Rectangle targetBounds = null;
        if (edgeToModify.getSource() instanceof Node) {
            sourceBounds = GMFHelper.getBounds((Node)edgeToModify.getSource(), true);
            sourceLocation = new PrecisionPoint((double)sourceBounds.x + (double)sourceBounds.width * sourceAnchorReference.preciseX(), (double)sourceBounds.y + (double)sourceBounds.height * sourceAnchorReference.preciseY());
        } else if (edgeToModify.getSource() instanceof Edge) {
            throw new UnsupportedOperationException(Messages.GMFNotationUtilities_edgeOnEdgeNotManaged);
        }
        if (edgeToModify.getTarget() instanceof Node) {
            targetBounds = GMFHelper.getBounds((Node)edgeToModify.getTarget(), true);
            targetLocation = new PrecisionPoint((double)targetBounds.x + (double)targetBounds.width * targetAnchorReference.preciseX(), (double)targetBounds.y + (double)targetBounds.height * targetAnchorReference.preciseY());
        } else if (edgeToModify.getTarget() instanceof Edge) {
            throw new UnsupportedOperationException(Messages.GMFNotationUtilities_edgeOnEdgeNotManaged);
        }
        if (referenceEdge.getBendpoints() instanceof RelativeBendpoints && (objectSecondRelativeBendpointOfMovedEdge = ((RelativeBendpoints)referenceEdge.getBendpoints()).getPoints().get(1)) instanceof RelativeBendpoint) {
            RelativeBendpoint secondRelativeBendpointOfMovedEdge = (RelativeBendpoint)objectSecondRelativeBendpointOfMovedEdge;
            ArrayList brotherNewBendpoints = Lists.newArrayList();
            brotherNewBendpoints.add(new RelativeBendpoint(0, sourceBounds.y - sourceLocation.y, sourceLocation.x - targetLocation.x, sourceBounds.y - targetLocation.y));
            brotherNewBendpoints.add(new RelativeBendpoint(0, targetLocation.y + secondRelativeBendpointOfMovedEdge.getTargetY() - sourceLocation.y, sourceLocation.x - targetLocation.x, secondRelativeBendpointOfMovedEdge.getTargetY()));
            brotherNewBendpoints.add(new RelativeBendpoint(targetLocation.x - sourceLocation.x, targetLocation.y + secondRelativeBendpointOfMovedEdge.getTargetY() - sourceLocation.y, 0, secondRelativeBendpointOfMovedEdge.getTargetY()));
            brotherNewBendpoints.add(new RelativeBendpoint(targetLocation.x - sourceLocation.x, targetBounds.y + targetBounds.width - sourceLocation.y, 0, targetBounds.y + targetBounds.width - targetLocation.y));
            ((RelativeBendpoints)edgeToModify.getBendpoints()).setPoints((List)brotherNewBendpoints);
        }
    }

    public static void setTargetAnchor(Edge referenceEdge, Edge edgeToModify) {
        if (referenceEdge.getTargetAnchor() instanceof IdentityAnchor && (edgeToModify.getTargetAnchor() instanceof IdentityAnchor || edgeToModify.getTargetAnchor() == null)) {
            IdentityAnchor refAnchor = (IdentityAnchor)referenceEdge.getTargetAnchor();
            if (edgeToModify.getTargetAnchor() == null) {
                edgeToModify.setTargetAnchor((Anchor)NotationFactory.eINSTANCE.createIdentityAnchor());
            }
            IdentityAnchor anchorToModify = (IdentityAnchor)edgeToModify.getTargetAnchor();
            anchorToModify.setId(refAnchor.getId());
        }
    }

    public static void setSourceAnchor(Edge referenceEdge, Edge edgeToModify) {
        if (referenceEdge.getSourceAnchor() instanceof IdentityAnchor && (edgeToModify.getSourceAnchor() instanceof IdentityAnchor || edgeToModify.getSourceAnchor() == null)) {
            IdentityAnchor refAnchor = (IdentityAnchor)referenceEdge.getSourceAnchor();
            if (edgeToModify.getSourceAnchor() == null) {
                edgeToModify.setSourceAnchor((Anchor)NotationFactory.eINSTANCE.createIdentityAnchor());
            }
            IdentityAnchor anchorToModify = (IdentityAnchor)edgeToModify.getSourceAnchor();
            anchorToModify.setId(refAnchor.getId());
        }
    }

    public static void setBrothersAnchorAndBendpointsAccordingToEdge(Edge edge) {
        List<Object> brothers;
        EdgeQuery edgeQuery = new EdgeQuery(edge);
        boolean sourceSide = false;
        if (edgeQuery.isEdgeOnTreeOnSourceSide()) {
            brothers = edgeQuery.getBrothersOnTreeOnSourceSide();
            sourceSide = true;
        } else {
            brothers = edgeQuery.isEdgeOnTreeOnTargetSide() ? edgeQuery.getBrothersOnTreeOnTargetSide() : Lists.newArrayList();
        }
        for (Edge edge2 : brothers) {
            if (sourceSide) {
                GMFNotationUtilities.setSourceAnchor(edge, edge2);
            } else {
                GMFNotationUtilities.setTargetAnchor(edge, edge2);
            }
            GMFNotationUtilities.setBendpoints(edge, edge2);
        }
    }
}

