/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.ui.tools.internal.editor.action;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.sirius.business.api.dialect.command.RefreshRepresentationsCommand;
import org.eclipse.sirius.table.metamodel.table.provider.Messages;
import org.eclipse.sirius.table.ui.tools.internal.editor.AbstractDTableEditor;
import org.eclipse.sirius.table.ui.tools.internal.editor.DTableViewerManager;
import org.eclipse.sirius.ui.business.api.action.RefreshActionListenerRegistry;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class RefreshAction
extends Action
implements IObjectActionDelegate {
    private AbstractDTableEditor tableEditor;

    public RefreshAction(AbstractDTableEditor tableEditor) {
        super(Messages.RefreshAction_label, DTableViewerManager.getImageRegistry().getDescriptor("table/refresh"));
        this.tableEditor = tableEditor;
    }

    public void run() {
        IEditorPart activeEditor;
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (activePage != null && (activeEditor = activePage.getActiveEditor()) instanceof AbstractDTableEditor) {
            this.tableEditor = (AbstractDTableEditor)activeEditor;
            IRunnableWithProgress op = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    TransactionalEditingDomain domain = RefreshAction.this.tableEditor.getEditingDomain();
                    domain.getCommandStack().execute((Command)new RefreshRepresentationsCommand(domain, monitor, new DRepresentation[]{RefreshAction.this.tableEditor.getTableModel()}));
                }
            };
            Shell activeShell = this.tableEditor.getSite().getShell();
            ProgressMonitorDialog monitorDialog = new ProgressMonitorDialog(activeShell);
            try {
                try {
                    this.tableEditor.enablePropertiesUpdate(false);
                    RefreshActionListenerRegistry.INSTANCE.notifyRepresentationIsAboutToBeRefreshed((DRepresentation)this.tableEditor.getTableModel());
                    monitorDialog.run(true, false, op);
                }
                catch (InvocationTargetException e) {
                    MessageDialog.openError((Shell)activeShell, (String)Messages.Action_error, (String)e.getTargetException().getMessage());
                    SiriusPlugin.getDefault().error(Messages.RefreshAction_errorDuringRefresh, (Throwable)e);
                    this.tableEditor.enablePropertiesUpdate(true);
                }
                catch (InterruptedException e) {
                    MessageDialog.openInformation((Shell)activeShell, (String)Messages.Action_cancelled, (String)e.getMessage());
                    this.tableEditor.enablePropertiesUpdate(true);
                }
            }
            finally {
                this.tableEditor.enablePropertiesUpdate(true);
            }
        }
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }
}

