/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.actions.analysis;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.action.Action;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionStatus;
import org.eclipse.sirius.business.api.session.danalysis.DAnalysisSession;
import org.eclipse.sirius.common.ui.tools.api.util.SWTUtil;
import org.eclipse.sirius.ui.business.api.dialect.DialectEditor;
import org.eclipse.sirius.ui.business.api.session.IEditingSession;
import org.eclipse.sirius.ui.business.api.session.SessionUIManager;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.provider.Messages;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class RemoveRepresentationResourceAction
extends Action {
    private final HashSet<Resource> diagramResources;
    private final Session session;

    public RemoveRepresentationResourceAction(Collection<Resource> diagramResources, Session session) {
        super(Messages.RemoveRepresentationResourceAction_name, AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.sirius.ui", (String)"/icons/full/others/remove.gif"));
        this.diagramResources = Sets.newHashSet(diagramResources);
        this.session = session;
    }

    public void run() {
        IEditingSession ui = SessionUIManager.INSTANCE.getUISession(this.session);
        int choice = 0;
        if (this.session.getStatus() == SessionStatus.DIRTY) {
            choice = SWTUtil.showSaveDialog((Object)this.session, (String)Messages.RemoveRepresentationResourceAction_saveDialogTitle, (boolean)true);
        }
        if (ui != null && choice != 2) {
            if (choice == 0) {
                this.session.save((IProgressMonitor)new NullProgressMonitor());
            }
            HashSet<DialectEditor> editorsToClose = new HashSet<DialectEditor>();
            for (DRepresentation representation : DialectManager.INSTANCE.getAllRepresentations(this.session)) {
                DialectEditor editor;
                if (!this.diagramResources.contains(representation.eResource()) || (editor = ui.getEditor(representation)) == null) continue;
                editorsToClose.add(editor);
            }
            ui.closeEditors(choice == 0, editorsToClose);
        }
        if (choice != 2 && this.session instanceof DAnalysisSession) {
            TransactionalEditingDomain transDomain = this.session.getTransactionalEditingDomain();
            RemoveRepresentationResourcesCommand cmd = new RemoveRepresentationResourcesCommand((DAnalysisSession)this.session, this.diagramResources);
            transDomain.getCommandStack().execute((Command)cmd);
        }
    }

    public boolean isEnabled() {
        boolean referencedAnalysisDeletionEnabled;
        boolean mainResDeletion = this.diagramResources.contains(this.session.getSessionResource());
        boolean bl = referencedAnalysisDeletionEnabled = !this.diagramResources.isEmpty() && this.session instanceof DAnalysisSession && ((DAnalysisSession)this.session).getAllSessionResources().size() > 1;
        return super.isEnabled() && !mainResDeletion && referencedAnalysisDeletionEnabled;
    }

    private class RemoveRepresentationResourcesCommand
    extends RecordingCommand {
        private Collection<Resource> analysisResources;
        private final DAnalysisSession session;

        public RemoveRepresentationResourcesCommand(DAnalysisSession session, Collection<Resource> analysisResourcesToRemove) {
            super(session.getTransactionalEditingDomain());
            this.analysisResources = Sets.newHashSet();
            this.session = session;
            if (analysisResourcesToRemove != null && !analysisResourcesToRemove.isEmpty()) {
                this.analysisResources.addAll(analysisResourcesToRemove);
            }
        }

        protected void doExecute() {
            for (Resource res : this.analysisResources) {
                this.session.removeAnalysis(res);
            }
        }
    }
}

