/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.api.dialect.command;

import com.google.common.collect.Lists;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.Messages;

public class RefreshRepresentationsCommand
extends RecordingCommand {
    private Collection<DRepresentation> representations;
    private IProgressMonitor monitor;
    private boolean fullRefresh;

    public RefreshRepresentationsCommand(TransactionalEditingDomain domain, boolean fullRefresh, IProgressMonitor monitor, Collection<DRepresentation> representationsToRefresh) {
        super(domain, Messages.RefreshRepresentationsCommand_label);
        this.fullRefresh = fullRefresh;
        this.monitor = monitor;
        this.representations = representationsToRefresh;
    }

    public RefreshRepresentationsCommand(TransactionalEditingDomain domain, IProgressMonitor monitor, Collection<DRepresentation> representationsToRefresh) {
        this(domain, false, monitor, representationsToRefresh);
    }

    public RefreshRepresentationsCommand(TransactionalEditingDomain domain, IProgressMonitor monitor, DRepresentation ... representationsToRefresh) {
        this(domain, false, monitor, Lists.newArrayList((Object[])representationsToRefresh));
    }

    public RefreshRepresentationsCommand(TransactionalEditingDomain domain, boolean fullRefresh, IProgressMonitor monitor, DRepresentation ... representationsToRefresh) {
        this(domain, fullRefresh, monitor, Lists.newArrayList((Object[])representationsToRefresh));
    }

    protected void doExecute() {
        if (this.representations.size() == 0) {
            return;
        }
        if (this.monitor == null) {
            this.monitor = new NullProgressMonitor();
        }
        for (DRepresentation representation : this.representations) {
            if (!this.safeRefresh(representation)) continue;
            DialectManager.INSTANCE.refresh(representation, this.fullRefresh, this.monitor);
        }
    }

    private boolean safeRefresh(DRepresentation representation) {
        boolean safeRefresh;
        boolean bl = safeRefresh = representation != null;
        if (representation instanceof DSemanticDecorator) {
            safeRefresh = ((DSemanticDecorator)((Object)representation)).getTarget() != null;
        }
        return safeRefresh;
    }

    public boolean canExecute() {
        return this.representations.size() != 0;
    }
}

