/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.api.session;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionCreationOperation;
import org.eclipse.sirius.business.api.session.factory.SessionFactory;
import org.eclipse.sirius.viewpoint.Messages;

public class DefaultLocalSessionCreationOperation
implements SessionCreationOperation {
    protected URI sessionResourceURI;
    protected Session session;
    private IProgressMonitor monitor;

    public DefaultLocalSessionCreationOperation(URI sessionResourceURI, IProgressMonitor monitor) {
        this.sessionResourceURI = sessionResourceURI;
        this.monitor = monitor;
    }

    @Override
    public void execute() throws CoreException {
        if (this.monitor == null) {
            this.monitor = new NullProgressMonitor();
        }
        try {
            this.monitor.beginTask(Messages.DefaultLocalSessionCreationOperation_createResoureMsg, 3);
            this.monitor.subTask(Messages.DefaultLocalSessionCreationOperation_createSessionMsg);
            this.session = SessionFactory.INSTANCE.createSession(this.sessionResourceURI, (IProgressMonitor)new SubProgressMonitor(this.monitor, 1));
            this.monitor.subTask(Messages.DefaultLocalSessionCreationOperation_sessionOpenMsg);
            this.session.open((IProgressMonitor)new SubProgressMonitor(this.monitor, 1));
            this.monitor.subTask(Messages.DAnalysisSessionImpl_saveMsg);
            this.session.save((IProgressMonitor)new SubProgressMonitor(this.monitor, 1));
        }
        finally {
            this.monitor.done();
        }
    }

    @Override
    public Session getCreatedSession() {
        return this.session;
    }
}

