/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.design.service;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecoretools.design.service.DesignServices;
import org.eclipse.emf.ecoretools.design.service.EGenericsServices;

public class EAttributeServices {
    private static final String DERIVED_ATTRIBUTE_PREFIX = "/";
    private static final String TYPE_SEPARATOR = ":";
    private static final String DEFAULT_VALUE_SEPARATOR = "=";

    public String render(EAttribute attr) {
        StringBuilder sb = new StringBuilder();
        this.renderName(attr, sb);
        this.renderType(attr, sb);
        this.renderDefaultValue(attr, sb);
        return sb.toString();
    }

    public EAttribute performEdit(EAttribute attr, String editString) {
        if ("0".equals(editString.trim())) {
            attr.setLowerBound(0);
        } else if ("1".equals(editString.trim())) {
            attr.setLowerBound(1);
        } else if ("11".equals(editString.trim())) {
            attr.setLowerBound(1);
            attr.setUpperBound(1);
        } else if ("*".equals(editString.trim())) {
            attr.setUpperBound(-1);
        } else if ("-1".equals(editString.trim())) {
            attr.setUpperBound(-1);
        } else {
            String namePart;
            int typeStart = editString.indexOf(TYPE_SEPARATOR);
            boolean setType = typeStart != -1;
            int defaultStart = editString.indexOf(DEFAULT_VALUE_SEPARATOR);
            boolean setDefault = defaultStart != -1;
            int nameEnd = editString.length();
            if (setType) {
                nameEnd = Math.min(nameEnd, typeStart);
            }
            if (setDefault) {
                nameEnd = Math.min(nameEnd, defaultStart);
            }
            boolean setName = (namePart = editString.substring(0, nameEnd).trim()).length() > 0;
            String typePart = null;
            if (setType) {
                int typeEnd = setDefault ? defaultStart : editString.length();
                typePart = editString.substring(typeStart + TYPE_SEPARATOR.length(), typeEnd).trim();
            }
            String defaultPart = null;
            if (setDefault) {
                defaultPart = editString.substring(defaultStart + DEFAULT_VALUE_SEPARATOR.length()).trim();
            }
            if (setName) {
                if (namePart.startsWith(DERIVED_ATTRIBUTE_PREFIX)) {
                    attr.setDerived(true);
                    attr.setTransient(true);
                    attr.setVolatile(true);
                    attr.setChangeable(false);
                    namePart = namePart.substring(DERIVED_ATTRIBUTE_PREFIX.length());
                } else {
                    attr.setDerived(false);
                }
                attr.setName(namePart);
            }
            if (setType) {
                Object value = EGenericsServices.findGenericType((ENamedElement)attr, typePart);
                if (value == null) {
                    value = new DesignServices().findTypeByName((EObject)attr, typePart);
                }
                EGenericsServices.setETypeWithGenerics((ETypedElement)attr, value);
            }
            if (setDefault && defaultPart.length() > 0) {
                attr.setDefaultValueLiteral(defaultPart);
            }
        }
        return attr;
    }

    private void renderName(EAttribute attr, StringBuilder sb) {
        if (attr.getName() != null) {
            if (attr.isDerived()) {
                sb.append(DERIVED_ATTRIBUTE_PREFIX);
            }
            sb.append(attr.getName());
        }
    }

    private void renderType(EAttribute attr, StringBuilder sb) {
        String typeName = EGenericsServices.getETypeLabel((ETypedElement)attr);
        if (typeName != null) {
            if (attr.getName() != null) {
                sb.append(" ");
            }
            sb.append(TYPE_SEPARATOR).append(" ").append(typeName);
        }
    }

    private void renderDefaultValue(EAttribute attr, StringBuilder sb) {
        if (attr.getDefaultValueLiteral() != null) {
            if (attr.getDefaultValueLiteral().length() > 0) {
                sb.append(" ").append(DEFAULT_VALUE_SEPARATOR).append(" ").append(attr.getDefaultValueLiteral());
            }
        } else if (attr.getDefaultValue() != null) {
            EDataType dataType = attr.getEAttributeType();
            if (dataType instanceof EEnum) {
                sb.append(" ").append(DEFAULT_VALUE_SEPARATOR).append(" ").append(attr.getDefaultValue());
            } else {
                Object factory = dataType.getEPackage() != null ? dataType.getEPackage().getEFactoryInstance() : EcoreFactory.eINSTANCE;
                String serializable = factory.convertToString(dataType, attr.getDefaultValue());
                if (!"0".equals(serializable)) {
                    sb.append(" ").append(DEFAULT_VALUE_SEPARATOR).append(" ");
                    sb.append(serializable);
                }
            }
        }
    }
}

