/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.runtime.impl;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.acceleo.query.ast.Call;
import org.eclipse.acceleo.query.parser.CombineIterator;
import org.eclipse.acceleo.query.runtime.AcceleoQueryValidationException;
import org.eclipse.acceleo.query.runtime.ICompletionProposal;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IValidationResult;
import org.eclipse.acceleo.query.runtime.impl.AbstractService;
import org.eclipse.acceleo.query.runtime.impl.ValidationServices;
import org.eclipse.acceleo.query.runtime.impl.completion.EOperationServiceCompletionProposal;
import org.eclipse.acceleo.query.validation.type.AbstractType;
import org.eclipse.acceleo.query.validation.type.ClassType;
import org.eclipse.acceleo.query.validation.type.EClassifierLiteralType;
import org.eclipse.acceleo.query.validation.type.EClassifierType;
import org.eclipse.acceleo.query.validation.type.IJavaType;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.acceleo.query.validation.type.SequenceType;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EcorePackage;

public class EOperationService
extends AbstractService {
    public static final int PRIORITY = 100;
    protected static final String COULDN_T_INVOKE_EOPERATION = "Couldn't invoke the %s EOperation (%s)";
    private final EOperation eOperation;

    public EOperationService(EOperation eOperation) {
        this.eOperation = eOperation;
    }

    @Override
    public String getName() {
        return this.eOperation.getName();
    }

    @Override
    public List<IType> getParameterTypes(IReadOnlyQueryEnvironment queryEnvironment) {
        ArrayList<IType> result = new ArrayList<IType>();
        result.add(new EClassifierType(queryEnvironment, (EClassifier)this.getEOperation().getEContainingClass()));
        for (EParameter parameter : this.getEOperation().getEParameters()) {
            EClassifierType rawType = new EClassifierType(queryEnvironment, parameter.getEType());
            if (parameter.isMany()) {
                result.add(new SequenceType(queryEnvironment, rawType));
                continue;
            }
            result.add(rawType);
        }
        return result;
    }

    @Override
    public int getNumberOfParameters() {
        return this.eOperation.getEParameters().size() + 1;
    }

    @Override
    protected Object internalInvoke(Object[] arguments) throws Exception {
        Object result;
        Object[] localArguments = Arrays.copyOfRange(arguments, 1, arguments.length);
        Object receiver = arguments[0];
        if (!this.eOperation.getEContainingClass().isSuperTypeOf(((EObject)receiver).eClass())) {
            result = this.eOperationJavaInvoke(this.eOperation.getName(), receiver, localArguments);
        } else if (this.hasEInvoke(receiver)) {
            BasicEList eArguments = new BasicEList(arguments.length);
            int i = 1;
            while (i < arguments.length) {
                eArguments.add(arguments[i]);
                ++i;
            }
            result = ((EObject)receiver).eInvoke(this.eOperation, (EList)eArguments);
        } else {
            result = this.eOperationJavaInvoke(this.eOperation.getName(), receiver, localArguments);
        }
        return result;
    }

    private Object eOperationJavaInvoke(String operationName, Object receiver, Object[] arguments) throws Exception {
        Class[] argumentClasses = new Class[arguments.length];
        int i = 0;
        while (i < arguments.length) {
            argumentClasses[i] = arguments[i] != null ? arguments[i].getClass() : null;
            ++i;
        }
        Method method = receiver.getClass().getMethod(operationName, argumentClasses);
        Object result = method.invoke(receiver, arguments);
        return result;
    }

    private boolean hasEInvoke(Object object) {
        Method method = null;
        try {
            method = object.getClass().getDeclaredMethod("eInvoke", Integer.TYPE, EList.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {}
        return method != null;
    }

    @Override
    public int getPriority() {
        return 100;
    }

    @Override
    public Set<IType> getType(Call call, ValidationServices services, IValidationResult validationResult, IReadOnlyQueryEnvironment queryEnvironment, List<IType> argTypes) {
        LinkedHashSet<IType> result = new LinkedHashSet<IType>();
        EClassifierType eClassifierType = new EClassifierType(queryEnvironment, this.eOperation.getEType());
        if (this.eOperation.isMany()) {
            result.add(new SequenceType(queryEnvironment, eClassifierType));
        } else {
            result.add(eClassifierType);
        }
        return result;
    }

    @Override
    public boolean matches(IReadOnlyQueryEnvironment queryEnvironment, IType[] argumentTypes) {
        ArrayList eClassifierTypes = new ArrayList(argumentTypes.length);
        boolean canMatch = true;
        int i = 0;
        while (i < argumentTypes.length) {
            Set<Object> eClassifiers;
            IType iType = argumentTypes[i];
            if (iType instanceof EClassifierLiteralType) {
                eClassifiers = new LinkedHashSet<Object>();
                eClassifiers.add(EcorePackage.eINSTANCE.getEClass());
            } else if (iType instanceof EClassifierType) {
                eClassifiers = new LinkedHashSet();
                eClassifiers.add(((EClassifierType)iType).getType());
            } else if (iType instanceof IJavaType) {
                if (iType.getType() != null) {
                    eClassifiers = queryEnvironment.getEPackageProvider().getEClassifiers(((IJavaType)iType).getType());
                    if (eClassifiers == null) {
                        canMatch = false;
                        break;
                    }
                } else {
                    eClassifiers = new LinkedHashSet();
                    eClassifiers.add(null);
                }
            } else {
                throw new AcceleoQueryValidationException(iType.getClass().getCanonicalName());
            }
            LinkedHashSet<AbstractType> types = new LinkedHashSet<AbstractType>();
            for (EClassifier eClassifier : eClassifiers) {
                if (eClassifier != null) {
                    types.add(new EClassifierType(queryEnvironment, eClassifier));
                    continue;
                }
                types.add(new ClassType(queryEnvironment, null));
            }
            eClassifierTypes.add(types);
            ++i;
        }
        if (canMatch) {
            CombineIterator it = new CombineIterator(eClassifierTypes);
            boolean matched = false;
            while (it.hasNext()) {
                Object parameterTypes = it.next();
                if (!super.matches(queryEnvironment, parameterTypes.toArray(new IType[parameterTypes.size()]))) continue;
                matched = true;
                break;
            }
            canMatch = matched;
        }
        return canMatch;
    }

    public EOperation getEOperation() {
        return this.eOperation;
    }

    @Override
    public String getShortSignature() {
        List<IType> parameterTypes = this.getParameterTypes(null);
        Object[] argumentTypes = parameterTypes.toArray(new IType[parameterTypes.size()]);
        return this.serviceShortSignature(argumentTypes);
    }

    @Override
    public String getLongSignature() {
        String ePkgNsURI;
        String eCLassName;
        EClass eContainingClass = this.getEOperation().getEContainingClass();
        if (eContainingClass != null) {
            eCLassName = eContainingClass.getName();
            EPackage ePackage = eContainingClass.getEPackage();
            ePkgNsURI = ePackage != null ? ePackage.getNsURI() : null;
        } else {
            ePkgNsURI = null;
            eCLassName = null;
        }
        return String.valueOf(ePkgNsURI) + " " + eCLassName + " " + this.getShortSignature();
    }

    public boolean equals(Object obj) {
        return obj instanceof EOperationService && ((EOperationService)obj).getEOperation().equals(this.getEOperation());
    }

    public int hashCode() {
        return this.getEOperation().hashCode();
    }

    @Override
    public List<ICompletionProposal> getProposals(IReadOnlyQueryEnvironment queryEnvironment, Set<IType> receiverTypes) {
        ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
        result.add(new EOperationServiceCompletionProposal(this.getEOperation()));
        return result;
    }
}

