/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.operation;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.Size;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.business.internal.query.DNodeContainerExperimentalQuery;
import org.eclipse.sirius.diagram.ui.business.api.view.SiriusGMFHelper;
import org.eclipse.sirius.diagram.ui.business.internal.operation.AbstractModelChangeOperation;
import org.eclipse.sirius.diagram.ui.internal.operation.ComparisonHelper;
import org.eclipse.sirius.diagram.ui.internal.refresh.GMFHelper;
import org.eclipse.sirius.diagram.ui.part.SiriusVisualIDRegistry;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.sirius.viewpoint.description.RepresentationElementMapping;

public class RegionContainerUpdateLayoutOperation
extends AbstractModelChangeOperation<Void> {
    private final Node regionContainer;

    public RegionContainerUpdateLayoutOperation(Node regionContainer) {
        super(Messages.RegionContainerUpdateLayoutOperation_name);
        this.regionContainer = this.extractRealRegionContainer(regionContainer);
    }

    private Node extractRealRegionContainer(Node node) {
        int visualID;
        if (node != null && node.eContainer() instanceof Node && (7001 == (visualID = SiriusVisualIDRegistry.getVisualID((View)node)) || 7002 == visualID)) {
            return (Node)node.eContainer();
        }
        return node;
    }

    private List<Node> getRegionsToLayout() {
        ArrayList regionsToLayout = Lists.newArrayList();
        if (this.regionContainer != null) {
            Node labelNode = SiriusGMFHelper.getLabelNode((View)this.regionContainer);
            ArrayList nodes = Lists.newArrayList((Iterable)Iterables.filter((Iterable)this.regionContainer.getChildren(), Node.class));
            if (labelNode != null && nodes.size() == 2) {
                nodes.remove(labelNode);
                Node compartment = (Node)nodes.iterator().next();
                Iterables.addAll((Collection)regionsToLayout, (Iterable)Iterables.filter((Iterable)compartment.getChildren(), Node.class));
            }
        }
        return regionsToLayout;
    }

    @Override
    public Void execute() {
        EObject element;
        List<Node> regionsToLayout = this.getRegionsToLayout();
        if (!regionsToLayout.isEmpty() && (element = this.regionContainer.getElement()) instanceof DNodeContainer) {
            DNodeContainer dnc = (DNodeContainer)element;
            RegionContainerUpdateLayoutOperation.sortRegions(dnc, regionsToLayout);
            DNodeContainerExperimentalQuery query = new DNodeContainerExperimentalQuery(dnc);
            if (query.isVerticalStackContainer()) {
                this.updateRegionsLayoutContraints(regionsToLayout, true);
            } else if (query.isHorizontaltackContainer()) {
                this.updateRegionsLayoutContraints(regionsToLayout, false);
            }
        }
        return null;
    }

    private void updateRegionsLayoutContraints(List<Node> regionsToLayout, boolean vertical) {
        HashMap regionBounds = Maps.newHashMap();
        int commonWidth = -1;
        int commonHeight = -1;
        for (Node node : regionsToLayout) {
            Rectangle bounds = GMFHelper.getBounds(node, true, true);
            commonWidth = Math.max(commonWidth, bounds.width);
            commonHeight = Math.max(commonHeight, bounds.height);
            regionBounds.put(node, bounds);
        }
        int y = 0;
        int x = 0;
        for (Node node : regionsToLayout) {
            Rectangle bounds = (Rectangle)regionBounds.get(node);
            LayoutConstraint layoutConstraint = node.getLayoutConstraint();
            if (layoutConstraint instanceof Location) {
                Location loc = (Location)layoutConstraint;
                if (loc.getX() != x) {
                    loc.setX(x);
                }
                if (loc.getY() != y) {
                    loc.setY(y);
                }
            }
            if (vertical) {
                y += bounds.height;
            } else {
                x += bounds.width;
            }
            if (!(layoutConstraint instanceof Size)) continue;
            Size size = (Size)layoutConstraint;
            if (vertical && size.getWidth() != -1 && size.getWidth() != commonWidth) {
                size.setWidth(commonWidth);
            }
            if (vertical || size.getHeight() == -1 || size.getHeight() == commonHeight) continue;
            size.setHeight(commonHeight);
        }
        LayoutConstraint layoutConstraint = this.regionContainer.getLayoutConstraint();
        if (layoutConstraint instanceof Size) {
            Size size = (Size)layoutConstraint;
            if (vertical) {
                if (size.getHeight() != -1) {
                    size.setHeight(-1);
                }
                if (size.getWidth() != -1 && size.getWidth() < commonWidth) {
                    size.setWidth(-1);
                }
            } else {
                if (size.getWidth() != -1) {
                    size.setWidth(-1);
                }
                if (size.getHeight() != -1 && size.getHeight() < commonHeight) {
                    size.setHeight(-1);
                }
            }
        }
    }

    public static void sortRegions(DNodeContainer dNodeContainer, List<? extends View> modelChildren) {
        new RegionComparisonHelper(dNodeContainer).sort(modelChildren);
    }

    private static class RegionComparisonHelper
    extends ComparisonHelper {
        private DNodeContainer self;

        public RegionComparisonHelper(DNodeContainer self) {
            this.self = self;
        }

        @Override
        protected List<? extends DRepresentationElement> getDElementsToSort() {
            return this.self.getOwnedDiagramElements();
        }

        @Override
        protected List<? extends RepresentationElementMapping> getMappingsToSort() {
            return this.self.getActualMapping().getAllContainerMappings();
        }
    }
}

