/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.api.editor;

import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.common.ui.tools.api.util.EclipseUIUtil;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.ui.business.internal.command.CreateAndStoreGMFDiagramCommand;
import org.eclipse.sirius.diagram.ui.business.internal.dialect.DiagramDialectArrangeOperation;
import org.eclipse.sirius.diagram.ui.tools.internal.editor.DDiagramEditorImpl;
import org.eclipse.sirius.ui.business.api.editor.SpecificEditor;
import org.eclipse.sirius.ui.business.api.editor.SpecificEditorInputTranformer;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;

public abstract class AbstractSpecificDDiagramEditor
extends DDiagramEditorImpl
implements SpecificEditor {
    private SpecificEditorInputTranformer util = new SpecificEditorInputTranformer(){

        protected URI getNewEditorInputURI(DRepresentation representation) {
            Diagram gmfDiagram = this.createGMFDiagram((DDiagram)representation);
            return EcoreUtil.getURI((EObject)gmfDiagram);
        }

        private Diagram createGMFDiagram(final DDiagram diagram) {
            TransactionalEditingDomain domain = this.session.getTransactionalEditingDomain();
            domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                protected void doExecute() {
                    DialectManager.INSTANCE.refresh((DRepresentation)diagram, (IProgressMonitor)new NullProgressMonitor());
                }
            });
            domain.getCommandStack().execute((Command)new CreateAndStoreGMFDiagramCommand(this.session, (DSemanticDiagram)diagram));
            EclipseUIUtil.displayAsyncExec((Runnable)new Runnable(){

                @Override
                public void run() {
                    IEditorPart activeEditor = EclipseUIUtil.getActiveEditor();
                    if (activeEditor != null) {
                        new DiagramDialectArrangeOperation().arrange(activeEditor, diagram);
                    }
                }
            });
            Collection gmfDiags = this.session.getServices().getCustomData("GMF_DIAGRAMS", (EObject)diagram);
            return (Diagram)gmfDiags.iterator().next();
        }
    };

    @Override
    public void dispose() {
        super.dispose();
        this.util.cleanEnvironment();
    }

    @Override
    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.util.init(this.getViewpointURI(), this.getDiagramDescriptionName());
        super.init(site, this.util.transformInput(input, this.getSelection((IWorkbenchPartSite)site), this.isSessionStoredInWorkspace()));
    }

    @Override
    public void setInput(IEditorInput input) {
        super.setInput(this.util.transformInput(input, this.getSelection(this.getSite()), this.isSessionStoredInWorkspace()));
    }

    private ISelection getSelection(IWorkbenchPartSite site) {
        return site.getWorkbenchWindow().getSelectionService().getSelection();
    }
}

