/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.api.layout;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.notation.Anchor;
import org.eclipse.gmf.runtime.notation.Bendpoints;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.IdentityAnchor;
import org.eclipse.gmf.runtime.notation.JumpLinkStatus;
import org.eclipse.gmf.runtime.notation.JumpLinkType;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.RelativeBendpoints;
import org.eclipse.gmf.runtime.notation.Routing;
import org.eclipse.gmf.runtime.notation.RoutingStyle;
import org.eclipse.gmf.runtime.notation.Smoothness;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.runtime.notation.datatype.RelativeBendpoint;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.DNodeList;
import org.eclipse.sirius.diagram.DNodeListElement;
import org.eclipse.sirius.diagram.DiagramPlugin;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.business.api.query.DDiagramElementQuery;
import org.eclipse.sirius.diagram.layoutdata.AbstractLayoutData;
import org.eclipse.sirius.diagram.layoutdata.EdgeLayoutData;
import org.eclipse.sirius.diagram.layoutdata.LayoutdataFactory;
import org.eclipse.sirius.diagram.layoutdata.LayoutdataPackage;
import org.eclipse.sirius.diagram.layoutdata.NodeLayoutData;
import org.eclipse.sirius.diagram.ui.business.api.query.NodeQuery;
import org.eclipse.sirius.diagram.ui.business.api.view.SiriusGMFHelper;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractDiagramBorderNodeEditPart;
import org.eclipse.sirius.diagram.ui.internal.operation.CenterEdgeEndModelChangeOperation;
import org.eclipse.sirius.diagram.ui.internal.refresh.GMFHelper;
import org.eclipse.sirius.diagram.ui.internal.refresh.borderednode.CanonicalDBorderItemLocator;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.api.graphical.edit.styles.IBorderItemOffsets;
import org.eclipse.sirius.diagram.ui.tools.api.layout.LayoutDataHelper;
import org.eclipse.sirius.diagram.ui.tools.api.layout.LayoutDataKey;
import org.eclipse.sirius.diagram.ui.tools.api.layout.SiriusLayoutDataManager;
import org.eclipse.sirius.ext.draw2d.figure.FigureUtilities;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;

public abstract class AbstractSiriusLayoutDataManager
implements SiriusLayoutDataManager {
    private static final Class<?>[] CLASS_EXCEPTIONS = new Class[]{DNodeListElement.class};

    @Override
    public void storeLayoutData(IGraphicalEditPart rootEditPart) {
        HashSet discoveredKeys = Sets.newHashSet();
        EObject semanticElement = rootEditPart.resolveSemanticElement();
        View toStoreView = (View)rootEditPart.getModel();
        if (toStoreView instanceof Edge && semanticElement instanceof DEdge) {
            this.addEdgeLayoutData(null, (DEdge)semanticElement, rootEditPart.getRoot().getViewer());
        } else if (toStoreView instanceof Diagram && semanticElement instanceof DDiagram) {
            this.addChildLayout((DDiagram)semanticElement, rootEditPart, discoveredKeys);
        } else if (toStoreView instanceof Node && semanticElement instanceof DDiagramElement && semanticElement instanceof DSemanticDecorator) {
            this.addChildLayout(null, (DSemanticDecorator)semanticElement, (Node)toStoreView, rootEditPart, discoveredKeys);
        }
        discoveredKeys.clear();
    }

    @Override
    public void applyLayout(IGraphicalEditPart rootEditPart) {
        EObject semanticElement = rootEditPart.resolveSemanticElement();
        View toStoreView = (View)rootEditPart.getModel();
        if (!(toStoreView instanceof Edge)) {
            if (toStoreView instanceof Diagram && semanticElement instanceof DDiagram) {
                this.applyLayout((DDiagram)semanticElement, (Diagram)toStoreView, rootEditPart.getRoot().getViewer());
                this.centerEdgesEnds(toStoreView);
            } else if (toStoreView instanceof Node) {
                if (semanticElement instanceof DDiagramElement && semanticElement instanceof DSemanticDecorator) {
                    this.applyLayout((DSemanticDecorator)semanticElement, (Node)toStoreView, rootEditPart.getRoot().getViewer(), null);
                }
                this.centerEdgesEnds(toStoreView);
            }
        }
    }

    private void centerEdgesEnds(View view) {
        HashSet edges = new HashSet();
        if (view instanceof Diagram) {
            edges.addAll(((Diagram)view).getEdges());
        } else {
            ViewUtil.getAllRelatedEdgesForView((View)view, edges);
        }
        for (Edge edge : edges) {
            CenterEdgeEndModelChangeOperation centerEdgeEndModelChangeOperation = new CenterEdgeEndModelChangeOperation(edge, false);
            centerEdgeEndModelChangeOperation.execute();
        }
    }

    private void applyLayout(DDiagram diagram, Diagram toStoreView, EditPartViewer editPartViewer) {
        for (AbstractDNode node : Iterables.filter((Iterable)diagram.getOwnedDiagramElements(), AbstractDNode.class)) {
            Node gmfNode = SiriusGMFHelper.getGmfNode((DDiagramElement)node);
            if (gmfNode == null) continue;
            this.applyLayout((DSemanticDecorator)node, gmfNode, editPartViewer, null);
        }
    }

    private void applyLayoutToOutgoingEdge(EdgeTarget sourceNode, EditPartViewer editPartViewer) {
        for (DEdge edge : sourceNode.getOutgoingEdges()) {
            Edge gmfEdge = SiriusGMFHelper.getGmfEdge((DDiagramElement)edge);
            if (gmfEdge == null) continue;
            this.applyLayout(edge, gmfEdge, editPartViewer);
        }
    }

    private void applyLayout(DEdge edge, Edge gmfEdge, EditPartViewer editPartViewer) {
        EdgeLayoutData layoutData = (EdgeLayoutData)this.getLayoutData(this.createKey((DSemanticDecorator)edge));
        if (layoutData != null) {
            RoutingStyle routingStyle;
            Bendpoints bendpoints = this.convertPointsToGMFBendpoint(layoutData);
            gmfEdge.setBendpoints(bendpoints);
            if (layoutData.getSourceTerminal() != null) {
                if (gmfEdge.getSourceAnchor() == null) {
                    gmfEdge.setSourceAnchor((Anchor)NotationFactory.eINSTANCE.createIdentityAnchor());
                }
                if (gmfEdge.getSourceAnchor() instanceof IdentityAnchor) {
                    ((IdentityAnchor)gmfEdge.getSourceAnchor()).setId(layoutData.getSourceTerminal());
                }
            } else if (gmfEdge.getSourceAnchor() instanceof IdentityAnchor) {
                gmfEdge.setSourceAnchor(null);
            }
            if (layoutData.getTargetTerminal() != null) {
                if (gmfEdge.getTargetAnchor() == null) {
                    gmfEdge.setTargetAnchor((Anchor)NotationFactory.eINSTANCE.createIdentityAnchor());
                }
                if (gmfEdge.getTargetAnchor() instanceof IdentityAnchor) {
                    ((IdentityAnchor)gmfEdge.getTargetAnchor()).setId(layoutData.getTargetTerminal());
                }
            } else if (gmfEdge.getTargetAnchor() instanceof IdentityAnchor) {
                gmfEdge.setTargetAnchor(null);
            }
            if ((routingStyle = (RoutingStyle)gmfEdge.getStyle(NotationPackage.eINSTANCE.getRoutingStyle())) != null) {
                routingStyle.setRouting(Routing.get((int)layoutData.getRouting()));
                routingStyle.setJumpLinkStatus(JumpLinkStatus.get((int)layoutData.getJumpLinkStatus()));
                routingStyle.setJumpLinkType(JumpLinkType.get((int)layoutData.getJumpLinkType()));
                routingStyle.setJumpLinksReverse(layoutData.isReverseJumpLink());
                routingStyle.setSmoothness(Smoothness.get((int)layoutData.getSmoothness()));
            }
            this.applyLabelLayout((View)gmfEdge, (AbstractLayoutData)layoutData);
        }
    }

    private void applyLabelLayout(View gmfView, AbstractLayoutData parentLayoutData) {
        if (parentLayoutData != null) {
            Node labelNode = SiriusGMFHelper.getLabelNode(gmfView);
            if (parentLayoutData.getLabel() != null && labelNode != null) {
                if (!parentLayoutData.getLabel().eIsSet((EStructuralFeature)LayoutdataPackage.eINSTANCE.getNodeLayoutData_Width()) && !parentLayoutData.getLabel().eIsSet((EStructuralFeature)LayoutdataPackage.eINSTANCE.getNodeLayoutData_Height())) {
                    Location location = NotationFactory.eINSTANCE.createLocation();
                    location.setX(parentLayoutData.getLabel().getLocation().getX());
                    location.setY(parentLayoutData.getLabel().getLocation().getY());
                    labelNode.setLayoutConstraint((LayoutConstraint)location);
                } else {
                    Bounds bounds = NotationFactory.eINSTANCE.createBounds();
                    bounds.setX(parentLayoutData.getLabel().getLocation().getX());
                    bounds.setY(parentLayoutData.getLabel().getLocation().getY());
                    bounds.setWidth(parentLayoutData.getLabel().getWidth());
                    bounds.setHeight(parentLayoutData.getLabel().getHeight());
                    labelNode.setLayoutConstraint((LayoutConstraint)bounds);
                }
            }
        }
    }

    private Bendpoints convertPointsToGMFBendpoint(EdgeLayoutData edgeLayoutData) {
        RelativeBendpoints result = NotationFactory.eINSTANCE.createRelativeBendpoints();
        LinkedList<RelativeBendpoint> relativeBendpoints = new LinkedList<RelativeBendpoint>();
        org.eclipse.sirius.diagram.layoutdata.Point source = edgeLayoutData.getSourceRefPoint();
        org.eclipse.sirius.diagram.layoutdata.Point target = edgeLayoutData.getTargetRefPoint();
        if (source != null && target != null) {
            Point sourceRefPoint = new Point(source.getX(), source.getY());
            Point targetRefPoint = new Point(target.getX(), target.getY());
            for (org.eclipse.sirius.diagram.layoutdata.Point point : edgeLayoutData.getPointList()) {
                Point tempPoint = new Point(point.getX(), point.getY());
                Dimension s = tempPoint.getDifference(sourceRefPoint);
                Dimension t = tempPoint.getDifference(targetRefPoint);
                relativeBendpoints.add(new RelativeBendpoint(s.width, s.height, t.width, t.height));
            }
        }
        result.setPoints(relativeBendpoints);
        return result;
    }

    private void applyLayout(DSemanticDecorator semanticDecorator, Node toRestoreView, EditPartViewer editPartViewer, NodeLayoutData parentLayoutData) {
        LayoutDataKey key = this.createKey(semanticDecorator);
        NodeLayoutData layoutData = (NodeLayoutData)this.getLayoutData(key);
        if (parentLayoutData != null && parentLayoutData == layoutData && !StringUtil.isEmpty((String)key.getId())) {
            layoutData = null;
            for (NodeLayoutData childLayoutData : parentLayoutData.getChildren()) {
                if (!key.getId().equals(childLayoutData.getId())) continue;
                if (layoutData == null) {
                    layoutData = childLayoutData;
                    continue;
                }
                layoutData = null;
                break;
            }
        }
        if (layoutData != null) {
            org.eclipse.sirius.diagram.layoutdata.Point locationToApply;
            Bounds bounds = NotationFactory.eINSTANCE.createBounds();
            IGraphicalEditPart graphicalEditPart = (IGraphicalEditPart)editPartViewer.getEditPartRegistry().get(toRestoreView);
            boolean isCollapsed = false;
            if (graphicalEditPart instanceof AbstractDiagramBorderNodeEditPart) {
                locationToApply = LayoutDataHelper.INSTANCE.getAbsoluteLocation(layoutData);
                Node parentNode = (Node)toRestoreView.eContainer();
                CanonicalDBorderItemLocator locator = new CanonicalDBorderItemLocator(parentNode, 29);
                if (semanticDecorator instanceof DDiagramElement) {
                    if (new DDiagramElementQuery((DDiagramElement)semanticDecorator).isIndirectlyCollapsed()) {
                        isCollapsed = true;
                        locator.setBorderItemOffset(IBorderItemOffsets.COLLAPSE_FILTER_OFFSET);
                    } else {
                        locator.setBorderItemOffset(IBorderItemOffsets.DEFAULT_OFFSET);
                    }
                } else {
                    locator.setBorderItemOffset(IBorderItemOffsets.DEFAULT_OFFSET);
                }
                Rectangle rect = new Rectangle(locationToApply.getX(), locationToApply.getY(), layoutData.getWidth(), layoutData.getHeight());
                Point realLocation = locator.getValidLocation(rect, toRestoreView, Lists.newArrayList((Object[])new Node[]{toRestoreView}));
                Point parentAbsoluteLocation = ((IGraphicalEditPart)graphicalEditPart.getParent()).getFigure().getBounds().getTopLeft().getCopy();
                FigureUtilities.translateToAbsoluteByIgnoringScrollbar((IFigure)((IGraphicalEditPart)graphicalEditPart.getParent()).getFigure(), (Point)parentAbsoluteLocation);
                locationToApply.setX(realLocation.x);
                locationToApply.setY(realLocation.y);
                locationToApply = LayoutDataHelper.INSTANCE.getTranslated(locationToApply, parentAbsoluteLocation.negate());
            } else {
                locationToApply = LayoutDataHelper.INSTANCE.getRelativeLocation(layoutData, graphicalEditPart);
                graphicalEditPart.getFigure().setLocation(new Point(locationToApply.getX(), locationToApply.getY()));
            }
            bounds.setX(locationToApply.getX());
            bounds.setY(locationToApply.getY());
            if (isCollapsed) {
                Dimension dim = new NodeQuery(toRestoreView).getCollapsedSize();
                bounds.setHeight(dim.height);
                bounds.setWidth(dim.width);
            } else {
                bounds.setHeight(layoutData.getHeight());
                bounds.setWidth(layoutData.getWidth());
            }
            toRestoreView.setLayoutConstraint((LayoutConstraint)bounds);
        }
        if (semanticDecorator instanceof DNode) {
            this.applyLayoutToNodeChildren((DNode)semanticDecorator, editPartViewer, layoutData);
        } else if (semanticDecorator instanceof DNodeContainer) {
            this.applyLayoutToNodeContainerChildren((DNodeContainer)semanticDecorator, editPartViewer, layoutData);
        } else if (semanticDecorator instanceof DNodeList) {
            this.applyLayoutToNodeListChildren((DNodeList)semanticDecorator, editPartViewer, layoutData);
        } else {
            this.logWarnMessage(semanticDecorator);
        }
        if (semanticDecorator instanceof EdgeTarget) {
            this.applyLayoutToOutgoingEdge((EdgeTarget)semanticDecorator, editPartViewer);
        }
    }

    private void logWarnMessage(DSemanticDecorator semanticDecorator) {
        Class<?> clazz = semanticDecorator.getClass();
        boolean logWarn = true;
        Class<?>[] classArray = CLASS_EXCEPTIONS;
        int n = CLASS_EXCEPTIONS.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> exceptionClass = classArray[n2];
            if (exceptionClass.isAssignableFrom(clazz)) {
                logWarn = false;
                break;
            }
            ++n2;
        }
        if (logWarn) {
            DiagramPlugin.getDefault().logWarning(MessageFormat.format(Messages.AbstractSiriusLayoutDataManager_unhandledDiagramElementKind, semanticDecorator.getClass().getName()));
        }
    }

    private void applyLayoutToNodeChildren(DNode parentNode, EditPartViewer editPartViewer, NodeLayoutData layoutData) {
        this.applyLayoutForBorderedNodes((EList<DNode>)parentNode.getOwnedBorderedNodes(), editPartViewer, layoutData);
        Node gmfNode = SiriusGMFHelper.getGmfNode((DDiagramElement)parentNode);
        this.applyLabelLayout((View)gmfNode, (AbstractLayoutData)layoutData);
    }

    private void applyLayoutToNodeContainerChildren(DNodeContainer container, EditPartViewer editPartViewer, NodeLayoutData layoutData) {
        for (DDiagramElement child : container.getOwnedDiagramElements()) {
            Node gmfNode;
            if (!(child instanceof AbstractDNode) || (gmfNode = SiriusGMFHelper.getGmfNode(child)) == null) continue;
            this.applyLayout((DSemanticDecorator)child, gmfNode, editPartViewer, layoutData);
        }
        this.applyLayoutForBorderedNodes((EList<DNode>)container.getOwnedBorderedNodes(), editPartViewer, layoutData);
        Node gmfNode = SiriusGMFHelper.getGmfNode((DDiagramElement)container);
        this.applyLabelLayout((View)gmfNode, (AbstractLayoutData)layoutData);
    }

    private void applyLayoutForBorderedNodes(EList<DNode> borderedNodes, EditPartViewer editPartViewer, NodeLayoutData parentLayoutData) {
        HashMap nodesWithLayoutDataToApply = Maps.newHashMap();
        HashMap nodesWithCoresspondingDSemanticDecorator = Maps.newHashMap();
        for (DNode child : borderedNodes) {
            Node gmfNode = SiriusGMFHelper.getGmfNode((DDiagramElement)child);
            if (gmfNode == null) continue;
            LayoutDataKey key = this.createKey((DSemanticDecorator)child);
            NodeLayoutData layoutData = (NodeLayoutData)this.getLayoutData(key);
            if (parentLayoutData != null && parentLayoutData == layoutData && !StringUtil.isEmpty((String)key.getId())) {
                layoutData = null;
                for (NodeLayoutData childLayoutData : parentLayoutData.getChildren()) {
                    if (!key.getId().equals(childLayoutData.getId())) continue;
                    if (layoutData == null) {
                        layoutData = childLayoutData;
                        continue;
                    }
                    layoutData = null;
                    break;
                }
            }
            if (layoutData == null) continue;
            nodesWithLayoutDataToApply.put(gmfNode, layoutData);
            nodesWithCoresspondingDSemanticDecorator.put(gmfNode, child);
        }
        Set<Node> toIgnore = nodesWithLayoutDataToApply.keySet();
        for (Map.Entry entry : nodesWithLayoutDataToApply.entrySet()) {
            Node node = (Node)entry.getKey();
            this.applyLayoutForBorderedNode((DSemanticDecorator)nodesWithCoresspondingDSemanticDecorator.get(node), node, editPartViewer, (NodeLayoutData)entry.getValue(), toIgnore);
        }
    }

    private void applyLayoutForBorderedNode(DSemanticDecorator semanticDecorator, Node toRestoreView, EditPartViewer editPartViewer, NodeLayoutData layoutData, Set<Node> portsNodesToIgnore) {
        org.eclipse.sirius.diagram.layoutdata.Point locationToApply;
        Bounds bounds = NotationFactory.eINSTANCE.createBounds();
        boolean isCollapsed = false;
        if (!(toRestoreView.eContainer() instanceof Node)) {
            return;
        }
        Node parentNode = (Node)toRestoreView.eContainer();
        Object parentGraphicalEditPart = editPartViewer.getEditPartRegistry().get(parentNode);
        NodeQuery nodeQuery = new NodeQuery(toRestoreView);
        if (nodeQuery.isBorderedNode() && parentGraphicalEditPart instanceof IGraphicalEditPart) {
            locationToApply = LayoutDataHelper.INSTANCE.getAbsoluteLocation(layoutData);
            CanonicalDBorderItemLocator locator = new CanonicalDBorderItemLocator(parentNode, 29);
            if (semanticDecorator instanceof DDiagramElement) {
                if (new DDiagramElementQuery((DDiagramElement)semanticDecorator).isIndirectlyCollapsed()) {
                    isCollapsed = true;
                    locator.setBorderItemOffset(IBorderItemOffsets.COLLAPSE_FILTER_OFFSET);
                } else {
                    locator.setBorderItemOffset(IBorderItemOffsets.DEFAULT_OFFSET);
                }
            } else {
                locator.setBorderItemOffset(IBorderItemOffsets.DEFAULT_OFFSET);
            }
            org.eclipse.sirius.diagram.layoutdata.Point delta = this.getGMFDraw2DDelta(parentNode, (IGraphicalEditPart)parentGraphicalEditPart);
            Rectangle rect = new Rectangle(locationToApply.getX() - delta.getX(), locationToApply.getY() - delta.getY(), layoutData.getWidth(), layoutData.getHeight());
            Point realLocation = locator.getValidLocation(rect, toRestoreView, portsNodesToIgnore);
            Point parentAbsoluteLocation = GMFHelper.getAbsoluteBounds(parentNode).getTopLeft();
            locationToApply.setX(realLocation.x);
            locationToApply.setY(realLocation.y);
            locationToApply = LayoutDataHelper.INSTANCE.getTranslated(locationToApply, parentAbsoluteLocation.negate());
        } else {
            Object graphicalEditPart = editPartViewer.getEditPartRegistry().get(toRestoreView);
            if (graphicalEditPart instanceof IGraphicalEditPart) {
                locationToApply = LayoutDataHelper.INSTANCE.getRelativeLocation(layoutData, (IGraphicalEditPart)graphicalEditPart);
                ((GraphicalEditPart)graphicalEditPart).getFigure().setLocation(new Point(locationToApply.getX(), locationToApply.getY()));
            } else {
                locationToApply = LayoutdataFactory.eINSTANCE.createPoint();
            }
        }
        bounds.setX(locationToApply.getX());
        bounds.setY(locationToApply.getY());
        if (isCollapsed) {
            Dimension dim = new NodeQuery(toRestoreView).getCollapsedSize();
            bounds.setHeight(dim.height);
            bounds.setWidth(dim.width);
        } else {
            bounds.setHeight(layoutData.getHeight());
            bounds.setWidth(layoutData.getWidth());
        }
        toRestoreView.setLayoutConstraint((LayoutConstraint)bounds);
        if (semanticDecorator instanceof DNode) {
            this.applyLayoutToNodeChildren((DNode)semanticDecorator, editPartViewer, layoutData);
        } else if (semanticDecorator instanceof DNodeContainer) {
            this.applyLayoutToNodeContainerChildren((DNodeContainer)semanticDecorator, editPartViewer, layoutData);
        } else if (semanticDecorator instanceof DNodeList) {
            this.applyLayoutToNodeListChildren((DNodeList)semanticDecorator, editPartViewer, layoutData);
        } else {
            this.logWarnMessage(semanticDecorator);
        }
        if (semanticDecorator instanceof EdgeTarget) {
            this.applyLayoutToOutgoingEdge((EdgeTarget)semanticDecorator, editPartViewer);
        }
    }

    private org.eclipse.sirius.diagram.layoutdata.Point getGMFDraw2DDelta(Node parentNode, IGraphicalEditPart parentEditPart) {
        org.eclipse.sirius.diagram.layoutdata.Point delta = LayoutdataFactory.eINSTANCE.createPoint();
        Point parentDraw2DAbsoluteLocation = parentEditPart.getFigure().getBounds().getTopLeft().getCopy();
        FigureUtilities.translateToAbsoluteByIgnoringScrollbar((IFigure)parentEditPart.getFigure(), (Point)parentDraw2DAbsoluteLocation);
        Point parentGMFAbsoluteLocation = GMFHelper.getAbsoluteLocation(parentNode);
        delta.setX(parentDraw2DAbsoluteLocation.x - parentGMFAbsoluteLocation.x);
        delta.setY(parentDraw2DAbsoluteLocation.y - parentGMFAbsoluteLocation.y);
        return delta;
    }

    private void applyLayoutToNodeListChildren(DNodeList nodeList, EditPartViewer editPartViewer, NodeLayoutData layoutData) {
        this.applyLayoutForBorderedNodes((EList<DNode>)nodeList.getOwnedBorderedNodes(), editPartViewer, layoutData);
        Node gmfNode = SiriusGMFHelper.getGmfNode((DDiagramElement)nodeList);
        this.applyLabelLayout((View)gmfNode, (AbstractLayoutData)layoutData);
    }

    protected void addNodeChildren(DNode parentNode, NodeLayoutData parentLayoutData, IGraphicalEditPart parentEditPart, View gmfView, Collection<LayoutDataKey> discoveredKeys) {
        for (DNode child : parentNode.getOwnedBorderedNodes()) {
            this.checkDataAndAddChildLayout(parentLayoutData, (AbstractDNode)child, parentEditPart, discoveredKeys);
        }
        this.addLabelLayoutData((AbstractLayoutData)parentLayoutData, gmfView);
    }

    protected void checkDataAndAddChildLayout(NodeLayoutData parentLayoutData, AbstractDNode child, IGraphicalEditPart parentSavedEditPart, Collection<LayoutDataKey> discoveredKeys) {
        IGraphicalEditPart editPart;
        Node gmfNode = SiriusGMFHelper.getGmfNode((DDiagramElement)child);
        if (gmfNode != null && (editPart = (IGraphicalEditPart)parentSavedEditPart.getRoot().getViewer().getEditPartRegistry().get(gmfNode)) != null) {
            this.addChildLayout(parentLayoutData, (DSemanticDecorator)child, gmfNode, editPart, discoveredKeys);
        }
    }

    protected void addNodeContainerChildren(DNodeContainer container, NodeLayoutData parentLayoutData, IGraphicalEditPart parentEditPart, Collection<LayoutDataKey> discoveredKeys) {
        for (DDiagramElement child : container.getOwnedDiagramElements()) {
            if (!(child instanceof AbstractDNode)) continue;
            this.checkDataAndAddChildLayout(parentLayoutData, (AbstractDNode)child, parentEditPart, discoveredKeys);
        }
        for (DDiagramElement child : container.getOwnedBorderedNodes()) {
            this.checkDataAndAddChildLayout(parentLayoutData, (AbstractDNode)child, parentEditPart, discoveredKeys);
        }
    }

    protected void addNodeListChildren(DNodeList nodeList, NodeLayoutData parentLayoutData, IGraphicalEditPart parentEditPart, Collection<LayoutDataKey> discoveredKeys) {
        for (DNode child : nodeList.getOwnedBorderedNodes()) {
            this.checkDataAndAddChildLayout(parentLayoutData, (AbstractDNode)child, parentEditPart, discoveredKeys);
        }
    }

    private void addChildLayout(DDiagram diagram, IGraphicalEditPart diagramEditPart, Collection<LayoutDataKey> discoveredKeys) {
        for (AbstractDNode child : Iterables.filter((Iterable)diagram.getOwnedDiagramElements(), AbstractDNode.class)) {
            IGraphicalEditPart editPart;
            Node gmfNode = SiriusGMFHelper.getGmfNode((DDiagramElement)child);
            if (gmfNode == null || (editPart = (IGraphicalEditPart)diagramEditPart.getRoot().getViewer().getEditPartRegistry().get(gmfNode)) == null) continue;
            this.addChildLayout(null, (DSemanticDecorator)child, gmfNode, editPart, discoveredKeys);
        }
    }

    private void addChildLayout(NodeLayoutData parentLayoutData, DSemanticDecorator child, Node gmfNode, IGraphicalEditPart editPart, Collection<LayoutDataKey> discoveredKeys) {
        NodeLayoutData childLayoutData = LayoutDataHelper.INSTANCE.createNodeLayoutData(gmfNode, editPart, parentLayoutData);
        if (parentLayoutData != null) {
            parentLayoutData.getChildren().add((Object)childLayoutData);
        }
        LayoutDataKey childKey = this.createKey(child);
        childLayoutData.setId(childKey.getId());
        if (!discoveredKeys.contains(childKey)) {
            this.addLayoutData(childKey, (AbstractLayoutData)childLayoutData);
            discoveredKeys.add(childKey);
        } else if (parentLayoutData == null) {
            this.addLayoutData(childKey, (AbstractLayoutData)childLayoutData);
        }
        if (child instanceof DNode) {
            this.addNodeChildren((DNode)child, childLayoutData, editPart, (View)gmfNode, discoveredKeys);
        } else if (child instanceof DNodeContainer) {
            this.addNodeContainerChildren((DNodeContainer)child, childLayoutData, editPart, discoveredKeys);
        } else if (child instanceof DNodeList) {
            this.addNodeListChildren((DNodeList)child, childLayoutData, editPart, discoveredKeys);
        } else {
            this.logWarnMessage(child);
        }
        if (child instanceof EdgeTarget) {
            this.addOutgoingEdge(childLayoutData, (EdgeTarget)child, editPart.getRoot().getViewer());
        }
    }

    protected void addOutgoingEdge(NodeLayoutData parentLayoutData, EdgeTarget sourceOfEdge, EditPartViewer editPartViewer) {
        for (DEdge outgoingEdge : sourceOfEdge.getOutgoingEdges()) {
            this.addEdgeLayoutData(parentLayoutData, outgoingEdge, editPartViewer);
        }
    }

    protected void addEdgeLayoutData(NodeLayoutData parentLayoutData, DEdge edge, EditPartViewer editPartViewer) {
        Edge gmfEdge = SiriusGMFHelper.getGmfEdge((DDiagramElement)edge);
        if (gmfEdge != null) {
            EdgeLayoutData edgeLayoutData = LayoutDataHelper.INSTANCE.createEdgeLayoutData(gmfEdge, (ConnectionEditPart)editPartViewer.getEditPartRegistry().get(gmfEdge));
            if (parentLayoutData != null) {
                parentLayoutData.getOutgoingEdges().add((Object)edgeLayoutData);
            }
            LayoutDataKey edgeKey = this.createKey((DSemanticDecorator)edge);
            edgeLayoutData.setId(edgeKey.getId());
            this.addLayoutData(edgeKey, (AbstractLayoutData)edgeLayoutData);
            this.addLabelLayoutData((AbstractLayoutData)edgeLayoutData, (View)gmfEdge);
        }
    }

    private void addLabelLayoutData(AbstractLayoutData parentLayoutData, View gmfElement) {
        Node labelNode = SiriusGMFHelper.getLabelNode(gmfElement);
        if (labelNode != null && parentLayoutData != null) {
            NodeLayoutData labelLayoutData = LayoutDataHelper.INSTANCE.createLabelLayoutData(labelNode);
            if (labelNode.getElement() instanceof DSemanticDecorator) {
                labelLayoutData.setId(this.createKey((DSemanticDecorator)labelNode.getElement()).getId());
            }
            parentLayoutData.setLabel(labelLayoutData);
        }
    }
}

