/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.internal.dialect.identifier;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.dialect.identifier.AbstractRepresentationElementIdentifier;
import org.eclipse.sirius.common.tools.api.util.EqualityHelper;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.Messages;
import org.eclipse.sirius.diagram.business.internal.dialect.identifier.NodeContainerIdentifier;

public class NodeIdentifier
extends AbstractRepresentationElementIdentifier
implements NodeContainerIdentifier {
    private EObject semantic;
    private String mappingName;
    private NodeContainerIdentifier parent;

    public NodeIdentifier(AbstractDNode node, NodeContainerIdentifier parent) {
        this(node.getTarget(), node.getDiagramElementMapping().getName(), parent);
    }

    public NodeIdentifier(EObject semantic, String mappingName, NodeContainerIdentifier parent) {
        if (semantic == null || mappingName == null) {
            throw new IllegalArgumentException(Messages.NodeIdentifier_parametersErrorMsg);
        }
        this.semantic = semantic;
        this.mappingName = mappingName;
        this.parent = parent;
    }

    public boolean equals(Object obj) {
        boolean result = true;
        result = result && obj instanceof NodeIdentifier;
        result = result && EqualityHelper.areEquals((EObject)((NodeIdentifier)obj).semantic, (EObject)this.semantic);
        boolean bl = result = result && ((NodeIdentifier)obj).mappingName.equals(this.mappingName);
        if (result) {
            NodeContainerIdentifier parent1 = this.parent;
            NodeContainerIdentifier parent2 = ((NodeIdentifier)obj).parent;
            result = result && parent1 == null && parent2 == null || parent2 != null && parent1.equals(parent2);
        }
        return result;
    }

    public int uniqueID() {
        int result = 1;
        result = 31 * result + this.semantic.hashCode();
        result = 31 * result + this.mappingName.hashCode();
        result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
        return result;
    }
}

