/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.internal.helper.display;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.common.tools.DslCommonPlugin;
import org.eclipse.sirius.common.tools.api.listener.NotificationUtil;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.diagram.GraphicalFilter;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramMappingsManager;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramMappingsManagerRegistry;
import org.eclipse.sirius.diagram.business.api.helper.display.DisplayService;
import org.eclipse.sirius.diagram.business.api.query.DDiagramElementQuery;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.LayerHelper;
import org.eclipse.sirius.tools.api.profiler.SiriusTasksKey;

public final class DisplayServiceImpl
implements DisplayService {
    private Map<DDiagramElement, Boolean> cache;

    private DisplayServiceImpl() {
    }

    public static DisplayService init() {
        return new DisplayServiceImpl();
    }

    @Override
    public void refreshAllElementsVisibility(DDiagram diagram) {
        this.deactivateCache();
        this.activateCache();
        Session session = SessionManager.INSTANCE.getSession(((DSemanticDiagram)diagram).getTarget());
        DiagramMappingsManager mappingManager = DiagramMappingsManagerRegistry.INSTANCE.getDiagramMappingsManager(session, diagram);
        NotificationUtil.sendNotification((EObject)diagram, (int)0, (int)3);
        DslCommonPlugin.PROFILER.startWork(SiriusTasksKey.IS_VISIBLE_KEY);
        for (DDiagramElement diagramElement : diagram.getDiagramElements()) {
            diagramElement.setVisible(this.computeVisibility(mappingManager, diagram, diagramElement));
        }
        DslCommonPlugin.PROFILER.stopWork(SiriusTasksKey.IS_VISIBLE_KEY);
        NotificationUtil.sendNotification((EObject)diagram, (int)1, (int)3);
        this.deactivateCache();
    }

    @Override
    public boolean isDisplayed(DDiagram diagram, DDiagramElement element) {
        DslCommonPlugin.PROFILER.startWork(SiriusTasksKey.IS_VISIBLE_KEY);
        boolean result = element.isVisible();
        DslCommonPlugin.PROFILER.stopWork(SiriusTasksKey.IS_VISIBLE_KEY);
        return result;
    }

    private void addToCache(DDiagramElement element, boolean b) {
        if (this.cache != null) {
            this.cache.put(element, b);
        }
    }

    private Boolean getFromCache(DDiagramElement element) {
        Boolean visible = null;
        if (this.cache != null) {
            visible = this.cache.get(element);
        }
        return visible;
    }

    @Override
    public void activateCache() {
        if (this.cache == null) {
            this.cache = new HashMap<DDiagramElement, Boolean>();
        }
    }

    @Override
    public void deactivateCache() {
        if (this.cache != null) {
            this.cache.clear();
            this.cache = null;
        }
    }

    @Override
    public boolean computeVisibility(DiagramMappingsManager session, DDiagram diagram, DDiagramElement element) {
        DslCommonPlugin.PROFILER.startWork(SiriusTasksKey.REFRESH_VISIBILITY_KEY);
        boolean result = this.doIsVisible(session, diagram, element);
        DslCommonPlugin.PROFILER.stopWork(SiriusTasksKey.REFRESH_VISIBILITY_KEY);
        return result;
    }

    @Override
    public boolean computeLabelVisibility(DDiagram diagram, DDiagramElement element) {
        return !new DDiagramElementQuery(element).isLabelHidden();
    }

    private boolean doIsVisible(DiagramMappingsManager diagramMappingsManager, DDiagram diagram, DDiagramElement element) {
        boolean isVisible = true;
        Boolean cachedValue = this.getFromCache(element);
        if (cachedValue != null) {
            isVisible = cachedValue;
        } else {
            DDiagramElementQuery ddeQuery = new DDiagramElementQuery(element);
            if (ddeQuery.isHidden() || ddeQuery.isFiltered()) {
                isVisible = false;
            }
            if (isVisible) {
                EObject eContainer = element.eContainer();
                if (eContainer instanceof DDiagramElement) {
                    isVisible = this.computeVisibility(diagramMappingsManager, diagram, (DDiagramElement)eContainer);
                } else if (element instanceof DEdge) {
                    isVisible = this.isDEdgeVisible(diagramMappingsManager, diagram, (DEdge)element);
                }
            }
            if (isVisible) {
                isVisible = LayerHelper.isInActivatedLayer(diagramMappingsManager, element);
            }
            if (isVisible) {
                isVisible = !this.isFold(element);
            }
            this.addToCache(element, isVisible);
        }
        return isVisible;
    }

    private boolean isDEdgeVisible(DiagramMappingsManager diagramMappingsManager, DDiagram vp, DEdge edge) {
        boolean isVisible = true;
        if (edge.getSourceNode() instanceof DDiagramElement) {
            isVisible = this.computeVisibility(diagramMappingsManager, vp, (DDiagramElement)((Object)edge.getSourceNode()));
        }
        if (isVisible && edge.getTargetNode() instanceof DDiagramElement) {
            isVisible = this.computeVisibility(diagramMappingsManager, vp, (DDiagramElement)((Object)edge.getTargetNode()));
        }
        return isVisible;
    }

    private boolean isFold(DDiagramElement element) {
        return Iterables.any(element.getGraphicalFilters(), (Predicate)new Predicate<GraphicalFilter>(){

            public boolean apply(GraphicalFilter input) {
                return DiagramPackage.eINSTANCE.getFoldingFilter().isInstance((Object)input) || DiagramPackage.eINSTANCE.getFoldingPointFilter().isInstance((Object)input);
            }
        });
    }
}

