/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.commands;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionStatus;
import org.eclipse.sirius.common.ui.tools.api.util.SWTUtil;
import org.eclipse.sirius.ui.business.api.session.IEditingSession;
import org.eclipse.sirius.ui.business.api.session.SessionUIManager;
import org.eclipse.sirius.viewpoint.provider.Messages;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class CloseUISessionCommand
extends WorkspaceModifyOperation {
    private Session session;

    public CloseUISessionCommand(Session session) {
        this.session = session;
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        monitor.beginTask(Messages.CloseUISessionCommand_closeRepresentationFileTask, -1);
        if (this.session == null) {
            return;
        }
        if (this.session.isOpen()) {
            boolean saveSession = false;
            try {
                int choice = 0;
                if (this.session.getStatus() == SessionStatus.DIRTY) {
                    choice = SWTUtil.showSaveDialog((Object)this.session, (String)Messages.CloseUISessionCommand_saveDialogTitle, (boolean)false);
                    boolean bl = saveSession = choice == 0;
                }
                if (choice == 2) {
                    return;
                }
            }
            catch (IllegalStateException e) {
                SiriusEditPlugin.getPlugin().getLog().log((IStatus)new Status(2, "org.eclipse.sirius", Messages.CloseUISessionCommand_closingError, (Throwable)e));
            }
            IEditingSession ui = SessionUIManager.INSTANCE.getUISession(this.session);
            if (ui != null) {
                if (saveSession && this.session.isOpen()) {
                    monitor.worked(1);
                    this.session.save((IProgressMonitor)new NullProgressMonitor());
                    monitor.worked(1);
                }
                try {
                    ui.close(saveSession);
                }
                catch (IllegalStateException e) {
                    SiriusEditPlugin.getPlugin().getLog().log((IStatus)new Status(2, "org.eclipse.sirius", Messages.CloseUISessionCommand_closingError, (Throwable)e));
                }
                monitor.worked(1);
                ui.close();
            }
        }
        monitor.done();
    }
}

