/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.views.common.item;

import com.google.common.base.Function;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.ui.tools.api.views.common.item.ItemWrapper;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;

public class RepresentationItemImpl
implements ItemWrapper,
IAdaptable {
    public static final Function<RepresentationItemImpl, DRepresentation> REPRESENTATION_ITEM_TO_REPRESENTATION = new Function<RepresentationItemImpl, DRepresentation>(){

        public DRepresentation apply(RepresentationItemImpl from) {
            return from.getRepresentation();
        }
    };
    private final WeakReference<DRepresentation> rep;
    private final Object parent;

    public RepresentationItemImpl(DRepresentation rep, Object parent) {
        this.rep = new WeakReference<DRepresentation>(rep);
        this.parent = parent;
    }

    @Override
    public Object getWrappedObject() {
        return this.rep.get();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
        result = 31 * result + (this.rep.get() == null ? 0 : ((DRepresentation)this.rep.get()).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        boolean result = true;
        if (this == obj) {
            result = true;
        } else if (obj == null) {
            result = false;
        } else if (this.getClass() != obj.getClass()) {
            result = false;
        } else {
            RepresentationItemImpl other = (RepresentationItemImpl)obj;
            if (this.parent == null) {
                if (other.parent != null) {
                    result = false;
                }
            } else if (!this.parent.equals(other.parent)) {
                result = false;
            }
            if (this.rep.get() == null) {
                if (other.rep.get() != null) {
                    result = false;
                }
            } else if (!((DRepresentation)this.rep.get()).equals(other.rep.get())) {
                result = false;
            }
        }
        return result;
    }

    public Collection<?> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public Option<Session> getSession() {
        Session session = null;
        if (this.rep.get() instanceof DSemanticDecorator) {
            session = SessionManager.INSTANCE.getSession(((DSemanticDecorator)this.rep.get()).getTarget());
        }
        return Options.newSome(session);
    }

    public Object getAdapter(Class adapter) {
        if (this.rep.get() != null && adapter == EObject.class) {
            return this.rep.get();
        }
        return null;
    }

    public Object getParent() {
        return this.parent;
    }

    public DRepresentation getRepresentation() {
        return (DRepresentation)this.rep.get();
    }
}

